/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles;

import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import mekanism.api.chemical.gas.IGasHandler;
import net.minecraft.MethodsReturnNonnullByDefault;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.CapabilityManager;
import net.minecraftforge.common.capabilities.CapabilityToken;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.templates.FluidTank;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.HeatExchangerMultiblockController;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.blocks.HeatExchangerFluidPortBlock;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.containers.HeatExchangerFluidPortContainer;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.state.HeatExchangerFluidPortState;
import net.roguelogix.biggerreactors.multiblocks.heatexchanger.tiles.HeatExchangerBaseTile;
import net.roguelogix.phosphophyllite.client.gui.api.IHasUpdatableState;
import net.roguelogix.phosphophyllite.fluids.FluidHandlerWrapper;
import net.roguelogix.phosphophyllite.fluids.IPhosphophylliteFluidHandler;
import net.roguelogix.phosphophyllite.fluids.MekanismGasWrappers;
import net.roguelogix.phosphophyllite.multiblock.common.IEventMultiblock;
import net.roguelogix.phosphophyllite.multiblock.validated.IValidatedMultiblock;
import net.roguelogix.phosphophyllite.registry.RegisterTile;
import net.roguelogix.phosphophyllite.util.BlockStates;

@MethodsReturnNonnullByDefault
@ParametersAreNonnullByDefault
public class HeatExchangerFluidPortTile
extends HeatExchangerBaseTile
implements IPhosphophylliteFluidHandler,
IEventMultiblock.AssemblyStateTransition.OnAssembly,
IEventMultiblock.AssemblyStateTransition.OnDisassembly,
MenuProvider,
IHasUpdatableState<HeatExchangerFluidPortState> {
    public long lastCheckedTick;
    @RegisterTile(value="heat_exchanger_fluid_port")
    public static final BlockEntityType.BlockEntitySupplier<HeatExchangerFluidPortTile> SUPPLIER = new RegisterTile.Producer(HeatExchangerFluidPortTile::new);
    private static final Capability<IGasHandler> GAS_HANDLER_CAPABILITY = CapabilityManager.get((CapabilityToken)new CapabilityToken<IGasHandler>(){});
    private IPhosphophylliteFluidHandler HETank;
    private boolean inlet = true;
    private boolean condenser = true;
    private boolean connected = false;
    Direction outputDirection = null;
    LazyOptional<?> handlerOptional = LazyOptional.empty();
    IPhosphophylliteFluidHandler handler = null;
    FluidTank EMPTY_TANK = new FluidTank(0);
    private final HeatExchangerFluidPortState state = new HeatExchangerFluidPortState(this);

    public HeatExchangerFluidPortTile(BlockEntityType<?> tileEntityTypeIn, BlockPos pos, BlockState state) {
        super(tileEntityTypeIn, pos, state);
    }

    public <T> LazyOptional<T> capability(Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandlerCapability().cast();
        }
        if (cap == GAS_HANDLER_CAPABILITY) {
            return LazyOptional.of(() -> MekanismGasWrappers.wrap((IPhosphophylliteFluidHandler)this)).cast();
        }
        return super.capability(cap, side);
    }

    public void setHETank(IPhosphophylliteFluidHandler HETank) {
        this.HETank = HETank;
    }

    public void setInlet(boolean inlet) {
        assert (this.f_58857_ != null);
        this.inlet = inlet;
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStates.PORT_DIRECTION, (Comparable)Boolean.valueOf(inlet)), 3);
        this.m_6596_();
    }

    public void setInletOtherOutlet(boolean inlet) {
        ((HeatExchangerMultiblockController)this.controller()).setInletPort(this, inlet);
    }

    public boolean isInlet() {
        return this.inlet;
    }

    public void setCondenser(boolean condenser) {
        this.condenser = condenser;
        assert (this.f_58857_ != null);
        this.f_58857_.m_7731_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)HeatExchangerFluidPortBlock.CONDENSER, (Comparable)Boolean.valueOf(condenser)), 3);
    }

    public boolean isCondenser() {
        return this.condenser;
    }

    public int tankCount() {
        if (this.HETank == null) {
            return 0;
        }
        return this.HETank.tankCount();
    }

    public long tankCapacity(int tank) {
        if (this.HETank == null) {
            return 0L;
        }
        return this.HETank.tankCapacity(tank);
    }

    public Fluid fluidTypeInTank(int tank) {
        if (this.HETank == null) {
            return Fluids.f_76191_;
        }
        return this.HETank.fluidTypeInTank(tank);
    }

    @Nullable
    public CompoundTag fluidTagInTank(int tank) {
        if (this.HETank == null) {
            return null;
        }
        return this.HETank.fluidTagInTank(tank);
    }

    public long fluidAmountInTank(int tank) {
        if (this.HETank == null) {
            return 0L;
        }
        return this.HETank.fluidAmountInTank(tank);
    }

    public boolean fluidValidForTank(int tank, Fluid fluid) {
        if (this.HETank == null) {
            return false;
        }
        return this.HETank.fluidValidForTank(tank, fluid);
    }

    public long fill(Fluid fluid, @Nullable CompoundTag tag, long amount, boolean simulate) {
        if (this.HETank == null || !this.inlet) {
            return 0L;
        }
        return this.HETank.fill(fluid, null, amount, simulate);
    }

    public long drain(Fluid fluid, @Nullable CompoundTag tag, long amount, boolean simulate) {
        if (this.HETank == null || this.inlet) {
            return 0L;
        }
        return this.HETank.drain(fluid, null, amount, simulate);
    }

    public long pushFluid() {
        if (!this.connected || this.inlet) {
            return 0L;
        }
        if (this.handlerOptional.isPresent()) {
            Fluid fluid = this.HETank.fluidTypeInTank(1);
            long amount = this.HETank.fluidAmountInTank(1);
            amount = this.HETank.drain(fluid, null, amount, true);
            amount = this.handler.fill(fluid, null, amount, false);
            amount = this.HETank.drain(fluid, null, amount, false);
            return amount;
        }
        this.handlerOptional = LazyOptional.empty();
        this.handler = null;
        this.connected = false;
        return 0L;
    }

    public void neighborChanged() {
        LazyOptional gasOptional;
        this.handlerOptional = LazyOptional.empty();
        this.handler = null;
        if (this.outputDirection == null) {
            this.connected = false;
            return;
        }
        assert (this.f_58857_ != null);
        BlockEntity te = this.f_58857_.m_7702_(this.f_58858_.m_121945_(this.outputDirection));
        if (te == null) {
            this.connected = false;
            return;
        }
        this.connected = false;
        LazyOptional waterOutput = te.getCapability(ForgeCapabilities.FLUID_HANDLER, this.outputDirection.m_122424_());
        if (waterOutput.isPresent()) {
            this.connected = true;
            this.handlerOptional = waterOutput;
            this.handler = FluidHandlerWrapper.wrap((IFluidHandler)((IFluidHandler)waterOutput.orElse((Object)this.EMPTY_TANK)));
        } else if (GAS_HANDLER_CAPABILITY != null && (gasOptional = te.getCapability(GAS_HANDLER_CAPABILITY, this.outputDirection.m_122424_())).isPresent()) {
            IGasHandler gasHandler = (IGasHandler)gasOptional.orElse((Object)MekanismGasWrappers.EMPTY_TANK);
            this.connected = true;
            this.handlerOptional = gasOptional;
            this.handler = MekanismGasWrappers.wrap((IGasHandler)gasHandler);
        }
    }

    protected void readNBT(CompoundTag compound) {
        super.readNBT(compound);
        this.inlet = compound.m_128471_("inlet");
    }

    protected CompoundTag writeNBT() {
        CompoundTag nbt = super.writeNBT();
        nbt.m_128379_("inlet", this.inlet);
        return nbt;
    }

    public void onAssemblyStateTransition(IValidatedMultiblock.AssemblyState oldState, IValidatedMultiblock.AssemblyState newState) {
        super.onAssemblyStateTransition(oldState, newState);
        super.onAssemblyStateTransition(oldState, newState);
    }

    public void onAssembly() {
        this.outputDirection = (Direction)this.m_58900_().m_61143_((Property)BlockStates.FACING);
        this.neighborChanged();
    }

    public void onDisassembly() {
        this.outputDirection = null;
        this.HETank = null;
        this.neighborChanged();
    }

    public HeatExchangerFluidPortState getState() {
        return this.state;
    }

    public void updateState() {
        this.state.direction = this.isInlet();
        this.state.condenser = this.isCondenser();
    }

    public Component m_5446_() {
        return Component.m_237115_((String)HeatExchangerFluidPortBlock.INSTANCE.m_7705_());
    }

    @Nullable
    public AbstractContainerMenu m_7208_(int windowId, Inventory playerInventory, Player player) {
        return new HeatExchangerFluidPortContainer(windowId, this.f_58858_, player);
    }

    @Override
    public void runRequest(String requestName, Object requestData) {
        if (requestName.equals("setDirection")) {
            int direction = (Integer)requestData;
            this.setInletOtherOutlet(direction == 0);
        }
        super.runRequest(requestName, requestData);
    }
}

