/*
 * Decompiled with CFR 0.152.
 */
package net.roguelogix.biggerreactors.multiblocks.reactor.client;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.level.material.Fluid;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.roguelogix.biggerreactors.client.CommonButton;
import net.roguelogix.biggerreactors.client.TextBox;
import net.roguelogix.biggerreactors.fluids.LiquidUranium;
import net.roguelogix.biggerreactors.multiblocks.reactor.containers.ReactorControlRodContainer;
import net.roguelogix.biggerreactors.multiblocks.reactor.state.ReactorControlRodState;
import net.roguelogix.phosphophyllite.client.gui.RenderHelper;
import net.roguelogix.phosphophyllite.client.gui.elements.AbstractElement;
import net.roguelogix.phosphophyllite.client.gui.elements.InteractiveElement;
import net.roguelogix.phosphophyllite.client.gui.elements.RenderedElement;
import net.roguelogix.phosphophyllite.client.gui.screens.PhosphophylliteScreen;

@OnlyIn(value=Dist.CLIENT)
public class ReactorControlRodScreen
extends PhosphophylliteScreen<ReactorControlRodContainer> {
    private static final ResourceLocation DEFAULT_TEXTURE = new ResourceLocation("biggerreactors", "textures/screen/reactor_control_rod.png");
    private ReactorControlRodState reactorControlRodState = (ReactorControlRodState)((ReactorControlRodContainer)this.m_6262_()).getGuiPacket();

    public ReactorControlRodScreen(ReactorControlRodContainer container, Inventory playerInventory, Component title) {
        super((AbstractContainerMenu)container, playerInventory, title, DEFAULT_TEXTURE, 136, 126);
    }

    public void m_7856_() {
        super.m_7856_();
        this.f_97728_ = (this.f_97726_ - this.f_96547_.m_92852_((FormattedText)this.m_96636_())) / 2;
        this.initControls();
        this.initGauges();
    }

    public void initControls() {
        TextBox<ReactorControlRodContainer> textBox = new TextBox<ReactorControlRodContainer>(this, this.f_96547_, 6, 26, 96, 16, this.reactorControlRodState.name);
        this.addScreenElement((AbstractElement)textBox);
        InteractiveElement textBoxEnterButton = new InteractiveElement((PhosphophylliteScreen)this, 114, 27, 17, 14, 194, 0, (Component)Component.m_237115_((String)"screen.biggerreactors.reactor_control_rod.apply.tooltip"));
        textBoxEnterButton.onMouseReleased = (mX, mY, btn) -> {
            if (textBoxEnterButton.m_5953_(mX, mY)) {
                ((ReactorControlRodContainer)this.m_6262_()).executeRequest("setName", textBox.getContents());
                textBoxEnterButton.playSound(SoundEvents.f_12490_);
                return true;
            }
            return false;
        };
        textBoxEnterButton.onRender = (mS, mX, mY) -> {
            if (textBoxEnterButton.m_5953_((double)mX, (double)mY)) {
                textBoxEnterButton.blit(mS, 211, 0);
            } else {
                textBoxEnterButton.blit(mS, 194, 0);
            }
        };
        CommonButton<ReactorControlRodContainer> textEnterButton = new CommonButton<ReactorControlRodContainer>(this, 114, 27, 17, 14, 61, 130, (Component)Component.m_237115_((String)"screen.biggerreactors.reactor_redstone_port.apply.tooltip"));
        textEnterButton.onMouseReleased = (mX, mY, btn) -> {
            ((ReactorControlRodContainer)this.m_6262_()).executeRequest("setName", textBox.getContents());
            return true;
        };
        this.addScreenElement((AbstractElement)textEnterButton);
        InteractiveElement rodRetractButton = new InteractiveElement((PhosphophylliteScreen)this, 58, 82, 14, 15, 226, 0, (Component)Component.m_237115_((String)"screen.biggerreactors.reactor_control_rod.retract_rod.tooltip"));
        rodRetractButton.onMouseReleased = (mX, mY, btn) -> {
            if (rodRetractButton.m_5953_(mX, mY)) {
                double delta = Screen.m_96638_() && Screen.m_96637_() ? -100.0 : (Screen.m_96637_() ? -50.0 : (Screen.m_96638_() ? -10.0 : -1.0));
                ((ReactorControlRodContainer)this.m_6262_()).executeRequest("changeInsertionLevel", new Pair((Object)delta, (Object)Screen.m_96639_()));
                rodRetractButton.playSound(SoundEvents.f_12490_);
                return true;
            }
            return false;
        };
        rodRetractButton.onRender = (mS, mX, mY) -> {
            if (rodRetractButton.m_5953_((double)mX, (double)mY)) {
                rodRetractButton.blit(mS, 242, 0);
            } else {
                rodRetractButton.blit(mS, 228, 0);
            }
        };
        this.addScreenElement((AbstractElement)rodRetractButton);
        InteractiveElement rodInsertButton = new InteractiveElement((PhosphophylliteScreen)this, 58, 64, 14, 15, 226, 0, (Component)Component.m_237115_((String)"screen.biggerreactors.reactor_control_rod.insert_rod.tooltip"));
        rodInsertButton.onMouseReleased = (mX, mY, btn) -> {
            if (rodInsertButton.m_5953_(mX, mY)) {
                double delta = Screen.m_96638_() && Screen.m_96637_() ? 100.0 : (Screen.m_96637_() ? 50.0 : (Screen.m_96638_() ? 10.0 : 1.0));
                ((ReactorControlRodContainer)this.m_6262_()).executeRequest("changeInsertionLevel", new Pair((Object)delta, (Object)Screen.m_96639_()));
                rodInsertButton.playSound(SoundEvents.f_12490_);
                return true;
            }
            return false;
        };
        rodInsertButton.onRender = (mS, mX, mY) -> {
            if (rodInsertButton.m_5953_((double)mX, (double)mY)) {
                rodInsertButton.blit(mS, 242, 15);
            } else {
                rodInsertButton.blit(mS, 228, 15);
            }
        };
        this.addScreenElement((AbstractElement)rodInsertButton);
    }

    public void initGauges() {
        RenderedElement rodInsertionGauge = new RenderedElement((PhosphophylliteScreen)this, 36, 50, 18, 64, 0, 126, (Component)Component.m_237119_());
        rodInsertionGauge.onRender = (graphics, mX, mY) -> ReactorControlRodScreen.renderInsertionLevel(graphics, (RenderedElement<ReactorControlRodContainer>)rodInsertionGauge, this.reactorControlRodState.insertionLevel);
        this.addScreenElement((AbstractElement)rodInsertionGauge);
    }

    public void m_88315_(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        graphics.m_280056_(this.getFont(), Component.m_237115_((String)"screen.biggerreactors.reactor_control_rod.name").getString(), this.getGuiLeft() + 8, this.getGuiTop() + 17, 0x404040, false);
        graphics.m_280056_(this.getFont(), String.format("%.1f%%", this.reactorControlRodState.insertionLevel), this.getGuiLeft() + 76, this.getGuiTop() + 77, 0x404040, false);
    }

    public static void renderInsertionLevel(@Nonnull GuiGraphics graphics, @Nonnull RenderedElement<ReactorControlRodContainer> symbol, double insertionLevel) {
        RenderHelper.drawFluidGrid((GuiGraphics)graphics, (int)(symbol.x + 1), (int)symbol.y, (int)0, (int)16, (int)16, (Fluid)LiquidUranium.INSTANCE.m_5613_(), (int)1, (int)4);
        if (insertionLevel > 0.0) {
            int renderSize = (int)((double)symbol.height * insertionLevel / 100.0);
            symbol.blit(graphics, symbol.width, renderSize, symbol.u + 18, symbol.v);
        }
        symbol.blit(graphics);
        symbol.tooltip = Component.m_237113_((String)String.format("%.1f%%", insertionLevel));
    }
}

