/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.claims;

import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.utils.SaveHandler;
import earth.terrarium.cadmus.api.claims.admin.FlagApi;
import earth.terrarium.cadmus.api.claims.admin.flags.Flag;
import earth.terrarium.cadmus.common.claims.ClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimType;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.Nullable;

public class AdminClaimHandler
extends SaveHandler {
    private final Map<String, Map<String, Flag<?>>> flagsById = new HashMap();

    public void loadData(CompoundTag tag) {
        tag.m_128431_().forEach(id -> {
            CompoundTag adminTag = tag.m_128469_(id);
            CompoundTag flagsTag = adminTag.m_128469_("flags");
            HashMap flags = new HashMap();
            flagsTag.m_128431_().forEach(flag -> {
                Flag<?> value = FlagApi.API.get((String)flag).create(flagsTag.m_128461_(flag));
                flags.put(flag, value);
            });
            this.flagsById.put((String)id, flags);
        });
    }

    public void saveData(CompoundTag tag) {
        this.flagsById.forEach((id, claimData) -> {
            CompoundTag adminTag = new CompoundTag();
            CompoundTag flagsTag = new CompoundTag();
            claimData.forEach((flag, value) -> flagsTag.m_128359_(flag, value.serialize()));
            adminTag.m_128365_("flags", (Tag)flagsTag);
            tag.m_128365_(id, (Tag)adminTag);
        });
    }

    public static AdminClaimHandler read(MinecraftServer server) {
        return (AdminClaimHandler)AdminClaimHandler.read((DimensionDataStorage)server.m_129783_().m_8895_(), AdminClaimHandler::new, (String)"cadmus_admin_claims");
    }

    public static void create(MinecraftServer server, String id, Map<String, Flag<?>> claim) {
        AdminClaimHandler data = AdminClaimHandler.read(server);
        data.flagsById.put(id, claim);
    }

    public static void remove(MinecraftServer server, String id) {
        AdminClaimHandler data = AdminClaimHandler.read(server);
        data.flagsById.remove(id);
    }

    @Nullable
    public static Map<String, Flag<?>> get(MinecraftServer server, String id) {
        AdminClaimHandler data = AdminClaimHandler.read(server);
        return data.flagsById.get(id);
    }

    public static Map<String, Map<String, Flag<?>>> getAll(MinecraftServer server) {
        return AdminClaimHandler.read((MinecraftServer)server).flagsById;
    }

    public static boolean contains(MinecraftServer server, String id) {
        AdminClaimHandler data = AdminClaimHandler.read(server);
        return data.flagsById.containsKey(id);
    }

    public static boolean getBooleanFlag(ServerLevel level, ChunkPos pos, String flag) {
        return (Boolean)AdminClaimHandler.getFlag(level, pos, flag);
    }

    public static boolean getBooleanFlag(MinecraftServer server, String id, String flag) {
        return (Boolean)AdminClaimHandler.getFlag(server, id, flag);
    }

    public static <T> T getFlag(ServerLevel level, ChunkPos pos, String flag) {
        Pair<String, ClaimType> claim = ClaimHandler.getClaim(level, pos);
        if (claim == null) {
            return (T)FlagApi.API.get(flag).getValue();
        }
        return AdminClaimHandler.getFlag(level.m_7654_(), (String)claim.getFirst(), flag);
    }

    public static <T> T getFlag(MinecraftServer server, String id, String flag) {
        AdminClaimHandler data = AdminClaimHandler.read(server);
        Map<String, Flag<?>> claim = data.flagsById.get(id.replace("a:", ""));
        if (claim == null) {
            return (T)FlagApi.API.get(flag).getValue();
        }
        Flag<?> value = claim.get(flag);
        Flag<?> result = value == null ? FlagApi.API.get(flag) : value;
        return (T)result.getValue();
    }

    public static Map<String, Flag<?>> getAllFlags(MinecraftServer server, String id) {
        AdminClaimHandler data = AdminClaimHandler.read(server);
        return data.flagsById.get(id);
    }

    public static void setFlag(MinecraftServer server, String id, String flag, Flag<?> value) {
        AdminClaimHandler data = AdminClaimHandler.read(server);
        Map<String, Flag<?>> claim = data.flagsById.get(id);
        claim.put(flag, value);
    }

    public static void removeFlag(MinecraftServer server, String id, String flag) {
        AdminClaimHandler data = AdminClaimHandler.read(server);
        Map<String, Flag<?>> claim = data.flagsById.get(id);
        claim.remove(flag);
    }

    public boolean m_77764_() {
        return true;
    }
}

