/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.claims;

import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.utils.SaveHandler;
import earth.terrarium.cadmus.Cadmus;
import earth.terrarium.cadmus.common.claims.ClaimListenHandler;
import earth.terrarium.cadmus.common.claims.ClaimType;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.LongArrayTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.storage.DimensionDataStorage;
import org.jetbrains.annotations.Nullable;

public class ClaimHandler
extends SaveHandler {
    public static final String PLAYER_PREFIX = "p:";
    public static final String TEAM_PREFIX = "t:";
    public static final String ADMIN_PREFIX = "a:";
    private final Map<ChunkPos, Pair<String, ClaimType>> claims = new HashMap<ChunkPos, Pair<String, ClaimType>>();
    private final Map<String, Map<ChunkPos, ClaimType>> claimsById = new HashMap<String, Map<ChunkPos, ClaimType>>();
    private final ClaimListenHandler listenHandler;

    private ClaimHandler(ResourceKey<Level> dimension) {
        this.listenHandler = new ClaimListenHandler(dimension);
    }

    private void loadLegacyTeam(String id, CompoundTag tag) {
        HashMap claimData = new HashMap();
        tag.m_128431_().forEach(chunkPos -> {
            ChunkPos pos = new ChunkPos(Long.parseLong(chunkPos));
            ClaimType type = ClaimType.values()[tag.m_128445_(chunkPos)];
            claimData.put(pos, type);
        });
        this.claimsById.put(id, claimData);
    }

    private void loadTeam(String id, long[] values) {
        HashMap<ChunkPos, ClaimType> claimData = new HashMap<ChunkPos, ClaimType>();
        for (long value : values) {
            int x = BlockPos.m_121983_((long)value);
            int z = BlockPos.m_122015_((long)value);
            int type = BlockPos.m_122008_((long)value);
            claimData.put(new ChunkPos(x, z), ClaimType.values()[type]);
        }
        this.claimsById.put(id, claimData);
    }

    public void loadData(CompoundTag tag) {
        tag.m_128431_().forEach(id -> {
            if (id.startsWith(PLAYER_PREFIX) || id.startsWith(TEAM_PREFIX) || id.startsWith(ADMIN_PREFIX)) {
                if (tag.m_128435_(id) == 12) {
                    this.loadTeam((String)id, tag.m_128467_(id));
                } else {
                    this.loadLegacyTeam((String)id, tag.m_128469_(id));
                }
            }
        });
        this.updateInternal();
    }

    public void saveData(CompoundTag tag) {
        this.claimsById.forEach((id, claimData) -> {
            long[] values = new long[claimData.size()];
            int i = 0;
            for (Map.Entry entry : claimData.entrySet()) {
                ChunkPos pos = (ChunkPos)entry.getKey();
                ClaimType type = (ClaimType)((Object)((Object)entry.getValue()));
                values[i] = BlockPos.m_121882_((int)pos.f_45578_, (int)type.ordinal(), (int)pos.f_45579_);
                ++i;
            }
            tag.m_128365_(id, (Tag)new LongArrayTag(values));
        });
    }

    public static ClaimHandler read(ServerLevel level) {
        return (ClaimHandler)ClaimHandler.read((DimensionDataStorage)level.m_8895_(), () -> new ClaimHandler((ResourceKey<Level>)level.m_46472_()), (String)"cadmus_claims");
    }

    public static void claim(ServerLevel level, String id, ChunkPos pos, ClaimType type) {
        ClaimHandler data = ClaimHandler.read(level);
        if (data.claims.containsKey(pos) && !((String)data.claims.get(pos).getFirst()).equals(id)) {
            return;
        }
        if (type == ClaimType.CHUNK_LOADED) {
            level.m_7726_().m_6692_(pos, true);
            ++Cadmus.FORCE_LOADED_CHUNK_COUNT;
        }
        data.listenHandler.addClaims(level, id, Set.of(pos));
        data.claims.put(pos, (Pair<String, ClaimType>)Pair.of((Object)id, (Object)((Object)type)));
        Map currentClaims = data.claimsById.getOrDefault(id, new HashMap());
        currentClaims.put(pos, type);
        data.claimsById.put(id, currentClaims);
    }

    public static void unclaim(ServerLevel level, String id, ChunkPos pos) {
        ClaimHandler data = ClaimHandler.read(level);
        Pair<String, ClaimType> claim = data.claims.get(pos);
        if (claim == null) {
            return;
        }
        if (!((String)claim.getFirst()).equals(id)) {
            return;
        }
        if (claim.getSecond() == ClaimType.CHUNK_LOADED) {
            level.m_7726_().m_6692_(pos, false);
            --Cadmus.FORCE_LOADED_CHUNK_COUNT;
        }
        data.listenHandler.removeClaims(level, id, Set.of(pos));
        data.claims.remove(pos);
        data.claimsById.get(id).remove(pos);
    }

    public static void clear(ServerLevel level, String id) {
        ClaimHandler data = ClaimHandler.read(level);
        if (data.claimsById.containsKey(id)) {
            data.listenHandler.removeClaims(level, id, data.claimsById.get(id).keySet());
        }
        data.claimsById.remove(id);
        data.updateInternal();
    }

    public static void clearAll(ServerLevel level) {
        ClaimHandler data = ClaimHandler.read(level);
        HashSet<String> teams = new HashSet<String>(data.claimsById.keySet());
        teams.forEach(id -> ClaimHandler.clear(level, id));
    }

    @Nullable
    public static Pair<String, ClaimType> getClaim(ServerLevel level, ChunkPos pos) {
        return ClaimHandler.read((ServerLevel)level).claims.get(pos);
    }

    @Nullable
    public static Map<ChunkPos, ClaimType> getTeamClaims(ServerLevel level, String id) {
        return ClaimHandler.read((ServerLevel)level).claimsById.get(id);
    }

    public static Map<String, Map<ChunkPos, ClaimType>> getAllTeamClaims(ServerLevel level) {
        return ClaimHandler.read((ServerLevel)level).claimsById;
    }

    public static ClaimListenHandler getListener(ServerLevel level) {
        return ClaimHandler.read((ServerLevel)level).listenHandler;
    }

    public boolean m_77764_() {
        return true;
    }

    private void updateInternal() {
        this.claims.clear();
        this.claimsById.forEach((id, claimData) -> claimData.forEach((pos, type) -> this.claims.put((ChunkPos)pos, (Pair<String, ClaimType>)Pair.of((Object)id, (Object)type))));
    }
}

