/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.claims;

import com.teamresourceful.resourcefullib.common.utils.TriState;
import net.minecraft.nbt.CompoundTag;

public final class ClaimSettings {
    private TriState canBreak;
    private TriState canPlace;
    private TriState canExplode;
    private TriState canInteractWithBlocks;
    private TriState canInteractWithEntities;
    private TriState canDamageEntities;
    private TriState canNonPlayersPlace;

    public ClaimSettings(TriState canBreak, TriState canPlace, TriState canExplode, TriState canInteractWithBlocks, TriState canInteractWithEntities, TriState canDamageEntities, TriState canNonPlayersPlace) {
        this.canBreak = canBreak;
        this.canPlace = canPlace;
        this.canExplode = canExplode;
        this.canInteractWithBlocks = canInteractWithBlocks;
        this.canInteractWithEntities = canInteractWithEntities;
        this.canDamageEntities = canDamageEntities;
        this.canNonPlayersPlace = canNonPlayersPlace;
    }

    public static ClaimSettings ofFalse() {
        return new ClaimSettings(TriState.FALSE, TriState.FALSE, TriState.FALSE, TriState.FALSE, TriState.FALSE, TriState.FALSE, TriState.FALSE);
    }

    public static ClaimSettings ofUndefined() {
        return new ClaimSettings(TriState.UNDEFINED, TriState.UNDEFINED, TriState.UNDEFINED, TriState.UNDEFINED, TriState.UNDEFINED, TriState.UNDEFINED, TriState.UNDEFINED);
    }

    public boolean canBreak(ClaimSettings defaultSettings) {
        if (this.canBreak.isDefined()) {
            return this.canBreak.isTrue();
        }
        return defaultSettings.canBreak().isTrue();
    }

    public boolean canPlace(ClaimSettings defaultSettings) {
        if (this.canPlace.isDefined()) {
            return this.canPlace.isTrue();
        }
        return defaultSettings.canPlace().isTrue();
    }

    public boolean canExplode(ClaimSettings defaultSettings) {
        if (this.canExplode.isDefined()) {
            return this.canExplode.isTrue();
        }
        return defaultSettings.canExplode().isTrue();
    }

    public boolean canInteractWithBlocks(ClaimSettings defaultSettings) {
        if (this.canInteractWithBlocks.isDefined()) {
            return this.canInteractWithBlocks.isTrue();
        }
        return defaultSettings.canInteractWithBlocks().isTrue();
    }

    public boolean canInteractWithEntities(ClaimSettings defaultSettings) {
        if (this.canInteractWithEntities.isDefined()) {
            return this.canInteractWithEntities.isTrue();
        }
        return defaultSettings.canInteractWithEntities().isTrue();
    }

    public boolean canDamageEntities(ClaimSettings defaultSettings) {
        if (this.canDamageEntities.isDefined()) {
            return this.canDamageEntities.isTrue();
        }
        return defaultSettings.canDamageEntities().isTrue();
    }

    public boolean canNonPlayersPlace(ClaimSettings defaultSettings) {
        if (this.canNonPlayersPlace.isDefined()) {
            return this.canNonPlayersPlace.isTrue();
        }
        return defaultSettings.canNonPlayersPlace().isTrue();
    }

    public CompoundTag write(CompoundTag tag) {
        tag.m_128344_("canBreak", (byte)this.canBreak.ordinal());
        tag.m_128344_("canPlace", (byte)this.canPlace.ordinal());
        tag.m_128344_("canExplode", (byte)this.canExplode.ordinal());
        tag.m_128344_("canInteractWithBlocks", (byte)this.canInteractWithBlocks.ordinal());
        tag.m_128344_("canInteractWithEntities", (byte)this.canInteractWithEntities.ordinal());
        tag.m_128344_("canDamageEntities", (byte)this.canDamageEntities.ordinal());
        tag.m_128344_("canNonPlayersPlace", (byte)this.canNonPlayersPlace.ordinal());
        return tag;
    }

    public static ClaimSettings read(CompoundTag tag) {
        return new ClaimSettings(ClaimSettings.getTriState(tag, "canBreak"), ClaimSettings.getTriState(tag, "canPlace"), ClaimSettings.getTriState(tag, "canExplode"), ClaimSettings.getTriState(tag, "canInteractWithBlocks"), ClaimSettings.getTriState(tag, "canInteractWithEntities"), ClaimSettings.getTriState(tag, "canDamageEntities"), ClaimSettings.getTriState(tag, "canNonPlayersPlace"));
    }

    private static TriState getTriState(CompoundTag tag, String key) {
        if (!tag.m_128441_(key)) {
            return TriState.UNDEFINED;
        }
        return TriState.values()[tag.m_128445_(key)];
    }

    public TriState canBreak() {
        return this.canBreak;
    }

    public void setCanBreak(TriState canBreak) {
        this.canBreak = canBreak;
    }

    public TriState canPlace() {
        return this.canPlace;
    }

    public void setCanPlace(TriState canPlace) {
        this.canPlace = canPlace;
    }

    public TriState canExplode() {
        return this.canExplode;
    }

    public void setCanExplode(TriState canExplode) {
        this.canExplode = canExplode;
    }

    public TriState canInteractWithBlocks() {
        return this.canInteractWithBlocks;
    }

    public void setCanInteractWithBlocks(TriState canInteractWithBlocks) {
        this.canInteractWithBlocks = canInteractWithBlocks;
    }

    public TriState canInteractWithEntities() {
        return this.canInteractWithEntities;
    }

    public void setCanInteractWithEntities(TriState canInteractWithEntities) {
        this.canInteractWithEntities = canInteractWithEntities;
    }

    public TriState canDamageEntities() {
        return this.canDamageEntities;
    }

    public void setCanDamageEntities(TriState canDamageEntities) {
        this.canDamageEntities = canDamageEntities;
    }

    public TriState canNonPlayersPlace() {
        return this.canNonPlayersPlace;
    }

    public void setCanNonPlayersPlace(TriState canNonPlayersPlace) {
        this.canNonPlayersPlace = canNonPlayersPlace;
    }
}

