/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.commands.claims;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.ArgumentBuilder;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import com.teamresourceful.resourcefullib.common.utils.TriState;
import earth.terrarium.cadmus.api.teams.TeamProviderApi;
import earth.terrarium.cadmus.common.claims.CadmusDataHandler;
import earth.terrarium.cadmus.common.claims.ClaimSettings;
import earth.terrarium.cadmus.common.commands.claims.ClaimException;
import earth.terrarium.cadmus.common.commands.claims.CommandHelper;
import earth.terrarium.cadmus.common.compat.prometheus.PrometheusIntegration;
import earth.terrarium.cadmus.common.constants.ConstantComponents;
import earth.terrarium.cadmus.common.teams.TeamHelper;
import earth.terrarium.cadmus.common.util.ModGameRules;
import earth.terrarium.cadmus.common.util.ModUtils;
import java.util.List;
import java.util.Locale;
import net.minecraft.commands.CommandRuntimeException;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.network.chat.CommonComponents;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.GameRules;

public class ClaimSettingsCommand {
    public static final SuggestionProvider<CommandSourceStack> TRI_STATE_SUGGESTION_PROVIDER = (context, builder) -> SharedSuggestionProvider.m_82970_(List.of("true", "false", "default"), (SuggestionsBuilder)builder);

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)Commands.m_82127_((String)"claim").then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"settings").then(ClaimSettingsCommand.canBreak())).then(ClaimSettingsCommand.canPlace())).then(ClaimSettingsCommand.canExplode())).then(ClaimSettingsCommand.canInteractWithBlocks())).then(ClaimSettingsCommand.canInteractWithEntities())).then(ClaimSettingsCommand.canDamageEntities())).then(ClaimSettingsCommand.canNonPlayersPlace())).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                String id = TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
                ClaimSettings settings = CadmusDataHandler.getClaimSettings(player.m_20194_(), id);
                ClaimSettings defaultSettings = CadmusDataHandler.getDefaultClaimSettings(player.m_20194_());
                List<Component> settingsText = List.of(ClaimSettingsCommand.getCurrentListComponent("canBreak", settings.canBreak(defaultSettings)), ClaimSettingsCommand.getCurrentListComponent("canPlace", settings.canPlace(defaultSettings)), ClaimSettingsCommand.getCurrentListComponent("canExplode", settings.canExplode(defaultSettings)), ClaimSettingsCommand.getCurrentListComponent("canInteractWithBlocks", settings.canInteractWithBlocks(defaultSettings)), ClaimSettingsCommand.getCurrentListComponent("canInteractWithEntities", settings.canInteractWithEntities(defaultSettings)), ClaimSettingsCommand.getCurrentListComponent("canDamageEntities", settings.canDamageEntities(defaultSettings)), ClaimSettingsCommand.getCurrentListComponent("canNonPlayersPlace", settings.canNonPlayersPlace(defaultSettings)));
                MutableComponent text = Component.m_237119_().m_7220_(CommonUtils.serverTranslatable((String)"text.cadmus.settings.current.all", (Object[])new Object[0])).m_7220_(CommonComponents.f_178388_).m_7220_(CommonComponents.m_178391_(settingsText));
                player.m_240418_((Component)text, false);
            });
            return 1;
        })));
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> canBreak() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"canBreak").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).suggests(TRI_STATE_SUGGESTION_PROVIDER).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                String id = TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
                ClaimSettingsCommand.checkPermissions(player, id, "cadmus.personal.block_breaking", ModGameRules.RULE_DO_CLAIMED_BLOCK_BREAKING);
                TriState canBreak = ClaimSettingsCommand.getInputState(StringArgumentType.getString((CommandContext)context, (String)"value"));
                CadmusDataHandler.getClaimSettings(player.f_8924_, id).setCanBreak(canBreak);
                player.m_5661_(ClaimSettingsCommand.setCurrentComponent("canBreak", canBreak), false);
            });
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                String id = TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
                ClaimSettings settings = CadmusDataHandler.getClaimSettings(player.f_8924_, id);
                ClaimSettings defaultSettings = CadmusDataHandler.getDefaultClaimSettings(player.f_8924_);
                boolean canBreak = settings.canBreak(defaultSettings);
                player.m_5661_(ClaimSettingsCommand.getCurrentComponent("canBreak", canBreak), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> canPlace() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"canPlace").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).suggests(TRI_STATE_SUGGESTION_PROVIDER).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                String id = TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
                ClaimSettingsCommand.checkPermissions(player, id, "cadmus.personal.block_placing", ModGameRules.RULE_DO_CLAIMED_BLOCK_PLACING);
                TriState canPlace = ClaimSettingsCommand.getInputState(StringArgumentType.getString((CommandContext)context, (String)"value"));
                CadmusDataHandler.getClaimSettings(player.f_8924_, id).setCanPlace(canPlace);
                player.m_5661_(ClaimSettingsCommand.setCurrentComponent("canPlace", canPlace), false);
            });
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                String id = TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
                ClaimSettings settings = CadmusDataHandler.getClaimSettings(player.f_8924_, id);
                ClaimSettings defaultSettings = CadmusDataHandler.getDefaultClaimSettings(player.f_8924_);
                boolean canPlace = settings.canPlace(defaultSettings);
                player.m_5661_(ClaimSettingsCommand.getCurrentComponent("canPlace", canPlace), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> canExplode() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"canExplode").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).suggests(TRI_STATE_SUGGESTION_PROVIDER).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                String id = TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
                ClaimSettingsCommand.checkPermissions(player, id, "cadmus.personal.block_explosions", ModGameRules.RULE_DO_CLAIMED_BLOCK_EXPLOSIONS);
                TriState canExplode = ClaimSettingsCommand.getInputState(StringArgumentType.getString((CommandContext)context, (String)"value"));
                CadmusDataHandler.getClaimSettings(player.f_8924_, id).setCanExplode(canExplode);
                player.m_5661_(ClaimSettingsCommand.setCurrentComponent("canExplode", canExplode), false);
            });
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                String id = TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
                ClaimSettings settings = CadmusDataHandler.getClaimSettings(player.f_8924_, id);
                ClaimSettings defaultSettings = CadmusDataHandler.getDefaultClaimSettings(player.f_8924_);
                boolean canExplode = settings.canExplode(defaultSettings);
                player.m_5661_(ClaimSettingsCommand.getCurrentComponent("canExplode", canExplode), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> canInteractWithBlocks() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"canInteractWithBlocks").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).suggests(TRI_STATE_SUGGESTION_PROVIDER).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                String id = TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
                ClaimSettingsCommand.checkPermissions(player, id, "cadmus.personal.block_interactions", ModGameRules.RULE_DO_CLAIMED_BLOCK_INTERACTIONS);
                TriState canInteractWithBlocks = ClaimSettingsCommand.getInputState(StringArgumentType.getString((CommandContext)context, (String)"value"));
                CadmusDataHandler.getClaimSettings(player.f_8924_, id).setCanInteractWithBlocks(canInteractWithBlocks);
                player.m_5661_(ClaimSettingsCommand.setCurrentComponent("canInteractWithBlocks", canInteractWithBlocks), false);
            });
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                String id = TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
                ClaimSettings settings = CadmusDataHandler.getClaimSettings(player.f_8924_, id);
                ClaimSettings defaultSettings = CadmusDataHandler.getDefaultClaimSettings(player.f_8924_);
                boolean canInteractWithBlocks = settings.canInteractWithBlocks(defaultSettings);
                player.m_5661_(ClaimSettingsCommand.getCurrentComponent("canInteractWithBlocks", canInteractWithBlocks), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> canInteractWithEntities() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"canInteractWithEntities").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).suggests(TRI_STATE_SUGGESTION_PROVIDER).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                String id = TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
                ClaimSettingsCommand.checkPermissions(player, id, "cadmus.personal.entity_interactions", ModGameRules.RULE_DO_CLAIMED_ENTITY_INTERACTIONS);
                TriState canInteractWithEntities = ClaimSettingsCommand.getInputState(StringArgumentType.getString((CommandContext)context, (String)"value"));
                CadmusDataHandler.getClaimSettings(player.f_8924_, id).setCanInteractWithEntities(canInteractWithEntities);
                player.m_5661_(ClaimSettingsCommand.setCurrentComponent("canInteractWithEntities", canInteractWithEntities), false);
            });
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                String id = TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
                ClaimSettings settings = CadmusDataHandler.getClaimSettings(player.f_8924_, id);
                ClaimSettings defaultSettings = CadmusDataHandler.getDefaultClaimSettings(player.f_8924_);
                boolean canInteractWithEntities = settings.canInteractWithEntities(defaultSettings);
                player.m_5661_(ClaimSettingsCommand.getCurrentComponent("canInteractWithEntities", canInteractWithEntities), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> canDamageEntities() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"canDamageEntities").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).suggests(TRI_STATE_SUGGESTION_PROVIDER).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                String id = TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
                ClaimSettingsCommand.checkPermissions(player, id, "cadmus.personal.entity_damage", ModGameRules.RULE_CLAIMED_DAMAGE_ENTITIES);
                TriState canDamageEntities = ClaimSettingsCommand.getInputState(StringArgumentType.getString((CommandContext)context, (String)"value"));
                CadmusDataHandler.getClaimSettings(player.f_8924_, id).setCanDamageEntities(canDamageEntities);
                player.m_5661_(ClaimSettingsCommand.setCurrentComponent("canDamageEntities", canDamageEntities), false);
            });
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                String id = TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
                ClaimSettings settings = CadmusDataHandler.getClaimSettings(player.f_8924_, id);
                ClaimSettings defaultSettings = CadmusDataHandler.getDefaultClaimSettings(player.f_8924_);
                boolean canDamageEntities = settings.canDamageEntities(defaultSettings);
                player.m_5661_(ClaimSettingsCommand.getCurrentComponent("canDamageEntities", canDamageEntities), false);
            });
            return 1;
        });
    }

    private static ArgumentBuilder<CommandSourceStack, LiteralArgumentBuilder<CommandSourceStack>> canNonPlayersPlace() {
        return ((LiteralArgumentBuilder)Commands.m_82127_((String)"canNonPlayersPlace").then(Commands.m_82129_((String)"value", (ArgumentType)StringArgumentType.string()).suggests(TRI_STATE_SUGGESTION_PROVIDER).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                String id = TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
                ClaimSettingsCommand.checkPermissions(player, id, "cadmus.personal.block_placing", ModGameRules.RULE_DO_CLAIMED_BLOCK_PLACING);
                TriState canNonPlayersPlace = ClaimSettingsCommand.getInputState(StringArgumentType.getString((CommandContext)context, (String)"value"));
                CadmusDataHandler.getClaimSettings(player.f_8924_, id).setCanNonPlayersPlace(canNonPlayersPlace);
                player.m_5661_(ClaimSettingsCommand.setCurrentComponent("canNonPlayersPlace", canNonPlayersPlace), false);
            });
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> {
                String id = TeamHelper.getTeamId(player.m_20194_(), player.m_20148_());
                ClaimSettings settings = CadmusDataHandler.getClaimSettings(player.f_8924_, id);
                ClaimSettings defaultSettings = CadmusDataHandler.getDefaultClaimSettings(player.f_8924_);
                boolean canNonPlayersPlace = settings.canNonPlayersPlace(defaultSettings);
                player.m_5661_(ClaimSettingsCommand.getCurrentComponent("canNonPlayersPlace", canNonPlayersPlace), false);
            });
            return 1;
        });
    }

    private static TriState getInputState(String input) throws CommandRuntimeException {
        return switch (input.toLowerCase(Locale.ROOT)) {
            case "true" -> TriState.TRUE;
            case "false" -> TriState.FALSE;
            case "default" -> TriState.UNDEFINED;
            default -> throw new CommandRuntimeException(ConstantComponents.INVALID_STATE);
        };
    }

    private static Component getCurrentComponent(String command, Object value) {
        return CommonUtils.serverTranslatable((String)"text.cadmus.settings.current", (Object[])new Object[]{command, value});
    }

    private static Component getCurrentListComponent(String command, Object value) {
        return CommonUtils.serverTranslatable((String)"text.cadmus.settings.current.list", (Object[])new Object[]{command, value});
    }

    private static Component setCurrentComponent(String command, TriState value) {
        String text = value.isTrue() ? "true" : (value.isFalse() ? "false" : "default");
        return CommonUtils.serverTranslatable((String)"text.cadmus.settings.set", (Object[])new Object[]{command, text});
    }

    private static void checkPermissions(ServerPlayer player, String id, String permission, GameRules.Key<GameRules.BooleanValue> rule) throws ClaimException {
        if (player.m_20310_(2)) {
            return;
        }
        if (ModUtils.isTeam(id) && !TeamProviderApi.API.getSelected().canModifySettings(id, (Player)player)) {
            throw ClaimException.NOT_ALLOWED_TO_MANAGE_TEAM_SETTINGS;
        }
        if (PrometheusIntegration.prometheusLoaded() && !PrometheusIntegration.hasPermission((Player)player, permission)) {
            throw ClaimException.NO_PERMISSION_SETTINGS;
        }
    }
}

