/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.commands.claims.admin;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.BoolArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import com.mojang.datafixers.util.Pair;
import com.teamresourceful.resourcefullib.common.utils.CommonUtils;
import earth.terrarium.cadmus.api.claims.ClaimApi;
import earth.terrarium.cadmus.common.claims.CadmusDataHandler;
import earth.terrarium.cadmus.common.claims.ClaimHandler;
import earth.terrarium.cadmus.common.claims.ClaimType;
import earth.terrarium.cadmus.common.commands.claims.ClaimException;
import earth.terrarium.cadmus.common.commands.claims.CommandHelper;
import earth.terrarium.cadmus.common.teams.TeamHelper;
import java.util.Map;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.commands.SharedSuggestionProvider;
import net.minecraft.commands.arguments.coordinates.ColumnPosArgument;
import net.minecraft.network.chat.Component;
import net.minecraft.server.level.ColumnPos;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.level.ChunkPos;

public class AdminCommands {
    public static final SuggestionProvider<CommandSourceStack> TEAM_SUGGESTION_PROVIDER = (context, builder) -> {
        ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
        Map<String, Map<ChunkPos, ClaimType>> teams = ClaimHandler.getAllTeamClaims(player.m_284548_());
        return SharedSuggestionProvider.m_82981_(teams.keySet().stream().map(s -> "\"" + s + "\""), (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"cadmus").requires(commandSourceStack -> commandSourceStack.m_6761_(2))).then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.m_82127_((String)"admin").then(Commands.m_82127_((String)"bypass").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> AdminCommands.bypass(player));
            return 1;
        }))).then(Commands.m_82127_((String)"clear").then(Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).suggests(TEAM_SUGGESTION_PROVIDER).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            CommandHelper.runAction(() -> AdminCommands.clear(player, id));
            return 1;
        })))).then(Commands.m_82127_((String)"claim").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).suggests(TEAM_SUGGESTION_PROVIDER).then(Commands.m_82129_((String)"pos", (ArgumentType)ColumnPosArgument.m_118989_()).then(Commands.m_82129_((String)"chunkload", (ArgumentType)BoolArgumentType.bool()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ColumnPos pos = ColumnPosArgument.m_118992_((CommandContext)context, (String)"pos");
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            boolean chunkload = BoolArgumentType.getBool((CommandContext)context, (String)"chunkload");
            CommandHelper.runAction(() -> AdminCommands.claim(player, pos.m_143196_(), id, chunkload));
            return 1;
        })))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            CommandHelper.runAction(() -> AdminCommands.claim(player, player.m_146902_(), id, false));
            return 1;
        })))).then(Commands.m_82127_((String)"clearall").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> AdminCommands.clearAll(player));
            return 1;
        }))).then(((LiteralArgumentBuilder)Commands.m_82127_((String)"unclaim").then(((RequiredArgumentBuilder)Commands.m_82129_((String)"id", (ArgumentType)StringArgumentType.string()).suggests(TEAM_SUGGESTION_PROVIDER).then(Commands.m_82129_((String)"pos", (ArgumentType)ColumnPosArgument.m_118989_()).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            ColumnPos pos = ColumnPosArgument.m_118992_((CommandContext)context, (String)"pos");
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            CommandHelper.runAction(() -> AdminCommands.unclaim(player, pos.m_143196_(), id));
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            String id = StringArgumentType.getString((CommandContext)context, (String)"id");
            CommandHelper.runAction(() -> AdminCommands.unclaim(player, player.m_146902_(), id));
            return 1;
        }))).executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> AdminCommands.unclaim(player, player.m_146902_()));
            return 1;
        }))).then(Commands.m_82127_((String)"list").executes(context -> {
            ServerPlayer player = ((CommandSourceStack)context.getSource()).m_81375_();
            CommandHelper.runAction(() -> AdminCommands.list(player));
            return 1;
        }))));
    }

    public static void bypass(ServerPlayer player) {
        CadmusDataHandler.toggleBypass(player.f_8924_, player.m_20148_());
        if (CadmusDataHandler.canBypass(player.f_8924_, player.m_20148_())) {
            player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.bypass.enable", (Object[])new Object[]{player.m_36316_().getName()}), false);
        } else {
            player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.bypass.disable", (Object[])new Object[]{player.m_36316_().getName()}), false);
        }
    }

    public static void clear(ServerPlayer player, String id) {
        player.f_8924_.m_129785_().forEach(l -> ClaimHandler.clear(l, id));
        Component name = TeamHelper.getTeamName(id, player.f_8924_);
        if (name == null) {
            return;
        }
        player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.clear", (Object[])new Object[]{name.getString()}), false);
    }

    public static void clearAll(ServerPlayer player) {
        player.f_8924_.m_129785_().forEach(ClaimHandler::clearAll);
        player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.clear_all", (Object[])new Object[0]), false);
    }

    public static void claim(ServerPlayer player, ChunkPos pos, String id, boolean chunkloaded) throws ClaimException {
        Pair<String, ClaimType> claimData = ClaimHandler.getClaim(player.m_284548_(), pos);
        if (claimData != null) {
            boolean isMember = TeamHelper.isMember((String)claimData.getFirst(), player.f_8924_, player.m_20148_());
            throw isMember ? ClaimException.ALREADY_CLAIMED_CHUNK : ClaimException.CHUNK_ALREADY_CLAIMED;
        }
        ClaimApi.API.claim(player.m_284548_(), pos, id, chunkloaded);
        if (chunkloaded) {
            player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.claiming.chunk_loaded_chunk_at", (Object[])new Object[]{pos.f_45578_, pos.f_45579_}), false);
        } else {
            player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.claiming.claimed_chunk_at", (Object[])new Object[]{pos.f_45578_, pos.f_45579_}), false);
        }
    }

    public static void unclaim(ServerPlayer player, ChunkPos pos) throws ClaimException {
        Pair<String, ClaimType> claimData = ClaimHandler.getClaim(player.m_284548_(), pos);
        if (claimData == null) {
            throw ClaimException.CHUNK_NOT_CLAIMED;
        }
        ClaimApi.API.unclaim(player.m_284548_(), pos, (String)claimData.getFirst());
        player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.unclaiming.unclaimed_chunk_at", (Object[])new Object[]{pos.f_45578_, pos.f_45579_}), false);
    }

    public static void unclaim(ServerPlayer player, ChunkPos pos, String id) throws ClaimException {
        Pair<String, ClaimType> claimData = ClaimHandler.getClaim(player.m_284548_(), pos);
        if (claimData == null) {
            throw ClaimException.CHUNK_NOT_CLAIMED;
        }
        if (!((String)claimData.getFirst()).equals(id)) {
            throw ClaimException.DONT_OWN_CHUNK;
        }
        ClaimApi.API.unclaim(player.m_284548_(), pos, id);
        player.m_5661_(CommonUtils.serverTranslatable((String)"text.cadmus.unclaiming.unclaimed_chunk_at", (Object[])new Object[]{pos.f_45578_, pos.f_45579_}), false);
    }

    public static void list(ServerPlayer player) {
        ClaimHandler.getAllTeamClaims(player.m_284548_()).forEach((id, chunks) -> {
            Component name = TeamHelper.getTeamName(id, player.f_8924_);
            if (name == null) {
                return;
            }
            player.m_5661_((Component)Component.m_237119_(), false);
            player.m_5661_(name, false);
            player.m_5661_((Component)Component.m_237113_((String)id), false);
        });
    }
}

