/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.compat.prometheus;

import com.mojang.authlib.GameProfile;
import earth.terrarium.cadmus.api.claims.maxclaims.MaxClaimProvider;
import earth.terrarium.cadmus.common.claims.CadmusDataHandler;
import earth.terrarium.cadmus.common.compat.prometheus.PrometheusIntegration;
import earth.terrarium.cadmus.common.teams.TeamHelper;
import earth.terrarium.cadmus.common.util.ModGameRules;
import it.unimi.dsi.fastutil.ints.IntIntPair;
import java.util.Set;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;

public class PrometheusMaxClaimProvider
implements MaxClaimProvider {
    @Override
    public void calculate(String id, MinecraftServer server) {
        Set<GameProfile> members = TeamHelper.getTeamMembers(id, server);
        if (members.isEmpty()) {
            return;
        }
        boolean combinedClaimLimit = ModGameRules.getOrCreateBooleanGameRule((Level)server.m_129783_(), ModGameRules.DO_COMBINED_CLAIM_LIMIT);
        int maxClaims = 0;
        int maxChunkLoaded = 0;
        for (GameProfile profile : members) {
            int maxClaimsSetting = PrometheusIntegration.getMaxClaims((Level)server.m_129783_(), profile.getId());
            int maxChunkLoadedSetting = PrometheusIntegration.getMaxChunkLoaded((Level)server.m_129783_(), profile.getId());
            if (combinedClaimLimit) {
                maxClaims += maxClaimsSetting;
                maxChunkLoaded += maxChunkLoadedSetting;
                continue;
            }
            maxClaims = Math.max(maxClaims, maxClaimsSetting);
            maxChunkLoaded = Math.max(maxChunkLoaded, maxChunkLoadedSetting);
        }
        CadmusDataHandler.getMaxTeamClaims(server).put(id, IntIntPair.of((int)maxClaims, (int)maxChunkLoaded));
    }

    @Override
    public void removeTeam(String id, MinecraftServer server) {
        CadmusDataHandler.getMaxTeamClaims(server).remove(id);
    }

    @Override
    public int getMaxClaims(String id, MinecraftServer server, Player player) {
        return this.getMaxClaims(id, (ServerLevel)player.m_9236_(), player.m_20148_());
    }

    @Override
    public int getMaxClaims(String id, ServerLevel level, UUID player) {
        IntIntPair maxClaims = CadmusDataHandler.getMaxTeamClaims(level.m_7654_()).get(id);
        return maxClaims == null ? PrometheusIntegration.getMaxClaims((Level)level, player) : maxClaims.firstInt();
    }

    @Override
    public int getMaxChunkLoaded(String id, MinecraftServer server, Player player) {
        return this.getMaxChunkLoaded(id, (ServerLevel)player.m_9236_(), player.m_20148_());
    }

    @Override
    public int getMaxChunkLoaded(String id, ServerLevel level, UUID player) {
        IntIntPair maxChunkLoaded = CadmusDataHandler.getMaxTeamClaims(level.m_7654_()).get(id);
        return maxChunkLoaded == null ? PrometheusIntegration.getMaxChunkLoaded((Level)level, player) : maxChunkLoaded.secondInt();
    }
}

