/*
 * Decompiled with CFR 0.152.
 */
package earth.terrarium.cadmus.common.teams;

import com.mojang.authlib.GameProfile;
import earth.terrarium.cadmus.api.claims.InteractionType;
import earth.terrarium.cadmus.api.teams.TeamProvider;
import earth.terrarium.cadmus.common.claims.ClaimHandler;
import earth.terrarium.cadmus.common.teams.TeamHelper;
import earth.terrarium.cadmus.common.util.ModUtils;
import java.util.HashSet;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import net.minecraft.ChatFormatting;
import net.minecraft.Optionull;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.server.MinecraftServer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Explosion;
import net.minecraft.world.scores.PlayerTeam;
import org.jetbrains.annotations.Nullable;

public class VanillaTeamProvider
implements TeamProvider {
    @Override
    public Set<GameProfile> getTeamMembers(String id, MinecraftServer server) {
        PlayerTeam team = server.m_129896_().m_83489_(id);
        HashSet<GameProfile> profiles = new HashSet<GameProfile>();
        if (team == null) {
            return profiles;
        }
        team.m_6809_().forEach(p -> ModUtils.getProfileCache(server).m_10996_(p).ifPresent(profiles::add));
        return profiles;
    }

    @Override
    @Nullable
    public Component getTeamName(String id, MinecraftServer server) {
        PlayerTeam playerTeam = server.m_129896_().m_83489_(id);
        return (Component)Optionull.m_269382_((Object)playerTeam, PlayerTeam::m_83364_);
    }

    @Override
    @Nullable
    public String getTeamId(MinecraftServer server, UUID player) {
        Optional profile = ModUtils.getProfileCache(server).m_11002_(player);
        if (profile.isEmpty()) {
            return null;
        }
        PlayerTeam playerTeam = server.m_129896_().m_83500_(((GameProfile)profile.get()).getName());
        return (String)Optionull.m_269382_((Object)playerTeam, t -> "t:" + t.m_5758_());
    }

    @Override
    public boolean isMember(String id, MinecraftServer server, UUID player) {
        GameProfile profile = ModUtils.getProfileCache(server).m_11002_(player).orElse(null);
        if (profile == null) {
            return false;
        }
        PlayerTeam playerTeam = server.m_129896_().m_83489_(id);
        if (playerTeam == null) {
            return id.equals(player.toString());
        }
        return playerTeam.m_6809_().contains(profile.getName());
    }

    @Override
    public ChatFormatting getTeamColor(String id, MinecraftServer server) {
        PlayerTeam playerTeam = server.m_129896_().m_83489_(id);
        ChatFormatting result = (ChatFormatting)Optionull.m_269278_((Object)playerTeam, PlayerTeam::m_7414_, (Object)ChatFormatting.AQUA);
        return result == ChatFormatting.RESET ? ChatFormatting.AQUA : result;
    }

    @Override
    public boolean canBreakBlock(String id, MinecraftServer server, BlockPos pos, UUID player) {
        return TeamHelper.isMember(id, server, player);
    }

    @Override
    public boolean canPlaceBlock(String id, MinecraftServer server, BlockPos pos, UUID player) {
        return TeamHelper.isMember(id, server, player);
    }

    @Override
    public boolean canExplodeBlock(String id, MinecraftServer server, BlockPos pos, Explosion explosion, UUID player) {
        return TeamHelper.isMember(id, server, player);
    }

    @Override
    public boolean canInteractWithBlock(String id, MinecraftServer server, BlockPos pos, InteractionType type, UUID player) {
        return TeamHelper.isMember(id, server, player);
    }

    @Override
    public boolean canInteractWithEntity(String id, MinecraftServer server, Entity entity, UUID player) {
        return TeamHelper.isMember(id, server, player);
    }

    @Override
    public boolean canDamageEntity(String id, MinecraftServer server, Entity entity, UUID player) {
        return TeamHelper.isMember(id, server, player);
    }

    public void onTeamChanged(String id, MinecraftServer server, String playerName) {
        TeamProvider.super.onTeamChanged(server, id);
        GameProfile profile = ModUtils.getProfileCache(server).m_10996_(playerName).orElse(null);
        if (profile == null) {
            return;
        }
        server.m_129785_().forEach(l -> ClaimHandler.clear(l, "p:" + profile.getId().toString()));
    }

    public void onTeamRemoved(MinecraftServer server, PlayerTeam playerTeam) {
        TeamProvider.super.onTeamRemoved(server, playerTeam.m_5758_());
        server.m_129785_().forEach(l -> ClaimHandler.clear(l, "t:" + playerTeam.m_5758_()));
    }

    @Override
    public boolean canModifySettings(String id, Player player) {
        return true;
    }
}

