/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.client.gui.widget;

import fathertoast.crust.api.config.client.gui.screen.CrustConfigFileScreen;
import fathertoast.crust.api.config.client.gui.widget.field.ResetButton;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.field.RestartNote;
import fathertoast.crust.api.config.common.file.CrustConfigSpec;
import fathertoast.crust.api.config.common.file.TomlHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.ComponentPath;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.AbstractSelectionList;
import net.minecraft.client.gui.components.AbstractWidget;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ContainerObjectSelectionList;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.narration.NarratableEntry;
import net.minecraft.client.gui.navigation.FocusNavigationEvent;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.util.FormattedCharSequence;

public class CrustConfigFieldList
extends ContainerObjectSelectionList<Entry> {
    public static final int TOOLTIP_WIDTH = 150;
    public static final int OVERALL_WIDTH = 310;
    public static final int RESET_BUTTON_WIDTH = 12;
    public static final int SCROLL_WIDTH = 10;
    public static final int MAX_WIDTH = 300;
    public final CrustConfigFileScreen PARENT;
    public final CrustConfigSpec SPEC;
    private boolean changed;

    public CrustConfigFieldList(CrustConfigFileScreen parent, Minecraft game, CrustConfigSpec spec) {
        super(game, parent.f_96543_, parent.f_96544_, 43, parent.f_96544_ - 32, 21);
        this.PARENT = parent;
        this.SPEC = spec;
        spec.initGui(this, x$0 -> this.m_7085_((AbstractSelectionList.Entry)x$0));
    }

    public void newLine() {
        this.newLine(1);
    }

    public void newLine(int count) {
        for (int i = 0; i < count; ++i) {
            this.m_7085_((AbstractSelectionList.Entry)new NewLineEntry());
        }
    }

    public void comment(List<String> comment) {
        this.comment(comment, 0x777777);
    }

    public void comment(List<String> comment, int color) {
        for (String line : comment) {
            this.comment(line, color);
        }
    }

    public void comment(String str) {
        this.comment(str, 0x777777);
    }

    public void comment(String str, int color) {
        List lines = this.f_93386_.f_91062_.m_92923_((FormattedText)Component.m_237113_((String)str), 300);
        for (FormattedCharSequence line : lines) {
            this.m_7085_((AbstractSelectionList.Entry)new LeftAlignedStringEntry(line, color));
        }
    }

    public void titledComment(String title, List<String> comment) {
        this.titledComment(title, comment, 0x777777);
    }

    public void titledComment(String title, List<String> comment, int color) {
        this.m_7085_((AbstractSelectionList.Entry)new TitledCommentEntry(title, comment, color));
    }

    public void header(String str, @Nullable List<String> comment) {
        this.header(str, comment, 0xFFFF55);
    }

    public void header(String str, @Nullable List<String> comment, int color) {
        this.m_7085_((AbstractSelectionList.Entry)new HeaderEntry(str, comment, color));
    }

    public void field(AbstractConfigField field, @Nullable RestartNote restartNote, List<String> addedComment) {
        String name = CrustConfigFileScreen.decodeString(field.getKey().startsWith(this.SPEC.loadingCategory) ? field.getKey().substring(this.SPEC.loadingCategory.length()) : field.getKey());
        this.m_7085_((AbstractSelectionList.Entry)new FieldEntry(this, field, name, restartNote, addedComment));
    }

    public int m_5759_() {
        return 310;
    }

    protected int m_5756_() {
        return this.m_93520_() + 1 - 10;
    }

    public void m_88315_(GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        Entry entryMouseOver;
        super.m_88315_(graphics, mouseX, mouseY, partialTicks);
        if (this.m_5953_(mouseX, mouseY) && (entryMouseOver = (Entry)this.m_93412_(mouseX, mouseY)) != null) {
            this.PARENT.setTooltip(entryMouseOver.getTooltip());
        }
    }

    public boolean isChanged() {
        return this.changed;
    }

    private void updateChangedState() {
        block1: {
            for (Entry child : this.m_6702_()) {
                if (!(child instanceof FieldEntry) || !((FieldEntry)child).changed) continue;
                this.changed = true;
                break block1;
            }
            this.changed = false;
        }
        this.PARENT.updateFooterButtonText();
    }

    public void saveChanges() {
        if (this.changed) {
            for (Entry child : this.m_6702_()) {
                if (!(child instanceof FieldEntry)) continue;
                FieldEntry fieldEntry = (FieldEntry)child;
                if (!fieldEntry.changed) continue;
                this.SPEC.getNightConfig().set(fieldEntry.FIELD.getKey(), fieldEntry.pendingValue);
            }
            this.SPEC.onLoad();
        }
    }

    public static class NewLineEntry
    extends Entry {
        public void m_6311_(GuiGraphics graphics, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
        }

        @Nullable
        public ComponentPath m_264064_(FocusNavigationEvent event) {
            return super.m_264064_(event);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }
    }

    public static class LeftAlignedStringEntry
    extends Entry {
        private final FormattedCharSequence TEXT;
        private final int COLOR;

        public LeftAlignedStringEntry(FormattedCharSequence text, int color) {
            this.TEXT = text;
            this.COLOR = color;
        }

        public void m_6311_(GuiGraphics graphics, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
            graphics.m_280648_(this.minecraft().f_91062_, this.TEXT, rowLeft, rowTop + 5, this.COLOR);
        }

        @Nullable
        public ComponentPath m_264064_(FocusNavigationEvent event) {
            return super.m_264064_(event);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }
    }

    public static class TitledCommentEntry
    extends Entry {
        private final Component TEXT;
        private final List<FormattedCharSequence> TOOLTIP;
        private final int COLOR;

        public TitledCommentEntry(String text, List<String> comment, int color) {
            this.TEXT = Component.m_237113_((String)text);
            this.COLOR = color;
            if (comment.isEmpty()) {
                this.TOOLTIP = null;
            } else {
                this.TOOLTIP = new ArrayList<FormattedCharSequence>();
                this.TOOLTIP.addAll(this.minecraft().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)text).m_130940_(ChatFormatting.YELLOW), 150));
                for (String line : comment) {
                    this.TOOLTIP.addAll(this.minecraft().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)line), 150));
                }
            }
        }

        public void m_6311_(GuiGraphics graphics, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
            graphics.m_280430_(this.minecraft().f_91062_, this.TEXT, rowLeft, rowTop + 5, this.COLOR);
        }

        @Nullable
        public ComponentPath m_264064_(FocusNavigationEvent event) {
            return super.m_264064_(event);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }

        @Override
        @Nullable
        public List<FormattedCharSequence> getTooltip() {
            return this.TOOLTIP;
        }
    }

    public static class HeaderEntry
    extends CenteredStringEntry {
        private final List<FormattedCharSequence> TOOLTIP;

        public HeaderEntry(String text, @Nullable List<String> comment, int color) {
            super((Component)Component.m_237113_((String)ConfigUtil.properCase(CrustConfigFileScreen.decodeString(text))), color);
            if (comment == null || comment.isEmpty()) {
                this.TOOLTIP = null;
            } else {
                this.TOOLTIP = new ArrayList<FormattedCharSequence>();
                this.TOOLTIP.addAll(this.minecraft().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)text).m_130940_(ChatFormatting.YELLOW), 150));
                for (String line : comment) {
                    this.TOOLTIP.addAll(this.minecraft().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)line), 150));
                }
            }
        }

        @Override
        @Nullable
        public List<FormattedCharSequence> getTooltip() {
            return this.TOOLTIP;
        }
    }

    public static class FieldEntry
    extends Entry {
        public final CrustConfigFieldList PARENT;
        public final AbstractConfigField FIELD;
        private final List<FormattedCharSequence> NAME;
        private final List<FormattedCharSequence> TOOLTIP;
        private final List<AbstractWidget> COMPONENTS = new ArrayList<AbstractWidget>();
        private final List<OffsetWidget> RENDER_COMPONENTS = new ArrayList<OffsetWidget>();
        private final Button RESET_BUTTON;
        private final Object CURRENT_VALUE;
        private Object pendingValue;
        private boolean changed;

        public FieldEntry(CrustConfigFieldList parent, AbstractConfigField field, String name, @Nullable RestartNote restartNote, List<String> addedComment) {
            this.PARENT = parent;
            this.FIELD = field;
            this.NAME = this.minecraft().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)name), 166);
            this.TOOLTIP = new ArrayList<FormattedCharSequence>();
            this.buildTooltip(150, restartNote, addedComment);
            if (this.TOOLTIP.size() > 20) {
                this.TOOLTIP.clear();
                this.buildTooltip(225, restartNote, addedComment);
                if (this.TOOLTIP.size() > 20) {
                    this.TOOLTIP.clear();
                    this.buildTooltip(300, restartNote, addedComment);
                }
            }
            this.CURRENT_VALUE = this.pendingValue = field.getValue();
            this.RESET_BUTTON = new ResetButton(button -> {
                this.updateValue(this.FIELD.getDefaultValue());
                this.populateComponents();
            });
            this.RESET_BUTTON.f_93623_ = !TomlHelper.equals(this.FIELD.getDefaultValue(), this.pendingValue);
            this.populateComponents();
        }

        private void populateComponents() {
            this.COMPONENTS.clear();
            this.RENDER_COMPONENTS.clear();
            this.RESET_BUTTON.m_252865_(121);
            this.RESET_BUTTON.m_253211_(0);
            this.COMPONENTS.add((AbstractWidget)this.RESET_BUTTON);
            this.FIELD.getWidgetProvider().apply(this.COMPONENTS, this, this.pendingValue);
            for (AbstractWidget component : this.COMPONENTS) {
                this.RENDER_COMPONENTS.add(new OffsetWidget(component));
            }
        }

        public Object getValue() {
            return this.pendingValue;
        }

        public void updateValue(Object value) {
            this.pendingValue = value;
            this.RESET_BUTTON.f_93623_ = !TomlHelper.equals(this.FIELD.getDefaultValue(), value);
            this.changed = !TomlHelper.equals(this.CURRENT_VALUE, value);
            this.PARENT.updateChangedState();
            this.ensureVisible();
        }

        public void clearValue() {
            this.pendingValue = this.CURRENT_VALUE;
            this.RESET_BUTTON.f_93623_ = !TomlHelper.equals(this.FIELD.getDefaultValue(), this.CURRENT_VALUE);
            this.changed = false;
            this.PARENT.updateChangedState();
            this.ensureVisible();
        }

        public void ensureVisible() {
            this.PARENT.m_93498_((AbstractSelectionList.Entry)this);
        }

        private void buildTooltip(int width, @Nullable RestartNote restartNote, List<String> addedComment) {
            this.TOOLTIP.addAll(this.minecraft().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)this.FIELD.getKey()).m_130940_(ChatFormatting.YELLOW), width));
            if (this.FIELD.getComment() != null && !this.FIELD.getComment().isEmpty()) {
                for (String line : this.FIELD.getComment()) {
                    this.TOOLTIP.addAll(this.minecraft().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)line), width));
                }
            }
            if (restartNote != null) {
                this.TOOLTIP.addAll(this.minecraft().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)restartNote.COMMENT).m_130940_(ChatFormatting.RED), width));
            }
            if (!addedComment.isEmpty()) {
                for (String line : addedComment) {
                    this.TOOLTIP.addAll(this.minecraft().f_91062_.m_92923_((FormattedText)Component.m_237113_((String)line).m_130940_(ChatFormatting.GRAY), width));
                }
            }
        }

        public void setPopupWidget(@Nullable AbstractWidget popup) {
            this.PARENT.PARENT.setPopupWidget(popup);
        }

        public void m_6311_(GuiGraphics graphics, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
            int color;
            int n = color = this.changed ? 0x55FFFF : 0xFFFFFF;
            if (this.NAME.size() == 1) {
                graphics.m_280648_(this.minecraft().f_91062_, this.NAME.get(0), rowLeft, rowTop + 5, color);
            } else if (this.NAME.size() >= 2) {
                graphics.m_280648_(this.minecraft().f_91062_, this.NAME.get(this.NAME.size() - 2), rowLeft, rowTop, color);
                graphics.m_280648_(this.minecraft().f_91062_, this.NAME.get(this.NAME.size() - 1), rowLeft, rowTop + 10, color);
            }
            for (OffsetWidget component : this.RENDER_COMPONENTS) {
                component.WIDGET.m_252865_(component.X_OFFSET + rowLeft + 300 - 120 - 12);
                component.WIDGET.m_253211_(component.Y_OFFSET + rowTop);
                component.WIDGET.m_88315_(graphics, mouseX, mouseY, partialTicks);
            }
        }

        @Override
        @Nullable
        public List<FormattedCharSequence> getTooltip() {
            return this.TOOLTIP;
        }

        public List<? extends GuiEventListener> m_6702_() {
            return this.COMPONENTS;
        }

        public void m_7522_(@Nullable GuiEventListener component) {
            if (component instanceof EditBox) {
                EditBox editBox = (EditBox)component;
                this.PARENT.PARENT.setFocusedTextBox(editBox);
            }
            super.m_7522_(component);
        }

        @Override
        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }

        private static class OffsetWidget {
            final AbstractWidget WIDGET;
            final int X_OFFSET;
            final int Y_OFFSET;

            OffsetWidget(AbstractWidget widget) {
                this.WIDGET = widget;
                this.X_OFFSET = widget.m_252754_();
                this.Y_OFFSET = widget.m_252907_();
            }
        }
    }

    public static abstract class Entry
    extends ContainerObjectSelectionList.Entry<Entry> {
        public Minecraft minecraft() {
            return Minecraft.m_91087_();
        }

        @Nullable
        public List<FormattedCharSequence> getTooltip() {
            return null;
        }

        public List<? extends NarratableEntry> m_142437_() {
            return List.of();
        }
    }

    public static class CenteredStringEntry
    extends Entry {
        private final Component TEXT;
        private final int COLOR;
        public final int WIDTH;

        public CenteredStringEntry(Component text, int color) {
            this.TEXT = text;
            this.COLOR = color;
            this.WIDTH = Minecraft.m_91087_().f_91062_.m_92852_((FormattedText)this.TEXT);
        }

        public void m_6311_(GuiGraphics graphics, int index, int rowTop, int rowLeft, int rowWidth, int rowHeight, int mouseX, int mouseY, boolean mouseOver, float partialTicks) {
            graphics.m_280430_(this.minecraft().f_91062_, this.TEXT, this.minecraft().f_91080_.f_96543_ - this.WIDTH - 5 >> 1, rowTop + 5, this.COLOR);
        }

        @Nullable
        public ComponentPath m_264064_(FocusNavigationEvent event) {
            return super.m_264064_(event);
        }

        public List<? extends GuiEventListener> m_6702_() {
            return Collections.emptyList();
        }
    }
}

