/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.client.gui.widget.field;

import fathertoast.crust.api.config.client.gui.widget.field.TextBoxWidget;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.util.Mth;

public class TextBoxContent {
    private final TextBoxWidget textBox;
    private String plainText = "";
    private final ArrayList<WrappedLine> wrappedLines = new ArrayList();
    private int renderLines = -1;

    TextBoxContent(TextBoxWidget parent, String text) {
        this.textBox = parent;
        this.setText(text);
    }

    public boolean isValid(@Nullable String text) {
        return text != null;
    }

    public boolean setText(String text) {
        if (this.isValid(text)) {
            this.plainText = text;
            this.recalculateLines();
            return true;
        }
        return false;
    }

    public String getText() {
        return this.plainText;
    }

    public boolean isEmpty() {
        return this.plainText.isEmpty();
    }

    public int length() {
        return this.plainText.length();
    }

    public boolean isWhitespace(int index) {
        return Character.isWhitespace(this.plainText.charAt(index));
    }

    public String substring(int pos) {
        return this.plainText.substring(pos);
    }

    public String substring(int pos0, int pos1) {
        if (pos0 == pos1) {
            return "";
        }
        return pos0 < pos1 ? this.plainText.substring(pos0, pos1) : this.plainText.substring(pos1, pos0);
    }

    public List<WrappedLine> getLines() {
        return Collections.unmodifiableList(this.wrappedLines);
    }

    public int getLineCount() {
        return this.wrappedLines.size();
    }

    public int getLineCountAfterWrap() {
        if (this.renderLines < 0) {
            int count = 0;
            for (WrappedLine line : this.wrappedLines) {
                count += line.wrappedValue.size();
            }
            this.renderLines = count;
        }
        return this.renderLines;
    }

    public int clampPosition(int pos) {
        return Mth.m_14045_((int)pos, (int)0, (int)this.plainText.length());
    }

    public int getLineIndexAtPosition(int pos) {
        int i = this.wrappedLines.size() - 1;
        WrappedLine lastLine = this.wrappedLines.get(i);
        if (pos >= lastLine.position) {
            return pos > lastLine.length() ? -1 : i;
        }
        --i;
        while (i >= 0) {
            if (pos >= this.wrappedLines.get((int)i).position) {
                return i;
            }
            --i;
        }
        return -1;
    }

    @Nullable
    public WrappedLine getLineAtPosition(int pos) {
        int i = this.getLineIndexAtPosition(pos);
        return i < 0 ? null : this.wrappedLines.get(i);
    }

    public void removeLine(int index) {
        WrappedLine removedLine = this.wrappedLines.remove(index);
        this.renderLines -= removedLine.getLineCountAfterWrap();
        int lineCount = this.getLineCount();
        int posOffset = removedLine.length() + 1;
        for (int i = index; i < lineCount; ++i) {
            this.wrappedLines.get((int)i).position -= posOffset;
        }
        this.recalculateText();
    }

    public WrappedLine getLine(int index) {
        return this.wrappedLines.get(index);
    }

    public void addLine(String newLine) {
        this.addLine(this.getLineCount(), newLine);
    }

    public void addLine(int index, String newLine) {
        if (newLine.contains("\n")) {
            String[] splitLine = newLine.split("\n");
            int i = index;
            for (String subLine : splitLine) {
                this.addSingleLineNoRecalculation(i, subLine);
                ++i;
            }
        } else {
            this.addSingleLineNoRecalculation(index, newLine);
        }
        this.recalculateText();
    }

    private void addSingleLineNoRecalculation(int index, String newLine) {
        int lineCount = this.getLineCount();
        if (index < lineCount) {
            this.wrappedLines.add(index, new WrappedLine(newLine, this.getLine((int)index).position));
            int posOffset = newLine.length() + 1;
            for (int i = index + 1; i <= lineCount; ++i) {
                this.wrappedLines.get((int)i).position += posOffset;
            }
        } else {
            WrappedLine lastLine = this.getLine(lineCount - 1);
            this.wrappedLines.add(index, new WrappedLine(newLine, lastLine.position + lastLine.length() + 1));
        }
    }

    public void recalculateWrap() {
        for (WrappedLine line : this.wrappedLines) {
            line.recalculateWrap();
        }
    }

    private void recalculateLines() {
        String[] rawLines = this.plainText.split("\n");
        int currentPos = 0;
        this.renderLines = 0;
        this.wrappedLines.clear();
        for (String line : rawLines) {
            this.wrappedLines.add(new WrappedLine(line, currentPos));
            currentPos += line.length() + 1;
        }
    }

    private void recalculateText() {
        StringBuilder text = new StringBuilder();
        boolean newline = false;
        for (WrappedLine line : this.wrappedLines) {
            text.append(line.getValue());
            if (newline) {
                text.append('\n');
                continue;
            }
            newline = true;
        }
        String newText = text.toString();
        if (this.isValid(newText)) {
            this.plainText = newText;
        }
    }

    public class WrappedLine {
        private final String value;
        private final ArrayList<String> wrappedValue = new ArrayList();
        private int position;

        private WrappedLine(String str, int pos) {
            this.position = pos;
            this.value = str;
            this.recalculateWrap();
        }

        public int localPosToGlobal(int localPos) {
            return localPos + this.position;
        }

        public int globalPosToLocal(int globalPos) {
            return globalPos - this.position;
        }

        public int length() {
            return this.value.length();
        }

        public String getValue() {
            return this.value;
        }

        public int getLineCountAfterWrap() {
            return this.wrappedValue.size();
        }

        private void recalculateWrap() {
            String wrapped;
            boolean width = false;
            TextBoxContent.this.renderLines -= this.getLineCountAfterWrap();
            this.wrappedValue.clear();
            for (int index = 0; index < this.value.length(); index += wrapped.length()) {
                wrapped = this.value;
            }
            TextBoxContent.this.renderLines += this.getLineCountAfterWrap();
        }
    }
}

