/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.field;

import com.electronwill.nightconfig.core.io.CharacterOutput;
import fathertoast.crust.api.config.client.gui.widget.provider.IConfigFieldWidgetProvider;
import fathertoast.crust.api.config.client.gui.widget.provider.UnsupportedWidgetProvider;
import fathertoast.crust.api.config.common.file.CrustConfigSpec;
import fathertoast.crust.api.config.common.file.CrustTomlWriter;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.IStringArray;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;

public abstract class AbstractConfigField {
    private CrustConfigSpec SPEC;
    private String KEY;
    private final List<String> COMMENT;

    protected AbstractConfigField(String key, String ... description) {
        this(key, description == null ? null : TomlHelper.newComment(description));
    }

    AbstractConfigField(String key, @Nullable List<String> comment) {
        this.KEY = key;
        this.COMMENT = comment == null ? null : Collections.unmodifiableList(comment);
    }

    public final CrustConfigSpec getSpec() {
        return this.SPEC;
    }

    public final String getKey() {
        return this.KEY;
    }

    @Nullable
    public final List<String> getComment() {
        return this.COMMENT;
    }

    public final void setSpec(CrustConfigSpec spec) {
        if (this.SPEC != null) {
            throw new IllegalStateException("Attempted to register field '" + this.KEY + "' in two locations; first in " + this.SPEC.NAME + " and then in " + spec.NAME);
        }
        this.SPEC = spec;
        this.KEY = spec.loadingCategory + this.KEY;
        this.onSpecSet();
    }

    protected void onSpecSet() {
    }

    public abstract void appendFieldInfo(List<String> var1);

    public abstract void load(@Nullable Object var1);

    @Nullable
    public abstract Object getValue();

    public abstract Object getDefaultValue();

    public void writeValue(CrustTomlWriter writer, CharacterOutput output) {
        Object value = this.getValue();
        if (value instanceof IStringArray) {
            writer.writeStringArray(((IStringArray)value).toStringList(), output);
        } else {
            writer.writeLine(TomlHelper.toLiteral(value), output);
        }
    }

    public IConfigFieldWidgetProvider getWidgetProvider() {
        return new UnsupportedWidgetProvider();
    }
}

