/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.field;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.DoubleField;
import fathertoast.crust.api.config.common.field.GenericField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.AttributeEntry;
import fathertoast.crust.api.config.common.value.AttributeList;
import fathertoast.crust.api.config.common.value.ConfigDrivenAttributeModifierMap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;

public class AttributeListField
extends GenericField<AttributeList> {
    public ConfigDrivenAttributeModifierMap linkedAttributeMap;

    public static List<String> verboseDescription() {
        ArrayList<String> comment = new ArrayList<String>();
        comment.add("Attribute List fields: General format = [ \"namespace:attribute_name operation value\", ... ]");
        comment.add("  Attribute lists are arrays of base attribute changes. Attributes are defined by their key in the attribute registry, usually following the pattern 'namespace:attribute_name'.");
        comment.add("  The operations that can be performed are +, -, and *. The + and - operators change the attribute by adding the value to it (or subtracting the value from it). The * operator changes the attribute by multiplying it by the value.");
        comment.add("  Each entry in the attribute list is applied in the exact order listed.");
        comment.add("  As an example, the entry \"minecraft:generic.max_health + 10.0\" will increase a mob's max health by 10. By convention, never use the + or - operators for movement speed (minecraft:generic.movement_speed).");
        return comment;
    }

    public AttributeListField(String key, AttributeList defaultValue, String ... description) {
        super(key, defaultValue, description);
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        comment.add(TomlHelper.fieldInfoFormat("Attribute List", this.valueDefault, "[ \"namespace:attribute_name operation value\", ... ]"));
        comment.add("   Range for Values: " + TomlHelper.fieldRange(DoubleField.Range.ANY.MIN, DoubleField.Range.ANY.MAX));
    }

    @Override
    public void load(@Nullable Object raw) {
        if (raw == null) {
            this.value = this.valueDefault;
            return;
        }
        if (raw instanceof AttributeList) {
            this.value = (AttributeList)raw;
        } else {
            List<String> list = TomlHelper.parseStringList(raw);
            ArrayList<AttributeEntry> entryList = new ArrayList<AttributeEntry>();
            for (String line : list) {
                entryList.add(this.parseEntry(line));
            }
            this.value = new AttributeList(entryList);
        }
        if (this.linkedAttributeMap != null) {
            this.linkedAttributeMap.invalidate();
        }
    }

    private AttributeEntry parseEntry(String line) {
        double value;
        int identityValue;
        int operator;
        String[] args = line.split(" ", 4);
        if (args.length > 3) {
            ConfigUtil.LOG.warn("Entry has for {} \"{}\" is too long! Deleting excess. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)line);
        }
        ResourceLocation regKey = new ResourceLocation(args[0].trim());
        boolean OP_MULTIPLY = false;
        boolean OP_ADD = true;
        int OP_SUBTRACT = -1;
        if (args.length < 2) {
            ConfigUtil.LOG.warn("Entry has no operator for {} \"{}\"! Replacing missing operator with +. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)line);
            operator = 1;
        } else {
            switch (args[1]) {
                case "*": {
                    operator = 0;
                    break;
                }
                case "+": {
                    operator = 1;
                    break;
                }
                case "-": {
                    operator = -1;
                    break;
                }
                default: {
                    operator = 1;
                    ConfigUtil.LOG.warn("Entry has invalid operator {} for {} \"{}\"! Replacing operator with +. Invalid entry: {}", (Object)args[1], this.getClass(), (Object)this.getKey(), (Object)line);
                }
            }
        }
        int n = identityValue = operator == 0 ? 1 : 0;
        if (args.length < 3) {
            ConfigUtil.LOG.warn("Entry has no value for {} \"{}\"! Replacing missing value with {}. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)identityValue, (Object)line);
            value = identityValue;
        } else {
            value = this.parseValue(args[2], line, identityValue);
        }
        return operator == 0 ? new AttributeEntry(this, regKey, true, value) : new AttributeEntry(this, regKey, false, value * (double)operator);
    }

    private double parseValue(String arg, String line, int identity) {
        double value;
        try {
            value = Double.parseDouble(arg);
        }
        catch (NumberFormatException ex) {
            ConfigUtil.LOG.warn("Invalid value for {} \"{}\"! Falling back to {}. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)identity, (Object)line);
            value = identity;
        }
        return value;
    }

    public void apply(AttributeSupplier.Builder builder) {
        ((AttributeList)this.get()).apply(builder);
    }

    public void apply(LivingEntity entity) {
        ((AttributeList)this.get()).apply(entity);
    }
}

