/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.field;

import fathertoast.crust.api.config.common.field.GenericField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.BlockList;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.world.level.block.state.BlockState;

public class BlockListField
extends GenericField<BlockList> {
    public static List<String> verboseDescription() {
        ArrayList<String> comment = new ArrayList<String>();
        comment.add("Block List fields: General format = [ \"namespace:block_name[property1=value1,...]\", ... ]");
        comment.add("  Block lists are arrays of blocks and partial block states.");
        comment.add("  Blocks are defined by their key in the block registry, usually following the pattern 'namespace:block_name'.");
        comment.add("  An asterisk '*' can be used to match all blocks belonging to X namespace. For example, 'minecraft:*' will match all vanilla blocks.");
        comment.add("  Block tags can also be used here. To declare a tag, start with a '#' followed by the rest of the tag path.");
        comment.add("  Tag example: '#minecraft:beehive_inhabitors'");
        comment.add("  List entries by default match any block state. The block states to match can be narrowed down by specifying properties. The syntax for block state properties is the same as for commands. Any properties not specified will match any value. For example, 'minecraft:beehive[honey_level=5]' will match any full beehives, regardless of the direction they face.");
        comment.add("  Note that tags and namespace entries are not block state sensitive; they only care about the base block");
        comment.add("      Priority order: specific entries > tag entries > namespace entries");
        return comment;
    }

    public BlockListField(String key, BlockList defaultValue, String ... description) {
        super(key, defaultValue, description);
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        comment.add(TomlHelper.fieldInfoFormat("Block List", this.valueDefault, "[ \"namespace:block_name[properties]\", ... ]"));
    }

    @Override
    public void load(@Nullable Object raw) {
        if (raw == null) {
            this.value = this.valueDefault;
            return;
        }
        this.value = raw instanceof BlockList ? (BlockList)raw : new BlockList(this, TomlHelper.parseStringList(raw));
    }

    public boolean isEmpty() {
        return ((BlockList)this.get()).isEmpty();
    }

    public boolean matches(BlockState blockState) {
        return ((BlockList)this.get()).matches(blockState);
    }

    public static class Combined {
        public final BlockListField WHITELIST;
        public final BlockListField BLACKLIST;

        public Combined(BlockListField whitelist, BlockListField blacklist) {
            this.WHITELIST = whitelist;
            this.BLACKLIST = blacklist;
        }

        public boolean isEmpty() {
            return ((BlockList)this.WHITELIST.get()).isEmpty();
        }

        public boolean matches(BlockState blockState) {
            return !((BlockList)this.BLACKLIST.get()).matches(blockState) && ((BlockList)this.WHITELIST.get()).matches(blockState);
        }
    }
}

