/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.field;

import fathertoast.crust.api.config.client.gui.widget.provider.BooleanFieldWidgetProvider;
import fathertoast.crust.api.config.client.gui.widget.provider.IConfigFieldWidgetProvider;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import java.util.List;
import javax.annotation.Nullable;

public class BooleanField
extends AbstractConfigField {
    private final boolean valueDefault;
    private boolean value;

    public BooleanField(String key, boolean defaultValue, String ... description) {
        super(key, description);
        this.valueDefault = defaultValue;
    }

    public boolean get() {
        return this.value;
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        comment.add(TomlHelper.fieldInfoValidValues("Boolean", this.valueDefault, true, false));
    }

    @Override
    public void load(@Nullable Object raw) {
        Object newValue;
        if (raw instanceof String) {
            ConfigUtil.LOG.info("Unboxing string value for {} \"{}\" to a different primitive.", this.getClass(), (Object)this.getKey());
            newValue = TomlHelper.parseStringPrimitive((String)raw);
        } else {
            newValue = raw;
        }
        if (newValue instanceof Boolean) {
            this.value = (Boolean)newValue;
        } else if (newValue instanceof Number) {
            double newNumberValue = ((Number)newValue).doubleValue();
            ConfigUtil.LOG.warn("Value for {} \"{}\" is numerical! Converting value. Invalid value: {}", this.getClass(), (Object)this.getKey(), raw);
            this.value = newNumberValue != 0.0;
        } else {
            if (newValue != null) {
                ConfigUtil.LOG.warn("Invalid value for {} \"{}\"! Falling back to default. Invalid value: {}", this.getClass(), (Object)this.getKey(), raw);
            }
            this.value = this.valueDefault;
        }
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object getDefaultValue() {
        return this.valueDefault;
    }

    @Override
    public IConfigFieldWidgetProvider getWidgetProvider() {
        return new BooleanFieldWidgetProvider(this);
    }
}

