/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.field;

import fathertoast.crust.api.config.client.gui.widget.provider.ColorFieldWidgetProvider;
import fathertoast.crust.api.config.client.gui.widget.provider.IConfigFieldWidgetProvider;
import fathertoast.crust.api.config.common.field.IntField;
import fathertoast.crust.api.lib.CrustMath;
import java.awt.Color;

public class ColorIntField
extends IntField.Hex {
    public ColorIntField(String key, int defaultValue, boolean useAlpha, String ... description) {
        super(key, useAlpha ? defaultValue : defaultValue & 0xFFFFFF, useAlpha ? 8 : 6, useAlpha ? IntField.Range.ANY.MIN : 0, useAlpha ? IntField.Range.ANY.MAX : 0xFFFFFF, description);
    }

    public ColorIntField(String key, Color defaultValue, boolean useAlpha, String ... description) {
        this(key, defaultValue.getRGB(), useAlpha, description);
    }

    public boolean usesAlpha() {
        return this.getMinDigits() > 6;
    }

    public Color getColor() {
        return new Color(this.get(), true);
    }

    public int getRedBits() {
        return CrustMath.getRedBits(this.get());
    }

    public float getRed() {
        return CrustMath.getRed(this.get());
    }

    public int getGreenBits() {
        return CrustMath.getGreenBits(this.get());
    }

    public float getGreen() {
        return CrustMath.getGreen(this.get());
    }

    public int getBlueBits() {
        return CrustMath.getBlueBits(this.get());
    }

    public float getBlue() {
        return CrustMath.getBlue(this.get());
    }

    public int getAlphaBits() {
        return CrustMath.getAlphaBits(this.get());
    }

    public float getAlpha() {
        return CrustMath.getAlpha(this.get());
    }

    @Override
    public IConfigFieldWidgetProvider getWidgetProvider() {
        return new ColorFieldWidgetProvider(this);
    }
}

