/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.field;

import fathertoast.crust.api.config.client.gui.widget.provider.EnumFieldWidgetProvider;
import fathertoast.crust.api.config.client.gui.widget.provider.IConfigFieldWidgetProvider;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.GenericField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import java.util.List;
import javax.annotation.Nullable;

public class EnumField<T extends Enum<T>>
extends GenericField<T> {
    private final T[] valuesValid;

    public EnumField(String key, T defaultValue, String ... description) {
        this(key, (Enum)defaultValue, (Enum[])defaultValue.getClass().getEnumConstants(), description);
    }

    public EnumField(String key, T defaultValue, T[] validValues, String ... description) {
        super(key, defaultValue, description);
        if (validValues.length == 0) {
            throw new IllegalArgumentException("Cannot create field with no valid values! Invalid field: " + key);
        }
        this.valuesValid = validValues;
    }

    public T[] validValues() {
        return this.valuesValid;
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        comment.add(TomlHelper.fieldInfoValidValues("Enum", this.valueDefault, this.valuesValid));
    }

    @Override
    public void load(@Nullable Object raw) {
        if (raw == null) {
            this.value = this.valueDefault;
            return;
        }
        try {
            this.value = (Enum)raw;
            return;
        }
        catch (ClassCastException classCastException) {
            Object newValue = raw instanceof String ? this.parseValue((String)raw) : null;
            if (newValue == null) {
                ConfigUtil.LOG.warn("Invalid value for {} \"{}\"! Falling back to default. Invalid value: {}", this.getClass(), (Object)this.getKey(), raw);
                this.value = this.valueDefault;
            } else {
                this.value = newValue;
            }
            return;
        }
    }

    @Nullable
    public T parseValue(String name) {
        for (T val : this.valuesValid) {
            if (!((Enum)val).name().equalsIgnoreCase(name)) continue;
            return val;
        }
        return null;
    }

    @Override
    public IConfigFieldWidgetProvider getWidgetProvider() {
        return new EnumFieldWidgetProvider(this);
    }
}

