/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.field;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.DoubleField;
import fathertoast.crust.api.config.common.field.GenericField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.EnvironmentEntry;
import fathertoast.crust.api.config.common.value.EnvironmentList;
import fathertoast.crust.api.config.common.value.environment.AbstractEnvironment;
import fathertoast.crust.api.config.common.value.environment.CrustEnvironmentRegistry;
import fathertoast.crust.api.lib.EnvironmentHelper;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;

public class EnvironmentListField
extends GenericField<EnvironmentList> {
    public static List<String> verboseDescription() {
        ArrayList<String> comment = new ArrayList<String>();
        comment.add("Environment List fields: General format =");
        comment.add("    [ \"value environment1 condition1 & environment2 condition2 & ...\", ... ]");
        comment.add("  Environment lists are arrays of environment entries. Each entry is a value followed by the environment conditions that must be satisfied for the value to be chosen. The environments are tested in the order listed, and the first matching entry is chosen.");
        comment.add("  See the bottom of this file for an explanation on each environment condition available.");
        return comment;
    }

    public EnvironmentListField(String key, EnvironmentList defaultValue, String ... description) {
        super(key, defaultValue, description);
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        comment.add(TomlHelper.fieldInfoFormat("Environment List", this.valueDefault, "[ \"value condition1 state1 & condition2 state2 & ...\", ... ]"));
        comment.add("   Range for Values: " + TomlHelper.fieldRange(((EnvironmentList)this.valueDefault).getMinValue(), ((EnvironmentList)this.valueDefault).getMaxValue()));
    }

    @Override
    public void load(@Nullable Object raw) {
        if (raw == null) {
            this.value = this.valueDefault;
            return;
        }
        if (raw instanceof EnvironmentList) {
            this.value = (EnvironmentList)raw;
        } else {
            List<String> list = TomlHelper.parseStringList(raw);
            ArrayList<EnvironmentEntry> entryList = new ArrayList<EnvironmentEntry>();
            for (String line : list) {
                entryList.add(this.parseEntry(line));
            }
            this.value = new EnvironmentList(entryList);
        }
    }

    private EnvironmentEntry parseEntry(String line) {
        String[] args = line.split(" ", 2);
        double value = this.parseValue(args[0], line);
        ArrayList<AbstractEnvironment> conditions = new ArrayList<AbstractEnvironment>();
        if (args.length > 1) {
            String[] condArgs;
            for (String condArg : condArgs = args[1].split("&")) {
                conditions.add(this.parseCondition(condArg.trim(), line));
            }
        }
        return new EnvironmentEntry(value, conditions);
    }

    private double parseValue(String arg, String line) {
        double value;
        try {
            value = Double.parseDouble(arg);
        }
        catch (NumberFormatException ex) {
            ConfigUtil.LOG.warn("Invalid value for {} \"{}\"! Falling back to 0. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)line);
            value = 0.0;
        }
        if (value < ((EnvironmentList)this.valueDefault).getMinValue()) {
            ConfigUtil.LOG.warn("Value for {} \"{}\" is below the minimum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)((EnvironmentList)this.valueDefault).getMinValue(), (Object)value);
            value = ((EnvironmentList)this.valueDefault).getMinValue();
        } else if (value > ((EnvironmentList)this.valueDefault).getMaxValue()) {
            ConfigUtil.LOG.warn("Value for {} \"{}\" is above the maximum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)((EnvironmentList)this.valueDefault).getMaxValue(), (Object)value);
            value = ((EnvironmentList)this.valueDefault).getMaxValue();
        }
        return value;
    }

    private AbstractEnvironment parseCondition(String arg, String line) {
        String[] args = arg.split(" ", 2);
        String value = args.length < 2 ? "" : args[1].trim();
        return CrustEnvironmentRegistry.parse(this, args[0], value);
    }

    public double getOrElse(Level world, DoubleField defaultValue) {
        return ((EnvironmentList)this.get()).getOrElse(world, defaultValue);
    }

    public double getOrElse(Level world, double defaultValue) {
        return ((EnvironmentList)this.get()).getOrElse(world, defaultValue);
    }

    @Nullable
    public Double get(Level world) {
        return ((EnvironmentList)this.get()).get(world);
    }

    public double getOrElse(Level world, BlockPos pos, DoubleField defaultValue) {
        return ((EnvironmentList)this.get()).getOrElse(world, pos, defaultValue);
    }

    public double getOrElse(Level world, BlockPos pos, double defaultValue) {
        return ((EnvironmentList)this.get()).getOrElse(world, pos, defaultValue);
    }

    @Nullable
    public Double get(Level world, BlockPos pos) {
        return ((EnvironmentList)this.get()).get(world, pos);
    }

    public boolean isLoaded(Level world, BlockPos pos) {
        return EnvironmentHelper.isLoaded((LevelAccessor)world, pos);
    }

    public double getOrElseIfLoaded(Level world, @Nullable BlockPos pos, DoubleField defaultValue) {
        if (pos != null && this.isLoaded(world, pos)) {
            return this.getOrElse(world, pos, defaultValue);
        }
        return this.getOrElse(world, defaultValue);
    }

    public double getOrElseIfLoaded(Level world, @Nullable BlockPos pos, double defaultValue) {
        if (pos != null && this.isLoaded(world, pos)) {
            return this.getOrElse(world, pos, defaultValue);
        }
        return this.getOrElse(world, defaultValue);
    }

    @Nullable
    public Double getIfLoaded(Level world, @Nullable BlockPos pos) {
        if (pos != null && this.isLoaded(world, pos)) {
            return this.get(world, pos);
        }
        return this.get(world);
    }
}

