/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.field;

import com.electronwill.nightconfig.core.io.CharacterOutput;
import fathertoast.crust.api.config.client.gui.widget.provider.HexIntFieldWidgetProvider;
import fathertoast.crust.api.config.client.gui.widget.provider.IConfigFieldWidgetProvider;
import fathertoast.crust.api.config.client.gui.widget.provider.NumberFieldWidgetProvider;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.file.CrustTomlWriter;
import fathertoast.crust.api.config.common.file.TomlHelper;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.util.RandomSource;

public class IntField
extends AbstractConfigField {
    private final int valueDefault;
    private final int valueMin;
    private final int valueMax;
    private int value;

    public IntField(String key, int defaultValue, Range range, String ... description) {
        this(key, defaultValue, range.MIN, range.MAX, description);
    }

    public IntField(String key, int defaultValue, int min, int max, String ... description) {
        super(key, description);
        this.valueDefault = defaultValue;
        this.valueMin = min;
        this.valueMax = max;
        if (this.valueMin >= this.valueMax) {
            throw new IllegalArgumentException("Maximum value must be greater than the minimum! Invalid field: " + this.getKey());
        }
        if (this.valueDefault < this.valueMin || this.valueDefault > this.valueMax) {
            throw new IllegalArgumentException("Default value is outside of allowed range! Invalid field: " + this.getKey());
        }
    }

    public int get() {
        return this.value;
    }

    public short getShort() {
        return (short)this.get();
    }

    public byte getByte() {
        return (byte)this.get();
    }

    public boolean rollChance(Random random) {
        return this.rollChance(random::nextInt);
    }

    public boolean rollChance(RandomSource random) {
        return this.rollChance(arg_0 -> ((RandomSource)random).m_188503_(arg_0));
    }

    private boolean rollChance(Function<Integer, Integer> random) {
        return this.get() > 0 && random.apply(this.get()) == 0;
    }

    public int minValue() {
        return this.valueMin;
    }

    public int maxValue() {
        return this.valueMax;
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        comment.add(TomlHelper.fieldInfoRange(this.valueDefault, this.valueMin, this.valueMax));
    }

    @Override
    public void load(@Nullable Object raw) {
        Number newValue;
        if (raw instanceof String) {
            ConfigUtil.LOG.info("Unboxing string value for {} \"{}\" to a different primitive.", this.getClass(), (Object)this.getKey());
            newValue = TomlHelper.parseNumber((String)raw);
        } else {
            newValue = TomlHelper.asNumber(raw);
        }
        if (newValue == null) {
            if (raw != null) {
                ConfigUtil.LOG.warn("Invalid value for {} \"{}\"! Falling back to default. Invalid value: {}", this.getClass(), (Object)this.getKey(), raw);
            }
            this.value = this.valueDefault;
        } else {
            int castValue = newValue.intValue();
            if (castValue < this.valueMin) {
                ConfigUtil.LOG.warn("Value for {} \"{}\" is below the minimum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)this.valueMin, raw);
                this.value = this.valueMin;
            } else if (castValue > this.valueMax) {
                ConfigUtil.LOG.warn("Value for {} \"{}\" is above the maximum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)this.valueMax, raw);
                this.value = this.valueMax;
            } else {
                if ((double)castValue != newValue.doubleValue()) {
                    ConfigUtil.LOG.warn("Value for {} \"{}\" is not an integer! Truncating value. Invalid value: {}", this.getClass(), (Object)this.getKey(), raw);
                }
                this.value = castValue;
            }
        }
    }

    @Override
    public Object getValue() {
        return this.value;
    }

    @Override
    public Object getDefaultValue() {
        return this.valueDefault;
    }

    @Override
    public IConfigFieldWidgetProvider getWidgetProvider() {
        return new NumberFieldWidgetProvider(this, Number::intValue, number -> this.valueMin <= number.intValue() && number.intValue() <= this.valueMax);
    }

    public static enum Range {
        ANY(Integer.MIN_VALUE, Integer.MAX_VALUE),
        POSITIVE(1, Integer.MAX_VALUE),
        NON_NEGATIVE(0, Integer.MAX_VALUE),
        TOKEN_NEGATIVE(-1, Integer.MAX_VALUE);

        public final int MIN;
        public final int MAX;

        private Range(int min, int max) {
            this.MIN = min;
            this.MAX = max;
        }
    }

    public static class RandomRange {
        private final IntField MINIMUM;
        private final IntField MAXIMUM;

        public RandomRange(IntField minimum, IntField maximum) {
            this.MINIMUM = minimum;
            this.MAXIMUM = maximum;
            if (minimum.valueDefault > maximum.valueDefault) {
                throw new IllegalArgumentException(String.format("Random range has inverted default values! (%s > %s) See: (%s, %s)", minimum.valueDefault, maximum.valueDefault, minimum.getKey(), maximum.getKey()));
            }
        }

        public int getMin() {
            return this.MINIMUM.get();
        }

        public int getMax() {
            return this.MAXIMUM.get();
        }

        public int next(Random random) {
            return this.next(random::nextInt);
        }

        public int next(RandomSource random) {
            return this.next(arg_0 -> ((RandomSource)random).m_188503_(arg_0));
        }

        private int next(Function<Integer, Integer> random) {
            int delta = this.getMax() - this.getMin();
            if (delta > 0) {
                return this.getMin() + random.apply(delta + 1);
            }
            if (delta < 0) {
                ConfigUtil.LOG.warn("Value for range \"({},{})\" is invalid ({} > {})! Ignoring maximum value.", (Object)this.MINIMUM.getKey(), (Object)this.MAXIMUM.getKey(), (Object)this.getMin(), (Object)this.getMax());
            }
            return this.getMin();
        }
    }

    public static class Hex
    extends IntField {
        private final int minDigits;

        public Hex(String key, int defaultValue, int digitsMin, int min, int max, String ... description) {
            super(key, defaultValue, min, max, description);
            this.minDigits = digitsMin;
            if (!(min >= 0 && max >= 0 || min == Range.ANY.MIN && max == Range.ANY.MAX)) {
                throw new IllegalArgumentException("Negatives are unsupported by hex int unless allowing any value!");
            }
        }

        public Hex(String key, int defaultValue, int min, int max, String ... description) {
            this(key, defaultValue, 1, min, max, description);
        }

        public int getMinDigits() {
            return this.minDigits;
        }

        @Override
        public void appendFieldInfo(List<String> comment) {
            TomlHelper.HEX_MODE = this.minDigits;
            super.appendFieldInfo(comment);
            TomlHelper.HEX_MODE = 0;
        }

        @Override
        public void writeValue(CrustTomlWriter writer, CharacterOutput output) {
            TomlHelper.HEX_MODE = this.minDigits;
            super.writeValue(writer, output);
            TomlHelper.HEX_MODE = 0;
        }

        @Override
        public IConfigFieldWidgetProvider getWidgetProvider() {
            return new HexIntFieldWidgetProvider(this, number -> this.minValue() <= number && number <= this.maxValue());
        }
    }
}

