/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.field;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.GenericField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.DefaultValueEntry;
import fathertoast.crust.api.config.common.value.NamespaceRegistryEntry;
import fathertoast.crust.api.config.common.value.RegistryEntryValueList;
import fathertoast.crust.api.config.common.value.RegistryValueEntry;
import fathertoast.crust.api.config.common.value.RegistryValueTagEntry;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;

public class RegistryEntryValueListField<T>
extends GenericField<RegistryEntryValueList<T>> {
    public static List<String> verboseDescription() {
        ArrayList<String> comment = new ArrayList<String>();
        comment.add("Registry entry-value list fields: General format = [ \"namespace:registry_name value1 value2 ...\", ... ]");
        comment.add("  Registry entry-value lists are arrays of registry keys. Many things in the game, such as blocks or potions, are defined by their registry key within a registry. For example, all items are registered in the \"minecraft:item\" registry.");
        comment.add("  Registry entry-value lists may have one or multiple numeric values linked to each entry.");
        comment.add("  'default' can be used instead of a registry key to provide default values.");
        comment.add("  An asterisk '*' can be used to match all registry entries/keys belonging to X namespace. For example, 'minecraft:*' will match all vanilla entries.");
        comment.add("  Tags can also be used here. To declare a tag, start with a '#' followed by the rest of the tag path.");
        comment.add("  Tag example: '#minecraft:oak_logs'");
        comment.add("      Priority order: specific entries > tag entries > namespace entries > default");
        return comment;
    }

    public RegistryEntryValueListField(String key, RegistryEntryValueList<T> defaultValue, String ... description) {
        super(key, defaultValue, description);
    }

    @Override
    public void appendFieldInfo(List<String> comment) {
        String fieldFormat;
        int reqValues = ((RegistryEntryValueList)this.valueDefault).getRequiredValues();
        if (reqValues < 0) {
            fieldFormat = "[ \"namespace:registry_name value1 value2 ...\", ... ]";
        } else {
            StringBuilder format = new StringBuilder("[ \"namespace:registry_name ");
            for (int i = 1; i <= reqValues; ++i) {
                format.append("value");
                if (reqValues > 1) {
                    format.append(i);
                }
                format.append(" ");
            }
            format.deleteCharAt(format.length() - 1).append("\", ... ]");
            fieldFormat = format.toString();
        }
        comment.add(TomlHelper.fieldInfoFormat("Registry Entry-value List", this.valueDefault, fieldFormat));
        comment.add("   Target registry: " + ((RegistryEntryValueList)this.valueDefault).getRegistry().get().getRegistryKey().toString());
        if (reqValues != 0) {
            comment.add("   Range for Values: " + TomlHelper.fieldRange(((RegistryEntryValueList)this.valueDefault).getMinValue(), ((RegistryEntryValueList)this.valueDefault).getMaxValue()));
        }
    }

    @Override
    public void load(@Nullable Object raw) {
        if (raw == null) {
            this.value = this.valueDefault;
            return;
        }
        if (raw instanceof RegistryEntryValueList) {
            try {
                this.value = (RegistryEntryValueList)raw;
            }
            catch (Exception e) {
                ConfigUtil.LOG.error("Attempted to cast registry entry value list with wrong generics type!");
            }
        } else {
            List<String> list = TomlHelper.parseStringList(raw);
            ArrayList entryList = new ArrayList();
            ArrayList tagEntries = new ArrayList();
            ArrayList<NamespaceRegistryEntry> namespaceEntries = new ArrayList<NamespaceRegistryEntry>();
            DefaultValueEntry defaultEntry = null;
            for (String line : list) {
                String[] args = line.split(" ");
                if (defaultEntry == null && args[0].equals("default")) {
                    double[] values = this.parseValues(line, args);
                    defaultEntry = new DefaultValueEntry(values);
                    continue;
                }
                if (line.split(" ")[0].endsWith("*")) {
                    namespaceEntries.add(this.parseNamespaceEntry(line));
                    continue;
                }
                if (line.startsWith("#")) {
                    tagEntries.add(this.parseTagEntry(line));
                    continue;
                }
                entryList.add(this.parseEntry(line));
            }
            this.value = new RegistryEntryValueList(defaultEntry, ((RegistryEntryValueList)this.valueDefault).getRegistry(), entryList);
            ((RegistryEntryValueList)this.value).addNamespaceEntries(namespaceEntries);
            ((RegistryEntryValueList)this.value).addTagEntries(tagEntries);
        }
    }

    private RegistryValueEntry<T> parseEntry(String line) {
        String[] args = line.split(" ");
        ResourceLocation regKey = new ResourceLocation(args[0].trim());
        double[] values = this.parseValues(line, args);
        return new RegistryValueEntry(this, regKey, values);
    }

    private RegistryValueTagEntry<T> parseTagEntry(String line) {
        String[] args = line.split(" ");
        String tag = args[0].substring(1);
        if (tag.isEmpty()) {
            ConfigUtil.LOG.error("Tried to parse tag key in RegistryEntryValueList \"{}\", but it was malformed! Expected the format \"#namespace:path\" but got \"{}\"!", (Object)this.getKey(), (Object)line);
            throw new IllegalArgumentException();
        }
        ResourceLocation tagLocation = ResourceLocation.m_135820_((String)tag);
        if (tagLocation == null) {
            ConfigUtil.LOG.error("Tried to parse entity tag in RegistryEntryValueList \"{}\", but it could not be read as a ResourceLocation! Expected the format \"#namespace:path\" but got \"{}\"!", (Object)this.getKey(), (Object)line);
            throw new IllegalArgumentException();
        }
        double[] values = this.parseValues(line, args);
        return new RegistryValueTagEntry(this, new TagKey(((RegistryEntryValueList)this.valueDefault).getRegistry().get().getRegistryKey(), tagLocation), values);
    }

    private NamespaceRegistryEntry parseNamespaceEntry(String line) {
        String[] args = line.split(" ");
        String namespace = args[0].split(":")[0];
        if (namespace == null || namespace.isEmpty()) {
            ConfigUtil.LOG.error("Tried to parse namespace entry in RegistryEntryValueList \"{}\", but it was malformed! Expected the format \"namespace:*\" but got \"{}\"!", (Object)this.getKey(), (Object)line);
            throw new IllegalArgumentException();
        }
        double[] values = this.parseValues(line, args);
        return new NamespaceRegistryEntry(this, namespace, values);
    }

    private double[] parseValues(String line, String[] args) {
        ArrayList<Double> valuesList = new ArrayList<Double>();
        int reqValues = ((RegistryEntryValueList)this.valueDefault).getRequiredValues();
        int actualValues = args.length - 1;
        if (reqValues < 0) {
            if (actualValues < 1) {
                ConfigUtil.LOG.warn("Entry has too few values for {} \"{}\"! Expected at least one value. Replacing missing value with 0. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)line);
                valuesList.add(0.0);
            } else {
                for (i = 1; i < args.length; ++i) {
                    valuesList.add(this.parseValue(args[i], line));
                }
            }
        } else {
            if (reqValues > actualValues) {
                ConfigUtil.LOG.warn("Entry has too few values for {} \"{}\"! Expected {} values, but detected {}. Replacing missing values with 0. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)reqValues, (Object)actualValues, (Object)line);
            } else if (reqValues < actualValues) {
                ConfigUtil.LOG.warn("Entry has too many values for {} \"{}\"! Expected {} values, but detected {}. Deleting additional values. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)reqValues, (Object)actualValues, (Object)line);
            }
            for (i = 1; i < reqValues + 1; ++i) {
                if (i < args.length) {
                    valuesList.add(this.parseValue(args[i], line));
                    continue;
                }
                valuesList.add(0.0);
            }
        }
        double[] values = new double[valuesList.size()];
        for (int i = 0; i < values.length; ++i) {
            values[i] = (Double)valuesList.get(i);
        }
        return values;
    }

    private double parseValue(String arg, String line) {
        double value;
        try {
            value = Double.parseDouble(arg);
        }
        catch (NumberFormatException ex) {
            ConfigUtil.LOG.warn("Invalid value for {} \"{}\"! Falling back to 0. Invalid entry: {}", this.getClass(), (Object)this.getKey(), (Object)line);
            value = 0.0;
        }
        if (value < ((RegistryEntryValueList)this.valueDefault).getMinValue()) {
            ConfigUtil.LOG.warn("Value for {} \"{}\" is below the minimum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)((RegistryEntryValueList)this.valueDefault).getMinValue(), (Object)value);
            value = ((RegistryEntryValueList)this.valueDefault).getMinValue();
        } else if (value > ((RegistryEntryValueList)this.valueDefault).getMaxValue()) {
            ConfigUtil.LOG.warn("Value for {} \"{}\" is above the maximum ({})! Clamping value. Invalid value: {}", this.getClass(), (Object)this.getKey(), (Object)((RegistryEntryValueList)this.valueDefault).getMaxValue(), (Object)value);
            value = ((RegistryEntryValueList)this.valueDefault).getMaxValue();
        }
        return value;
    }

    public boolean contains(@Nullable T regObject) {
        return ((RegistryEntryValueList)this.get()).contains(regObject, null);
    }

    public boolean contains(@Nullable T regObject, Predicate<TagKey<T>> tagCheck) {
        return ((RegistryEntryValueList)this.get()).contains(regObject, tagCheck);
    }

    @Nullable
    public double[] getValues(@Nullable T regObject) {
        return ((RegistryEntryValueList)this.get()).getValues(regObject, null);
    }

    @Nullable
    public double[] getValues(@Nullable T regObject, Predicate<TagKey<T>> tagCheck) {
        return ((RegistryEntryValueList)this.get()).getValues(regObject, tagCheck);
    }

    public double getValue(@Nullable T regObject) {
        return ((RegistryEntryValueList)this.get()).getValue(regObject, null);
    }

    public double getValue(@Nullable T regObject, Predicate<TagKey<T>> tagCheck) {
        return ((RegistryEntryValueList)this.get()).getValue(regObject, tagCheck);
    }

    public boolean rollChance(@Nullable T regObject, RandomSource randomSource) {
        return ((RegistryEntryValueList)this.get()).rollChance(regObject, randomSource, null);
    }

    public boolean rollChance(@Nullable T regObject, RandomSource randomSource, Predicate<TagKey<T>> tagCheck) {
        return ((RegistryEntryValueList)this.get()).rollChance(regObject, randomSource, tagCheck);
    }

    public static class Combined<T> {
        private final RegistryEntryValueListField<T> WHITELIST;
        private final RegistryEntryValueListField<T> BLACKLIST;

        public Combined(RegistryEntryValueListField<T> whitelist, RegistryEntryValueListField<T> blacklist) {
            this.WHITELIST = whitelist;
            this.BLACKLIST = blacklist;
            if (((RegistryEntryValueList)blacklist.valueDefault).getRequiredValues() != 0) {
                throw new IllegalArgumentException("Blacklists cannot have values! See: " + blacklist.getKey());
            }
        }

        public boolean contains(@Nullable T regObject) {
            return regObject != null && !this.BLACKLIST.contains(regObject) && this.WHITELIST.contains(regObject);
        }

        public boolean contains(@Nullable T regObject, Predicate<TagKey<T>> tagCheck) {
            return regObject != null && !this.BLACKLIST.contains(regObject, tagCheck) && this.WHITELIST.contains(regObject, tagCheck);
        }

        @Nullable
        public double[] getValues(@Nullable T regObject) {
            return regObject != null && !this.BLACKLIST.contains(regObject) ? this.WHITELIST.getValues(regObject) : null;
        }

        @Nullable
        public double[] getValues(@Nullable T regObject, Predicate<TagKey<T>> tagCheck) {
            return regObject != null && !this.BLACKLIST.contains(regObject, tagCheck) ? this.WHITELIST.getValues(regObject, tagCheck) : null;
        }

        public double getValue(@Nullable T regObject) {
            return regObject != null && !this.BLACKLIST.contains(regObject) ? this.WHITELIST.getValue(regObject) : 0.0;
        }

        public double getValue(@Nullable T regObject, Predicate<TagKey<T>> tagCheck) {
            return regObject != null && !this.BLACKLIST.contains(regObject, tagCheck) ? this.WHITELIST.getValue(regObject, tagCheck) : 0.0;
        }

        public boolean rollChance(@Nullable T regObject, RandomSource randomSource) {
            return regObject != null && !this.BLACKLIST.contains(regObject) && this.WHITELIST.rollChance(regObject, randomSource);
        }

        public boolean rollChance(@Nullable T regObject, RandomSource randomSource, Predicate<TagKey<T>> tagCheck) {
            return regObject != null && !this.BLACKLIST.contains(regObject, tagCheck) && this.WHITELIST.rollChance(regObject, randomSource, tagCheck);
        }
    }
}

