/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.file;

import com.electronwill.nightconfig.core.ConfigFormat;
import com.electronwill.nightconfig.core.file.FileConfig;
import com.electronwill.nightconfig.core.file.FileWatcher;
import com.electronwill.nightconfig.core.io.CharacterOutput;
import com.electronwill.nightconfig.core.io.ParsingException;
import com.electronwill.nightconfig.core.io.WritingException;
import fathertoast.crust.api.config.client.gui.widget.CrustConfigFieldList;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.field.AttributeListField;
import fathertoast.crust.api.config.common.field.BlockListField;
import fathertoast.crust.api.config.common.field.EntityListField;
import fathertoast.crust.api.config.common.field.EnvironmentListField;
import fathertoast.crust.api.config.common.field.RegistryEntryListField;
import fathertoast.crust.api.config.common.field.RegistryEntryValueListField;
import fathertoast.crust.api.config.common.field.RestartNote;
import fathertoast.crust.api.config.common.file.CrustConfigFormat;
import fathertoast.crust.api.config.common.file.CrustTomlWriter;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.environment.CrustEnvironmentRegistry;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nullable;

public class CrustConfigSpec {
    public final ConfigManager MANAGER;
    public final AbstractConfigFile FILE;
    public final String NAME;
    public String loadingCategory;
    private final FileConfig NIGHT_CONFIG_FILE;
    private final List<Action> ACTIONS = new ArrayList<Action>();
    private final Map<String, AbstractConfigField> FIELD_MAP = new HashMap<String, AbstractConfigField>();
    private volatile boolean initialized;
    volatile boolean writing;

    public File getFile() {
        return this.NIGHT_CONFIG_FILE.getFile();
    }

    public Map<String, AbstractConfigField> getFields() {
        return Collections.unmodifiableMap(this.FIELD_MAP);
    }

    public boolean isInitialized() {
        return this.initialized;
    }

    public void initialize() {
        ConfigUtil.LOG.info("First-time loading config file {}", (Object)ConfigUtil.toRelativePath(this.NIGHT_CONFIG_FILE));
        try {
            this.NIGHT_CONFIG_FILE.load();
        }
        catch (ParsingException ex) {
            ConfigUtil.LOG.error("Failed first-time loading of config file {} - this is bad!", (Object)ConfigUtil.toRelativePath(this.NIGHT_CONFIG_FILE), (Object)ex);
        }
        try {
            FileWatcher.defaultInstance().addWatch(this.NIGHT_CONFIG_FILE.getFile(), this::onFileChanged);
            ConfigUtil.LOG.info("Started watching config file {} for updates", (Object)ConfigUtil.toRelativePath(this.NIGHT_CONFIG_FILE));
        }
        catch (IOException ex) {
            ConfigUtil.LOG.error("Failed to watch config file {} - this file will NOT update in-game until restarted!", (Object)ConfigUtil.toRelativePath(this.NIGHT_CONFIG_FILE), (Object)ex);
        }
        this.initialized = true;
    }

    public void add(Action action) {
        this.ACTIONS.add(action);
    }

    public <T extends AbstractConfigField> T define(T field) {
        return this.define(field, null);
    }

    public <T extends AbstractConfigField> T define(T field, @Nullable RestartNote restartNote) {
        this.add(new Field(this, field, restartNote));
        return field;
    }

    public void callback(Runnable callback) {
        this.add(new ReadCallback(callback));
    }

    public void newLine() {
        this.newLine(1);
    }

    public void newLine(int count) {
        this.add(new NewLines(count));
    }

    public void fileOnlyNewLine() {
        this.fileOnlyNewLine(1);
    }

    public void fileOnlyNewLine(int count) {
        this.add(new FileOnlyNewLines(count));
    }

    public void increaseIndent() {
        this.indent(1);
    }

    public void decreaseIndent() {
        this.indent(-1);
    }

    public void indent(int count) {
        this.add(new Indent(count));
    }

    public void comment(String ... comment) {
        this.comment(TomlHelper.newComment(comment));
    }

    public void comment(List<String> comment) {
        this.add(new Comment(comment));
    }

    public void titledComment(String title, String ... comment) {
        this.titledComment(title, TomlHelper.newComment(comment));
    }

    public void titledComment(String title, List<String> comment) {
        this.add(new TitledComment(title, comment));
    }

    public void fileOnlyComment(String ... comment) {
        this.fileOnlyComment(TomlHelper.newComment(comment));
    }

    public void fileOnlyComment(List<String> comment) {
        this.add(new FileOnlyComment(comment));
    }

    public void subcategory(String name, String ... comment) {
        this.add(new Subcategory(this, name, TomlHelper.newComment(comment)));
    }

    public void appendixHeader(String ... comment) {
        this.add(new AppendixHeader(TomlHelper.newComment(comment)));
    }

    public void describeRegistryEntryList() {
        this.fileOnlyComment(RegistryEntryListField.verboseDescription());
    }

    public void describeRegistryEntryValueList() {
        this.fileOnlyComment(RegistryEntryValueListField.verboseDescription());
    }

    public void describeEntityList() {
        this.fileOnlyComment(EntityListField.verboseDescription());
    }

    public void describeAttributeList() {
        this.fileOnlyComment(AttributeListField.verboseDescription());
    }

    public void describeBlockList() {
        this.fileOnlyComment(BlockListField.verboseDescription());
    }

    public void describeEnvironmentListPart1of2() {
        this.fileOnlyComment(EnvironmentListField.verboseDescription());
    }

    public void describeEnvironmentListPart2of2() {
        this.fileOnlyComment(CrustEnvironmentRegistry.getDescriptions());
    }

    public void header(List<String> comment) {
        this.add(new FileHeader(this, comment));
    }

    public void category(String name, List<String> comment) {
        this.add(new Category(this, name, comment));
    }

    public CrustConfigSpec(ConfigManager cfgManager, AbstractConfigFile cfgFile, String cfgName) {
        this.MANAGER = cfgManager;
        this.FILE = cfgFile;
        this.NAME = cfgName;
        File file = new File(cfgManager.DIR, cfgName + ".toml");
        File dir = file.getParentFile();
        if (!dir.exists() && !dir.mkdirs()) {
            ConfigUtil.LOG.error("Failed to make config folder! Things will likely explode. Create the folder manually to avoid this problem in the future: {}", (Object)dir);
        }
        this.NIGHT_CONFIG_FILE = FileConfig.builder((File)file, (ConfigFormat)new CrustConfigFormat(this)).sync().build();
        if (!this.NIGHT_CONFIG_FILE.getFile().exists()) {
            ConfigUtil.LOG.info("Generating default config file {}", (Object)ConfigUtil.toRelativePath(this.NIGHT_CONFIG_FILE));
            try {
                if (!this.NIGHT_CONFIG_FILE.getFile().createNewFile()) {
                    ConfigUtil.LOG.error("Failed to make blank config file! Things will likely explode. Create the file manually to avoid this problem in the future: {}", (Object)this.NIGHT_CONFIG_FILE.getFile());
                }
            }
            catch (IOException ex) {
                ConfigUtil.LOG.error("Caught exception while generating blank config file! Things will likely explode. Create the file manually to avoid this problem in the future: {}", (Object)this.NIGHT_CONFIG_FILE.getFile(), (Object)ex);
            }
        }
    }

    private void onFileChanged() {
        if (this.writing) {
            ConfigUtil.LOG.debug("Skipping config file reload (it is currently saving) {}", (Object)ConfigUtil.toRelativePath(this.NIGHT_CONFIG_FILE));
        } else if (this.MANAGER.freezeFileWatcher) {
            ConfigUtil.LOG.debug("Skipping config file reload (file watcher paused) {}", (Object)ConfigUtil.toRelativePath(this.NIGHT_CONFIG_FILE));
        } else {
            ConfigUtil.LOG.info("Reloading config file {}", (Object)ConfigUtil.toRelativePath(this.NIGHT_CONFIG_FILE));
            try {
                this.NIGHT_CONFIG_FILE.load();
            }
            catch (ParsingException ex) {
                ConfigUtil.LOG.error("Failed to reload config file {}", (Object)ConfigUtil.toRelativePath(this.NIGHT_CONFIG_FILE), (Object)ex);
            }
        }
    }

    private void save() {
        try {
            this.NIGHT_CONFIG_FILE.save();
        }
        catch (WritingException ex) {
            ConfigUtil.LOG.error("Failed to save config file {}", (Object)ConfigUtil.toRelativePath(this.NIGHT_CONFIG_FILE), (Object)ex);
        }
    }

    public FileConfig getNightConfig() {
        return this.NIGHT_CONFIG_FILE;
    }

    public void onLoad() {
        boolean rewrite = false;
        for (Action action : this.ACTIONS) {
            if (!action.onLoad()) continue;
            rewrite = true;
        }
        if (rewrite) {
            this.save();
        }
    }

    public void write(CrustTomlWriter writer, CharacterOutput output) {
        for (Action action : this.ACTIONS) {
            action.write(writer, output);
        }
    }

    public void initGui(CrustConfigFieldList widget, Consumer<CrustConfigFieldList.Entry> addEntry) {
        for (Action action : this.ACTIONS) {
            action.initGui(widget, addEntry);
        }
    }

    public static class Field
    implements Action {
        private final CrustConfigSpec PARENT;
        private final AbstractConfigField FIELD;
        private final List<String> ADDED_COMMENT;
        private final RestartNote RESTART_NOTE;

        private Field(CrustConfigSpec parent, AbstractConfigField field, @Nullable RestartNote restartNote) {
            this.PARENT = parent;
            this.FIELD = field;
            this.ADDED_COMMENT = new ArrayList<String>();
            field.appendFieldInfo(this.ADDED_COMMENT);
            ((ArrayList)this.ADDED_COMMENT).trimToSize();
            this.RESTART_NOTE = restartNote;
            field.setSpec(parent);
            if (parent.FIELD_MAP.containsKey(field.getKey())) {
                throw new IllegalStateException("Attempted to register duplicate field key '" + field.getKey() + "' in config " + parent.NAME);
            }
            parent.FIELD_MAP.put(this.FIELD.getKey(), this.FIELD);
        }

        @Override
        public boolean onLoad() {
            Object oldValue = this.FIELD.getValue();
            Object raw = this.PARENT.NIGHT_CONFIG_FILE.getOptional(this.FIELD.getKey()).orElse(null);
            this.FIELD.load(raw);
            Object newValue = this.FIELD.getValue();
            if (raw == null || !Objects.equals(oldValue, newValue)) {
                this.PARENT.NIGHT_CONFIG_FILE.set(this.FIELD.getKey(), newValue);
                return true;
            }
            return false;
        }

        @Override
        public void write(CrustTomlWriter writer, CharacterOutput output) {
            writer.writeField(this.FIELD, this.RESTART_NOTE, this.ADDED_COMMENT, output);
        }

        @Override
        public void initGui(CrustConfigFieldList widget, Consumer<CrustConfigFieldList.Entry> addEntry) {
            widget.field(this.FIELD, this.RESTART_NOTE, this.ADDED_COMMENT);
        }
    }

    public static interface Action {
        public boolean onLoad();

        public void write(CrustTomlWriter var1, CharacterOutput var2);

        public void initGui(CrustConfigFieldList var1, Consumer<CrustConfigFieldList.Entry> var2);
    }

    public static class ReadCallback
    implements Action {
        private final Runnable CALLBACK;

        private ReadCallback(Runnable callback) {
            this.CALLBACK = callback;
        }

        @Override
        public boolean onLoad() {
            this.CALLBACK.run();
            return false;
        }

        @Override
        public final void write(CrustTomlWriter writer, CharacterOutput output) {
        }

        @Override
        public void initGui(CrustConfigFieldList widget, Consumer<CrustConfigFieldList.Entry> addEntry) {
        }
    }

    private static class NewLines
    extends Format {
        private final int COUNT;

        private NewLines(int count) {
            this.COUNT = count;
        }

        @Override
        public void write(CrustTomlWriter writer, CharacterOutput output) {
            for (int i = 0; i < this.COUNT; ++i) {
                writer.writeNewLine(output);
            }
        }

        @Override
        public void initGui(CrustConfigFieldList widget, Consumer<CrustConfigFieldList.Entry> addEntry) {
            widget.newLine(this.COUNT);
        }
    }

    private static class FileOnlyNewLines
    extends NewLines {
        private FileOnlyNewLines(int count) {
            super(count);
        }

        @Override
        public void initGui(CrustConfigFieldList widget, Consumer<CrustConfigFieldList.Entry> addEntry) {
        }
    }

    private static class Indent
    extends Format {
        private final int AMOUNT;

        private Indent(int amount) {
            this.AMOUNT = amount;
        }

        @Override
        public void write(CrustTomlWriter writer, CharacterOutput output) {
            writer.changeIndentLevel(this.AMOUNT);
        }

        @Override
        public void initGui(CrustConfigFieldList widget, Consumer<CrustConfigFieldList.Entry> addEntry) {
        }
    }

    private static class Comment
    extends Format {
        protected final List<String> COMMENT;

        private Comment(List<String> comment) {
            this.COMMENT = comment;
        }

        @Override
        public void write(CrustTomlWriter writer, CharacterOutput output) {
            writer.writeComment(this.COMMENT, output);
        }

        @Override
        public void initGui(CrustConfigFieldList widget, Consumer<CrustConfigFieldList.Entry> addEntry) {
            widget.comment(this.COMMENT);
        }
    }

    private static class TitledComment
    extends Comment {
        private final String TITLE;

        private TitledComment(String title, List<String> comment) {
            super(comment);
            this.TITLE = title;
        }

        @Override
        public void write(CrustTomlWriter writer, CharacterOutput output) {
            writer.writeComment(this.TITLE + ":", output);
            super.write(writer, output);
        }

        @Override
        public void initGui(CrustConfigFieldList widget, Consumer<CrustConfigFieldList.Entry> addEntry) {
            widget.titledComment(this.TITLE, this.COMMENT);
        }
    }

    private static class FileOnlyComment
    extends Comment {
        private FileOnlyComment(List<String> comment) {
            super(comment);
        }

        @Override
        public void initGui(CrustConfigFieldList widget, Consumer<CrustConfigFieldList.Entry> addEntry) {
        }
    }

    private static class Subcategory
    extends Format {
        private final CrustConfigSpec PARENT;
        private final String SUBCATEGORY;
        private final List<String> COMMENT;

        private Subcategory(CrustConfigSpec parent, String subcategoryName, List<String> comment) {
            this.PARENT = parent;
            this.SUBCATEGORY = subcategoryName;
            this.COMMENT = comment;
        }

        @Override
        public void write(CrustTomlWriter writer, CharacterOutput output) {
            writer.decreaseIndentLevel();
            writer.writeNewLine(output);
            writer.writeComment("Subcategory: " + this.SUBCATEGORY, output);
            writer.writeComment(this.COMMENT, output);
            writer.increaseIndentLevel();
            writer.writeNewLine(output);
        }

        @Override
        public void initGui(CrustConfigFieldList widget, Consumer<CrustConfigFieldList.Entry> addEntry) {
            widget.newLine();
            widget.header(this.PARENT.loadingCategory + this.SUBCATEGORY, this.COMMENT, 0xFFFFFF);
            widget.newLine();
        }
    }

    private static class AppendixHeader
    extends Format {
        private final List<String> COMMENT;

        private AppendixHeader(List<String> comment) {
            this.COMMENT = comment;
        }

        @Override
        public void write(CrustTomlWriter writer, CharacterOutput output) {
            writer.decreaseIndentLevel();
            writer.writeNewLine(output);
            writer.writeNewLine(output);
            writer.writeComment("Appendix:", output);
            writer.writeComment(this.COMMENT, output);
            writer.writeNewLine(output);
            writer.increaseIndentLevel();
        }

        @Override
        public void initGui(CrustConfigFieldList widget, Consumer<CrustConfigFieldList.Entry> addEntry) {
            widget.newLine(2);
            widget.header("Appendix", null);
            widget.comment(this.COMMENT);
            widget.newLine();
        }
    }

    private static class FileHeader
    extends Format {
        private final CrustConfigSpec PARENT;
        private final List<String> COMMENT;

        private FileHeader(CrustConfigSpec parent, List<String> comment) {
            this.PARENT = parent;
            this.COMMENT = comment;
        }

        @Override
        public void write(CrustTomlWriter writer, CharacterOutput output) {
            writer.writeComment(this.PARENT.MANAGER.MOD_ID + ":" + this.PARENT.NAME + ".toml", output);
            writer.writeComment(this.COMMENT, output);
            writer.increaseIndentLevel();
        }

        @Override
        public void initGui(CrustConfigFieldList widget, Consumer<CrustConfigFieldList.Entry> addEntry) {
            widget.comment(this.COMMENT, 0xFFFFFF);
        }
    }

    private static class Category
    extends Format {
        private final CrustConfigSpec PARENT;
        private final String CATEGORY;
        private final List<String> COMMENT;

        private Category(CrustConfigSpec parent, String categoryName, List<String> comment) {
            this.PARENT = parent;
            this.CATEGORY = categoryName;
            this.COMMENT = comment;
        }

        @Override
        public void write(CrustTomlWriter writer, CharacterOutput output) {
            this.PARENT.loadingCategory = this.CATEGORY + ".";
            writer.decreaseIndentLevel();
            writer.writeNewLine(output);
            writer.writeNewLine(output);
            writer.writeComment("Category: " + this.CATEGORY, output);
            writer.writeComment(this.COMMENT, output);
            writer.increaseIndentLevel();
            writer.writeNewLine(output);
        }

        @Override
        public void initGui(CrustConfigFieldList widget, Consumer<CrustConfigFieldList.Entry> addEntry) {
            this.PARENT.loadingCategory = this.CATEGORY + ".";
            widget.newLine(2);
            widget.header(this.CATEGORY, this.COMMENT);
            widget.newLine();
        }
    }

    public static abstract class Format
    implements Action {
        @Override
        public final boolean onLoad() {
            return false;
        }
    }
}

