/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockEntry
implements Cloneable {
    public final Block BLOCK;
    private final List<State> MATCHERS = new ArrayList<State>();

    public BlockEntry(Block block) {
        this.BLOCK = block;
    }

    public BlockEntry(BlockState block) {
        this(block.m_60734_());
        StateBuilder state = new StateBuilder(this.BLOCK);
        for (Property property : block.m_61147_()) {
            state.add(property, block.m_61143_(property));
        }
        if (!state.isEmpty()) {
            this.MATCHERS.add(state.toTargetState());
        }
    }

    public BlockEntry(AbstractConfigField field, String line) {
        String[] pair = line.split("\\[", 2);
        Block block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(pair[0]));
        Block block2 = this.BLOCK = block == null ? Blocks.f_50016_ : block;
        if (this.BLOCK == Blocks.f_50016_ || pair.length < 2) {
            return;
        }
        if (!pair[1].endsWith("]")) {
            ConfigUtil.LOG.info("Adding closing bracket on block state properties for {} \"{}\". Invalid entry: {}", field.getClass(), (Object)field.getKey(), (Object)line);
            pair[1] = pair[1] + "]";
        }
        State state = BlockEntry.parseState(field, pair[1].substring(0, pair[1].length() - 1), this.BLOCK);
        if (!state.PROPERTIES_TO_MATCH.isEmpty()) {
            this.MATCHERS.add(state);
        }
    }

    public BlockEntry clone() {
        BlockEntry cloned = new BlockEntry(this.BLOCK);
        cloned.MATCHERS.addAll(this.MATCHERS);
        return cloned;
    }

    public String toString() {
        String registryName = ConfigUtil.toString(ForgeRegistries.BLOCKS.getKey((Object)this.BLOCK));
        if (this.MATCHERS.isEmpty()) {
            return registryName;
        }
        StringBuilder str = new StringBuilder();
        for (State state : this.MATCHERS) {
            str.append(registryName).append("[").append(state.toString()).append("],");
        }
        return str.substring(0, str.length() - 1);
    }

    public int hashCode() {
        ResourceLocation regKey = ForgeRegistries.BLOCKS.getKey((Object)this.BLOCK);
        return regKey == null ? 0 : regKey.hashCode();
    }

    public boolean matches(BlockState block) {
        if (this.MATCHERS.isEmpty()) {
            return true;
        }
        for (State state : this.MATCHERS) {
            if (!state.matches(block)) continue;
            return true;
        }
        return false;
    }

    void mergeFrom(BlockEntry other) {
        if (this.MATCHERS.isEmpty()) {
            ConfigUtil.LOG.warn("Ignoring attempt to add redundant block state to config with block state wildcard '{}'", (Object)other);
        } else if (other.MATCHERS.isEmpty()) {
            ConfigUtil.LOG.warn("Adding block state wildcard to config with redundant block state(s) '{}'", (Object)this);
            this.MATCHERS.clear();
        } else {
            this.MATCHERS.addAll(other.MATCHERS);
        }
    }

    private static State parseState(AbstractConfigField field, String stateString, Block block) {
        String[] properties;
        if (stateString.isEmpty()) {
            return new State(Collections.emptyList());
        }
        StateDefinition stateContainer = block.m_49965_();
        StateBuilder builder = new StateBuilder(block);
        for (String combinedEntry : properties = stateString.split(",")) {
            String[] pair = combinedEntry.trim().split("=", 2);
            if (pair.length != 2) {
                ConfigUtil.LOG.warn("Invalid block property for {} \"{}\". Format must be 'property=value'. Deleting property. Invalid property: {}", field.getClass(), (Object)field.getKey(), (Object)combinedEntry.trim());
                continue;
            }
            if (pair[1].equals("*")) continue;
            Property property = stateContainer.m_61081_(pair[0]);
            if (property == null) {
                ArrayList<String> propertyNames = new ArrayList<String>();
                for (Property allowed : stateContainer.m_61092_()) {
                    propertyNames.add(allowed.m_61708_());
                }
                ConfigUtil.LOG.warn("Invalid block property key for {} \"{}\". Valid property keys for '{}' are {}. Deleting property. Invalid property: {}", field.getClass(), (Object)field.getKey(), (Object)ConfigUtil.toString(ForgeRegistries.BLOCKS.getKey((Object)block)), (Object)TomlHelper.literalList(propertyNames), (Object)combinedEntry.trim());
                continue;
            }
            Optional value = property.m_6215_(pair[1]);
            if (value.isEmpty()) {
                ArrayList<String> valueNames = new ArrayList<String>();
                for (Comparable allowed : property.m_6908_()) {
                    valueNames.add(property.m_6940_(BlockEntry.value(allowed)));
                }
                ConfigUtil.LOG.warn("Invalid block property value for {} \"{}\". Valid values for property '{}' are {}. Deleting property. Invalid property: {}", field.getClass(), (Object)field.getKey(), (Object)property.m_61708_(), (Object)TomlHelper.literalList(valueNames), (Object)combinedEntry.trim());
                continue;
            }
            builder.add(property, (Comparable)value.get());
        }
        return builder.toTargetState();
    }

    private static <T extends Comparable<T>> T value(Comparable<?> allowed) {
        return (T)allowed;
    }

    public static final class StateBuilder {
        private final Block BLOCK;
        private final Map<Property<? extends Comparable<?>>, Comparable<?>> propertiesToMatch = new HashMap();

        public StateBuilder(Block block) {
            this.BLOCK = block;
        }

        public boolean isEmpty() {
            return this.propertiesToMatch.isEmpty();
        }

        public boolean contains(Property<? extends Comparable<?>> property) {
            return this.propertiesToMatch.containsKey(property);
        }

        public StateBuilder add(Property<? extends Comparable<?>> property, Comparable<?> value) {
            this.propertiesToMatch.put(property, value);
            return this;
        }

        public BlockEntry toBlockEntry() {
            BlockEntry target = new BlockEntry(this.BLOCK);
            if (!this.isEmpty()) {
                target.MATCHERS.add(this.toTargetState());
            }
            return target;
        }

        private State toTargetState() {
            return new State(new ArrayList(this.propertiesToMatch.entrySet()));
        }
    }

    private static final class State {
        private final List<Map.Entry<Property<?>, Comparable<?>>> PROPERTIES_TO_MATCH;

        private State(List<Map.Entry<Property<?>, Comparable<?>>> properties) {
            this.PROPERTIES_TO_MATCH = Collections.unmodifiableList(properties);
        }

        boolean matches(BlockState block) {
            for (Map.Entry<Property<?>, Comparable<?>> entry : this.PROPERTIES_TO_MATCH) {
                if (!this.notEqual(block.m_61143_(entry.getKey()), entry.getValue())) continue;
                return false;
            }
            return true;
        }

        public BlockState asMatching(BlockState block) {
            if (this.PROPERTIES_TO_MATCH.isEmpty()) {
                return block;
            }
            for (Map.Entry<Property<?>, Comparable<?>> entry : this.PROPERTIES_TO_MATCH) {
                block = this.withProperty(block, entry.getKey(), entry.getValue());
            }
            return block;
        }

        public String toString() {
            if (this.PROPERTIES_TO_MATCH.isEmpty()) {
                return "";
            }
            StringBuilder str = new StringBuilder();
            for (Map.Entry<Property<?>, Comparable<?>> entry : this.PROPERTIES_TO_MATCH) {
                str.append(entry.getKey().m_61708_()).append("=").append(this.getPropertyName(entry.getKey(), entry.getValue())).append(",");
            }
            return str.substring(0, str.length() - 1);
        }

        private <T extends Comparable<T>> BlockState withProperty(BlockState block, Property<T> property, Comparable<?> value) {
            return (BlockState)block.m_61124_(property, value);
        }

        private <T extends Comparable<T>> boolean notEqual(T stateValue, Comparable<?> targetValue) {
            return !stateValue.equals(targetValue);
        }

        private <T extends Comparable<T>> String getPropertyName(Property<T> property, Comparable<?> value) {
            return property.m_6940_(value);
        }
    }
}

