/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.BlockEntry;
import fathertoast.crust.api.config.common.value.IStringArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;

public class BlockList
implements IStringArray {
    private final Map<Block, BlockEntry> UNDERLYING_MAP = new HashMap<Block, BlockEntry>();
    private final List<TagKey<Block>> TAGS = new ArrayList<TagKey<Block>>();
    private final List<String> NAMESPACES = new ArrayList<String>();
    private final List<BlockEntry> PRINT_LIST = new ArrayList<BlockEntry>();

    public BlockList(BlockEntry ... entries) {
        for (BlockEntry entry : entries) {
            this.mergeFrom(entry);
        }
    }

    public BlockList(@Nullable List<String> namespaces, @Nullable List<TagKey<Block>> tags, BlockEntry ... entries) {
        this(entries);
        if (tags != null) {
            this.tags(tags);
        }
        if (namespaces != null) {
            this.namespaces(namespaces);
        }
    }

    public BlockList(AbstractConfigField field, List<String> entries) {
        for (String line : entries) {
            if (line.startsWith("#")) {
                ResourceLocation tagLocation = ResourceLocation.m_135820_((String)line.substring(1));
                if (tagLocation == null) {
                    ConfigUtil.LOG.warn("Invalid tag key for {} \"{}\"! Skipping tag. Invalid tag key: {}", field.getClass(), (Object)field.getKey(), (Object)line);
                    continue;
                }
                this.tag((TagKey<Block>)BlockTags.create((ResourceLocation)tagLocation));
                continue;
            }
            if (line.endsWith("*")) {
                String[] parts = line.split(":");
                if (parts[0].isEmpty()) {
                    ConfigUtil.LOG.warn("Invalid namespace entry for {} \"{}\"! Skipping. Invalid namespace entry: {}", field.getClass(), (Object)field.getKey(), (Object)line);
                    continue;
                }
                this.namespace(parts[0]);
                continue;
            }
            BlockEntry entry = new BlockEntry(field, line);
            if (entry.BLOCK == Blocks.f_50016_) {
                ConfigUtil.LOG.warn("Invalid entry for {} \"{}\"! Deleting entry. Invalid entry: {}", field.getClass(), (Object)field.getKey(), (Object)line);
                continue;
            }
            this.mergeFrom(entry);
        }
    }

    public final BlockList tag(TagKey<Block> tag) {
        boolean exists = false;
        for (TagKey<Block> tagKey : this.TAGS) {
            if (!tag.f_203868_().equals((Object)tagKey.f_203868_())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.TAGS.add(tag);
        }
        return this;
    }

    public final void tags(Collection<TagKey<Block>> tags) {
        if (tags.isEmpty()) {
            return;
        }
        for (TagKey<Block> tag : tags) {
            this.tag(tag);
        }
    }

    public final BlockList namespace(String namespace) {
        boolean exists = false;
        for (String s : this.NAMESPACES) {
            if (!s.equals(namespace)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.NAMESPACES.add(namespace);
        }
        return this;
    }

    public final void namespaces(Collection<String> namespaces) {
        if (namespaces.isEmpty()) {
            return;
        }
        for (String namespace : namespaces) {
            this.namespace(namespace);
        }
    }

    public String toString() {
        return TomlHelper.toLiteral(this.toStringList().toArray());
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof BlockList)) {
            return false;
        }
        return this.toStringList().equals(((BlockList)other).toStringList());
    }

    @Override
    public List<String> toStringList() {
        ArrayList<String> list = new ArrayList<String>(this.PRINT_LIST.size());
        for (BlockEntry blockEntry : this.PRINT_LIST) {
            list.add(blockEntry.toString());
        }
        for (TagKey tagKey : this.TAGS) {
            list.add(ConfigUtil.toString(tagKey));
        }
        for (String string : this.NAMESPACES) {
            list.add(ConfigUtil.namespaceWildcard(string));
        }
        return list;
    }

    public boolean isEmpty() {
        return this.UNDERLYING_MAP.isEmpty() && this.TAGS.isEmpty() && this.NAMESPACES.isEmpty();
    }

    public boolean matches(BlockState blockState) {
        BlockEntry entry = this.UNDERLYING_MAP.get(blockState.m_60734_());
        if (entry != null) {
            return entry.matches(blockState);
        }
        for (TagKey<Block> tagKey : this.TAGS) {
            if (!blockState.m_204336_(tagKey)) continue;
            return true;
        }
        String namespace = ForgeRegistries.BLOCKS.getKey((Object)blockState.m_60734_()).m_135827_();
        for (String ns : this.NAMESPACES) {
            if (!namespace.equals(ns)) continue;
            return true;
        }
        return false;
    }

    private void mergeFrom(BlockEntry otherEntry) {
        this.PRINT_LIST.add(otherEntry);
        BlockEntry currentEntry = this.UNDERLYING_MAP.get(otherEntry.BLOCK);
        if (currentEntry == null) {
            this.UNDERLYING_MAP.put(otherEntry.BLOCK, otherEntry);
        } else {
            currentEntry.mergeFrom(otherEntry);
        }
    }
}

