/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.level.Level;
import net.minecraftforge.registries.ForgeRegistries;

public class EntityEntry {
    private final AbstractConfigField FIELD;
    public final ResourceLocation ENTITY_KEY;
    public final boolean EXTEND;
    public final double[] VALUES;
    private EntityType<? extends Entity> entityType;
    Class<? extends Entity> entityClass;

    EntityEntry(Entity entity) {
        this.FIELD = null;
        this.EXTEND = false;
        this.VALUES = null;
        this.ENTITY_KEY = ForgeRegistries.ENTITY_TYPES.getKey((Object)entity.m_6095_());
        this.entityType = entity.m_6095_();
        this.entityClass = entity.getClass();
    }

    public EntityEntry(@Nonnull EntityType<? extends Entity> type, double ... values) {
        this(type, true, values);
    }

    public EntityEntry(@Nonnull EntityType<? extends Entity> type, boolean extend, double ... values) {
        this(null, Objects.requireNonNull(ForgeRegistries.ENTITY_TYPES.getKey(type)), extend, values);
        this.entityType = type;
    }

    public EntityEntry(@Nullable AbstractConfigField field, @Nonnull ResourceLocation regKey, boolean extend, double ... values) {
        this.FIELD = field;
        this.ENTITY_KEY = regKey;
        this.EXTEND = extend;
        this.VALUES = values;
    }

    private boolean validate() {
        if (this.entityType != null) {
            return true;
        }
        if (!ForgeRegistries.ENTITY_TYPES.containsKey(this.ENTITY_KEY)) {
            ConfigUtil.LOG.warn("Invalid entry for {} \"{}\"! Invalid entry: {}", this.FIELD.getClass(), (Object)this.FIELD.getKey(), (Object)this.ENTITY_KEY.toString());
            return false;
        }
        this.entityType = (EntityType)ForgeRegistries.ENTITY_TYPES.getValue(this.ENTITY_KEY);
        return true;
    }

    void checkClass(Level level) {
        if (this.validate() && this.entityType != null && this.entityClass == null) {
            try {
                Entity entity = this.entityType.m_20615_(level);
                if (entity != null) {
                    this.entityClass = entity.getClass();
                    entity.m_146870_();
                }
            }
            catch (Exception ex) {
                ConfigUtil.LOG.warn("Failed to load class of entity type {}!", this.entityType);
                ex.printStackTrace();
            }
        }
    }

    public boolean contains(EntityEntry entry) {
        if (!this.validate()) {
            return false;
        }
        if (entry.entityType == null) {
            return false;
        }
        if (this.entityClass == entry.entityClass) {
            return !entry.EXTEND;
        }
        if (this.EXTEND) {
            return this.entityClass.isAssignableFrom(entry.entityClass);
        }
        return false;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(this.ENTITY_KEY.toString());
        if (!this.EXTEND) {
            str.insert(0, '~');
        }
        if (this.VALUES != null && this.VALUES.length > 0) {
            for (double value : this.VALUES) {
                str.append(' ').append(value);
            }
        }
        return str.toString();
    }
}

