/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value;

import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.DefaultValueEntry;
import fathertoast.crust.api.config.common.value.EntityEntry;
import fathertoast.crust.api.config.common.value.EntityTagEntry;
import fathertoast.crust.api.config.common.value.IStringArray;
import fathertoast.crust.api.config.common.value.NamespaceRegistryEntry;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;

public class EntityList
implements IStringArray {
    private final EntityEntry[] ENTRIES;
    private final List<EntityTagEntry> TAG_ENTRIES = new ArrayList<EntityTagEntry>();
    private final List<NamespaceRegistryEntry> NAMESPACE_ENTRIES = new ArrayList<NamespaceRegistryEntry>();
    @Nullable
    private final DefaultValueEntry DEFAULT_ENTRY;
    private int entryValues = -1;
    private double minValue = Double.NEGATIVE_INFINITY;
    private double maxValue = Double.POSITIVE_INFINITY;

    public EntityList(@Nullable DefaultValueEntry defaultEntry, List<EntityEntry> entries) {
        this(defaultEntry, entries.toArray(new EntityEntry[0]));
    }

    public EntityList(@Nullable DefaultValueEntry defaultEntry, EntityEntry ... entries) {
        this.ENTRIES = entries;
        this.DEFAULT_ENTRY = defaultEntry;
    }

    public EntityList addTagEntries(List<EntityTagEntry> tagEntries) {
        for (EntityTagEntry entry : tagEntries) {
            TagKey<EntityType<?>> tagKey = entry.TAG;
            boolean exists = false;
            for (EntityTagEntry existingEntry : this.TAG_ENTRIES) {
                if (!existingEntry.TAG.f_203868_().equals((Object)tagKey.f_203868_())) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            this.TAG_ENTRIES.add(entry);
        }
        return this;
    }

    public EntityList addNamespaceEntries(List<NamespaceRegistryEntry> namespaceEntries) {
        for (NamespaceRegistryEntry entry : namespaceEntries) {
            String namespace = entry.NAMESPACE;
            boolean exists = false;
            for (NamespaceRegistryEntry existingEntry : this.NAMESPACE_ENTRIES) {
                if (!existingEntry.NAMESPACE.equals(namespace)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            this.NAMESPACE_ENTRIES.add(entry);
        }
        return this;
    }

    public String toString() {
        return TomlHelper.toLiteral(this.toStringList().toArray());
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof EntityList)) {
            return false;
        }
        return this.toStringList().equals(((EntityList)other).toStringList());
    }

    @Override
    public List<String> toStringList() {
        ArrayList<String> list = new ArrayList<String>(this.ENTRIES.length);
        for (EntityEntry entry : this.ENTRIES) {
            list.add(entry.toString());
        }
        for (EntityTagEntry tagEntry : this.TAG_ENTRIES) {
            list.add(tagEntry.toString());
        }
        for (NamespaceRegistryEntry namespaceEntry : this.NAMESPACE_ENTRIES) {
            list.add(namespaceEntry.toString());
        }
        if (this.DEFAULT_ENTRY != null) {
            list.add(this.DEFAULT_ENTRY.toString());
        }
        return list;
    }

    public boolean contains(@Nullable Entity entity) {
        if (entity == null) {
            return false;
        }
        EntityEntry targetEntry = new EntityEntry(entity);
        for (EntityEntry currentEntry : this.ENTRIES) {
            currentEntry.checkClass(entity.m_9236_());
            if (!currentEntry.contains(targetEntry)) continue;
            return true;
        }
        for (EntityTagEntry tagEntry : this.TAG_ENTRIES) {
            if (!tagEntry.contains(entity.m_6095_())) continue;
            return true;
        }
        for (NamespaceRegistryEntry namespaceEntry : this.NAMESPACE_ENTRIES) {
            if (!namespaceEntry.contains(targetEntry.ENTITY_KEY.m_135827_())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public double[] getValues(@Nullable Entity entity) {
        if (entity == null) {
            return null;
        }
        EntityEntry targetEntry = new EntityEntry(entity);
        EntityEntry bestMatch = null;
        for (EntityEntry currentEntry : this.ENTRIES) {
            currentEntry.checkClass(entity.m_9236_());
            if (!currentEntry.EXTEND && currentEntry.entityClass == targetEntry.entityClass) {
                return currentEntry.VALUES;
            }
            if (!currentEntry.contains(targetEntry) || bestMatch != null && !bestMatch.contains(currentEntry)) continue;
            bestMatch = currentEntry;
        }
        for (EntityTagEntry tagEntry : this.TAG_ENTRIES) {
            if (!tagEntry.contains(entity.m_6095_())) continue;
            return tagEntry.VALUES;
        }
        for (NamespaceRegistryEntry namespaceEntry : this.NAMESPACE_ENTRIES) {
            if (!namespaceEntry.contains(targetEntry.ENTITY_KEY.m_135827_())) continue;
            return namespaceEntry.VALUES;
        }
        if (this.DEFAULT_ENTRY != null) {
            return this.DEFAULT_ENTRY.VALUES;
        }
        return bestMatch == null ? null : bestMatch.VALUES;
    }

    public double getValue(@Nullable Entity entity) {
        double[] values = this.getValues(entity);
        return values == null || values.length < 1 ? 0.0 : values[0];
    }

    public boolean rollChance(@Nullable LivingEntity entity) {
        return this.ENTRIES.length > 0 && entity != null && entity.m_217043_().m_188500_() < this.getValue((Entity)entity);
    }

    public EntityList setSinglePercent() {
        return this.setSingleValue().setRange0to1();
    }

    public EntityList setNoValues() {
        return this.setMultiValue(0);
    }

    public EntityList setSingleValue() {
        return this.setMultiValue(1);
    }

    public EntityList setMultiValue(int numberOfValues) {
        this.entryValues = numberOfValues;
        return this;
    }

    public EntityList setRange0to1() {
        return this.setRange(0.0, 1.0);
    }

    public EntityList setRangePos() {
        return this.setRange(0.0, Double.POSITIVE_INFINITY);
    }

    public EntityList setRange(double min, double max) {
        this.minValue = min;
        this.maxValue = max;
        return this;
    }

    public int getRequiredValues() {
        return this.entryValues;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }
}

