/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class NamespaceRegistryEntry {
    private final AbstractConfigField FIELD;
    public final String NAMESPACE;
    public final double[] VALUES;

    public NamespaceRegistryEntry(@Nonnull String namespace, double ... values) {
        this(null, namespace, values);
    }

    public NamespaceRegistryEntry(@Nullable AbstractConfigField field, @Nonnull String namespace, double ... values) {
        Objects.requireNonNull(namespace);
        this.FIELD = field;
        this.NAMESPACE = namespace;
        this.VALUES = values;
    }

    private boolean validate() {
        return true;
    }

    public boolean contains(String namespace) {
        if (!this.validate()) {
            return false;
        }
        return namespace.equals(this.NAMESPACE);
    }

    public String toString() {
        StringBuilder str = new StringBuilder(ConfigUtil.namespaceWildcard(this.NAMESPACE));
        if (this.VALUES != null) {
            for (double value : this.VALUES) {
                str.append(' ').append(value);
            }
        }
        return str.toString();
    }
}

