/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.IStringArray;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraftforge.registries.IForgeRegistry;

public class RegistryEntryList<T>
implements IStringArray {
    private final IForgeRegistry<T> REGISTRY;
    protected final Set<T> UNDERLYING_SET = new HashSet<T>();
    private final List<TagKey<T>> TAGS = new ArrayList<TagKey<T>>();
    private final List<String> NAMESPACES = new ArrayList<String>();
    protected final List<String> PRINT_LIST = new ArrayList<String>();

    protected RegistryEntryList(IForgeRegistry<T> registry) {
        this.REGISTRY = registry;
    }

    @SafeVarargs
    public RegistryEntryList(IForgeRegistry<T> registry, T ... entries) {
        this(registry);
        for (T entry : entries) {
            if (!this.UNDERLYING_SET.add(entry)) continue;
            this.PRINT_LIST.add(ConfigUtil.toString(registry.getKey(entry)));
        }
    }

    @SafeVarargs
    public RegistryEntryList(IForgeRegistry<T> registry, @Nullable List<String> namespaces, @Nullable List<TagKey<T>> tags, T ... entries) {
        this(registry, entries);
        if (tags != null) {
            this.tags(tags);
        }
        if (namespaces != null) {
            this.namespaces(namespaces);
        }
    }

    public RegistryEntryList(AbstractConfigField field, IForgeRegistry<T> registry, List<String> entries) {
        this(registry);
        for (String line : entries) {
            if (line.startsWith("#")) {
                ResourceLocation tagLocation = ResourceLocation.m_135820_((String)line.substring(1));
                if (tagLocation == null) {
                    ConfigUtil.LOG.warn("Invalid tag key for {} \"{}\"! Skipping tag. Invalid tag key: {}", field.getClass(), (Object)field.getKey(), (Object)line);
                    continue;
                }
                this.tag(new TagKey(registry.getRegistryKey(), tagLocation));
                this.PRINT_LIST.add(line);
                continue;
            }
            if (line.endsWith("*")) {
                String[] parts = line.split(":");
                if (parts[0].isEmpty()) {
                    ConfigUtil.LOG.warn("Invalid namespace entry for {} \"{}\"! Skipping. Invalid namespace entry: {}", field.getClass(), (Object)field.getKey(), (Object)line);
                    continue;
                }
                this.namespace(parts[0]);
                this.PRINT_LIST.add(line);
                continue;
            }
            ResourceLocation regKey = new ResourceLocation(line);
            if (this.mergeFrom(regKey)) {
                this.PRINT_LIST.add(regKey.toString());
                continue;
            }
            ConfigUtil.LOG.warn("Invalid or duplicate entry for {} \"{}\"! Deleting entry. Invalid entry: {}", field.getClass(), (Object)field.getKey(), (Object)line);
        }
    }

    public final void tag(TagKey<T> tag) {
        boolean exists = false;
        for (TagKey<T> tagKey : this.TAGS) {
            if (!tag.f_203868_().equals((Object)tagKey.f_203868_())) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.TAGS.add(tag);
            this.PRINT_LIST.add(ConfigUtil.toString(tag));
        }
    }

    public final void tags(Collection<TagKey<T>> tags) {
        if (tags.isEmpty()) {
            return;
        }
        for (TagKey<T> tag : tags) {
            this.tag(tag);
        }
    }

    public final void namespace(String namespace) {
        boolean exists = false;
        for (String s : this.NAMESPACES) {
            if (!s.equals(namespace)) continue;
            exists = true;
            break;
        }
        if (!exists) {
            this.NAMESPACES.add(namespace);
        }
    }

    public final void namespaces(Collection<String> namespaces) {
        if (namespaces.isEmpty()) {
            return;
        }
        for (String s : namespaces) {
            this.namespace(s);
        }
    }

    public IForgeRegistry<T> getRegistry() {
        return this.REGISTRY;
    }

    public Set<T> getEntries() {
        return Collections.unmodifiableSet(this.UNDERLYING_SET);
    }

    public List<TagKey<T>> getTags() {
        return Collections.unmodifiableList(this.TAGS);
    }

    public List<String> getNamespaces() {
        return Collections.unmodifiableList(this.NAMESPACES);
    }

    public String toString() {
        return TomlHelper.toLiteral(this.PRINT_LIST.toArray());
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof RegistryEntryList)) {
            return false;
        }
        return this.getRegistry() == ((RegistryEntryList)other).getRegistry() && this.toStringList().equals(((RegistryEntryList)other).toStringList());
    }

    @Override
    public List<String> toStringList() {
        return this.PRINT_LIST;
    }

    public boolean isEmpty() {
        return this.UNDERLYING_SET.isEmpty() && this.TAGS.isEmpty() && this.NAMESPACES.isEmpty();
    }

    public boolean contains(@Nullable T entry) {
        if (this.UNDERLYING_SET.contains(entry)) {
            return true;
        }
        if (this.REGISTRY.getKey(entry) != null) {
            for (String namespace : this.NAMESPACES) {
                if (!namespace.equals(this.REGISTRY.getKey(entry).m_135827_())) continue;
                return true;
            }
        }
        return false;
    }

    public boolean containsOrTag(@Nullable T entry, Predicate<TagKey<T>> tagPredicate) {
        if (this.contains(entry)) {
            return true;
        }
        for (TagKey<T> tagKey : this.TAGS) {
            if (!tagPredicate.test(tagKey)) continue;
            return true;
        }
        return false;
    }

    protected boolean mergeFrom(ResourceLocation regKey) {
        Object entry = this.REGISTRY.getValue(regKey);
        return entry != null && this.UNDERLYING_SET.add(entry);
    }
}

