/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value;

import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.DefaultValueEntry;
import fathertoast.crust.api.config.common.value.IStringArray;
import fathertoast.crust.api.config.common.value.NamespaceRegistryEntry;
import fathertoast.crust.api.config.common.value.RegistryValueEntry;
import fathertoast.crust.api.config.common.value.RegistryValueTagEntry;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.function.Predicate;
import java.util.function.Supplier;
import javax.annotation.Nullable;
import net.minecraft.tags.TagKey;
import net.minecraft.util.RandomSource;
import net.minecraftforge.registries.IForgeRegistry;

public class RegistryEntryValueList<T>
implements IStringArray {
    private final RegistryValueEntry<T>[] ENTRIES;
    private final List<RegistryValueTagEntry<T>> TAG_ENTRIES = new ArrayList<RegistryValueTagEntry<T>>();
    private final List<NamespaceRegistryEntry> NAMESPACE_ENTRIES = new ArrayList<NamespaceRegistryEntry>();
    @Nullable
    private final DefaultValueEntry DEFAULT_ENTRY;
    private final Supplier<IForgeRegistry<T>> registrySupplier;
    private int entryValues = -1;
    private double minValue = Double.NEGATIVE_INFINITY;
    private double maxValue = Double.POSITIVE_INFINITY;

    public RegistryEntryValueList(@Nullable DefaultValueEntry defaultEntry, Supplier<IForgeRegistry<T>> registrySupplier, List<RegistryValueEntry<T>> entries) {
        this(defaultEntry, registrySupplier, entries.toArray(new RegistryValueEntry[0]));
    }

    @SafeVarargs
    public RegistryEntryValueList(@Nullable DefaultValueEntry defaultEntry, Supplier<IForgeRegistry<T>> registrySupplier, RegistryValueEntry<T> ... entries) {
        this.ENTRIES = entries;
        this.DEFAULT_ENTRY = defaultEntry;
        this.registrySupplier = registrySupplier;
    }

    public RegistryEntryValueList<T> addTagEntries(List<RegistryValueTagEntry<T>> tagEntries) {
        for (RegistryValueTagEntry<T> entry : tagEntries) {
            TagKey tagKey = entry.TAG;
            boolean exists = false;
            for (RegistryValueTagEntry<T> existingEntry : this.TAG_ENTRIES) {
                if (!existingEntry.TAG.f_203868_().equals((Object)tagKey.f_203868_())) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            this.TAG_ENTRIES.add(entry);
        }
        return this;
    }

    public RegistryEntryValueList<T> addNamespaceEntries(List<NamespaceRegistryEntry> namespaceEntries) {
        for (NamespaceRegistryEntry entry : namespaceEntries) {
            String namespace = entry.NAMESPACE;
            boolean exists = false;
            for (NamespaceRegistryEntry existingEntry : this.NAMESPACE_ENTRIES) {
                if (!existingEntry.NAMESPACE.equals(namespace)) continue;
                exists = true;
                break;
            }
            if (exists) continue;
            this.NAMESPACE_ENTRIES.add(entry);
        }
        return this;
    }

    public Supplier<IForgeRegistry<T>> getRegistry() {
        return this.registrySupplier;
    }

    public Iterable<RegistryValueEntry<T>> getEntries() {
        return List.of(this.ENTRIES);
    }

    public List<RegistryValueTagEntry<T>> getTags() {
        return Collections.unmodifiableList(this.TAG_ENTRIES);
    }

    public List<NamespaceRegistryEntry> getNamespaces() {
        return Collections.unmodifiableList(this.NAMESPACE_ENTRIES);
    }

    public String toString() {
        return TomlHelper.toLiteral(this.toStringList().toArray());
    }

    public boolean equals(@Nullable Object other) {
        if (!(other instanceof RegistryEntryValueList)) {
            return false;
        }
        return this.toStringList().equals(((RegistryEntryValueList)other).toStringList());
    }

    @Override
    public List<String> toStringList() {
        ArrayList<String> list = new ArrayList<String>(this.ENTRIES.length);
        for (RegistryValueEntry<T> entry : this.ENTRIES) {
            list.add(entry.toString());
        }
        for (RegistryValueTagEntry registryValueTagEntry : this.TAG_ENTRIES) {
            list.add(registryValueTagEntry.toString());
        }
        for (NamespaceRegistryEntry namespaceRegistryEntry : this.NAMESPACE_ENTRIES) {
            list.add(namespaceRegistryEntry.toString());
        }
        if (this.DEFAULT_ENTRY != null) {
            list.add(this.DEFAULT_ENTRY.toString());
        }
        return list;
    }

    public boolean contains(@Nullable T registryObject, @Nullable Predicate<TagKey<T>> tagCheck) {
        if (registryObject == null) {
            return false;
        }
        RegistryValueEntry targetEntry = new RegistryValueEntry(this.registrySupplier.get().getKey(registryObject), new double[0]);
        for (RegistryValueEntry<T> currentEntry : this.ENTRIES) {
            if (!currentEntry.contains(this.registrySupplier.get(), targetEntry)) continue;
            return true;
        }
        if (tagCheck != null) {
            for (RegistryValueTagEntry registryValueTagEntry : this.TAG_ENTRIES) {
                if (!tagCheck.test(registryValueTagEntry.TAG)) continue;
                return true;
            }
        }
        for (NamespaceRegistryEntry namespaceRegistryEntry : this.NAMESPACE_ENTRIES) {
            if (!namespaceRegistryEntry.contains(targetEntry.REG_KEY.m_135827_())) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public double[] getValues(@Nullable T registryObject, @Nullable Predicate<TagKey<T>> tagCheck) {
        if (registryObject == null) {
            return null;
        }
        RegistryValueEntry targetEntry = new RegistryValueEntry(this.registrySupplier.get().getKey(registryObject), new double[0]);
        for (RegistryValueEntry<T> currentEntry : this.ENTRIES) {
            if (!currentEntry.contains(this.registrySupplier.get(), targetEntry)) continue;
            return currentEntry.VALUES;
        }
        if (tagCheck != null) {
            for (RegistryValueTagEntry registryValueTagEntry : this.TAG_ENTRIES) {
                if (!tagCheck.test(registryValueTagEntry.TAG)) continue;
                return registryValueTagEntry.VALUES;
            }
        }
        for (NamespaceRegistryEntry namespaceRegistryEntry : this.NAMESPACE_ENTRIES) {
            if (!namespaceRegistryEntry.contains(targetEntry.REG_KEY.m_135827_())) continue;
            return namespaceRegistryEntry.VALUES;
        }
        if (this.DEFAULT_ENTRY != null) {
            return this.DEFAULT_ENTRY.VALUES;
        }
        return null;
    }

    public double getValue(@Nullable T registryObject, @Nullable Predicate<TagKey<T>> tagCheck) {
        double[] values = this.getValues(registryObject, tagCheck);
        return values == null || values.length < 1 ? 0.0 : values[0];
    }

    public boolean rollChance(@Nullable T registryObject, RandomSource random, @Nullable Predicate<TagKey<T>> tagCheck) {
        return this.ENTRIES.length > 0 && registryObject != null && random.m_188500_() < this.getValue(registryObject, tagCheck);
    }

    public RegistryEntryValueList<T> setSinglePercent() {
        return this.setSingleValue().setRange0to1();
    }

    public RegistryEntryValueList<T> setNoValues() {
        return this.setMultiValue(0);
    }

    public RegistryEntryValueList<T> setSingleValue() {
        return this.setMultiValue(1);
    }

    public RegistryEntryValueList<T> setMultiValue(int numberOfValues) {
        this.entryValues = numberOfValues;
        return this;
    }

    public RegistryEntryValueList<T> setRange0to1() {
        return this.setRange(0.0, 1.0);
    }

    public RegistryEntryValueList<T> setRangePos() {
        return this.setRange(0.0, Double.POSITIVE_INFINITY);
    }

    public RegistryEntryValueList<T> setRange(double min, double max) {
        this.minValue = min;
        this.maxValue = max;
        return this;
    }

    public int getRequiredValues() {
        return this.entryValues;
    }

    public double getMinValue() {
        return this.minValue;
    }

    public double getMaxValue() {
        return this.maxValue;
    }
}

