/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;

public class RegistryValueTagEntry<T> {
    private final AbstractConfigField FIELD;
    public final TagKey<T> TAG;
    public final double[] VALUES;

    public RegistryValueTagEntry(ResourceKey<Registry<T>> registryKey, @Nonnull ResourceLocation tagLocation, double ... values) {
        this(null, new TagKey(registryKey, tagLocation), values);
    }

    public RegistryValueTagEntry(@Nonnull TagKey<T> tagKey, double ... values) {
        this(null, tagKey, values);
    }

    public RegistryValueTagEntry(@Nullable AbstractConfigField field, @Nonnull TagKey<T> tagKey, double ... values) {
        Objects.requireNonNull(tagKey);
        this.FIELD = field;
        this.TAG = tagKey;
        this.VALUES = values;
    }

    public String toString() {
        StringBuilder str = new StringBuilder(ConfigUtil.toString(this.TAG));
        if (this.VALUES != null) {
            for (double value : this.VALUES) {
                str.append(' ').append(value);
            }
        }
        return str.toString();
    }
}

