/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.IntField;
import fathertoast.crust.api.config.common.file.CrustConfigSpec;
import fathertoast.crust.api.config.common.file.TomlHelper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import java.util.function.Function;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.util.RandomSource;

public class WeightedList<T extends Value> {
    private final List<Entry<T>> ENTRIES;
    private int totalWeight;

    public WeightedList(CrustConfigSpec SPEC, String key, T[] values, String ... description) {
        this(SPEC, key, Arrays.asList(values), description);
    }

    public WeightedList(CrustConfigSpec SPEC, String key, Iterable<T> values, String ... description) {
        String name = ConfigUtil.camelCaseToLowerSpace((key.startsWith(SPEC.loadingCategory) ? key.substring(SPEC.loadingCategory.length()) : key).replace('_', ' ').replace(".", " > "));
        IntField.Range fieldRange = IntField.Range.NON_NEGATIVE;
        if (description != null) {
            ArrayList<String> comment = TomlHelper.newComment(description);
            comment.add(ChatFormatting.GRAY + TomlHelper.multiFieldInfo(fieldRange));
            SPEC.titledComment(name, comment);
        } else {
            SPEC.titledComment(name, new String[0]);
        }
        ArrayList<Entry<Value>> list = new ArrayList<Entry<Value>>();
        for (Value value : values) {
            list.add(new Entry<Value>(value, SPEC.define(new IntField(key + "." + value.getKey(), value.getDefaultWeight(), fieldRange, value.getComment()))));
        }
        this.ENTRIES = Collections.unmodifiableList(list);
        SPEC.callback(this::recalculateTotalWeight);
    }

    @Nullable
    public T next(Random random) {
        return this.next(random::nextInt);
    }

    @Nullable
    public T next(RandomSource random) {
        return this.next(arg_0 -> ((RandomSource)random).m_188503_(arg_0));
    }

    @Nullable
    private T next(Function<Integer, Integer> random) {
        if (this.isDisabled()) {
            return null;
        }
        int choice = random.apply(this.totalWeight);
        for (Entry<T> entry : this.ENTRIES) {
            if ((choice -= entry.getWeight()) >= 0) continue;
            return entry.getValue();
        }
        ConfigUtil.LOG.error("Weighting error occurred while rolling random item! This may have been caused by configs reloading during random roll (comod). Otherwise, it is very bad. :(");
        return null;
    }

    public boolean isDisabled() {
        return this.totalWeight <= 0;
    }

    public void recalculateTotalWeight() {
        int weight = 0;
        for (Entry<T> entry : this.ENTRIES) {
            weight += entry.getWeight();
        }
        this.totalWeight = weight;
    }

    public static interface Value {
        public String getKey();

        default public int getDefaultWeight() {
            return 1;
        }

        @Nullable
        default public String[] getComment() {
            return null;
        }
    }

    private static class Entry<T extends Value> {
        private final T VALUE;
        private final IntField WEIGHT;

        private Entry(T value, IntField weight) {
            this.VALUE = value;
            this.WEIGHT = weight;
        }

        T getValue() {
            return this.VALUE;
        }

        int getWeight() {
            return this.WEIGHT.get();
        }
    }
}

