/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value.environment;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.environment.AbstractEnvironment;
import fathertoast.crust.api.config.common.value.environment.ComparisonOperator;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;

public abstract class CompareLongEnvironment
extends AbstractEnvironment {
    public final ComparisonOperator COMPARATOR;
    public final long VALUE;

    public CompareLongEnvironment(ComparisonOperator op, long value) {
        this.COMPARATOR = op;
        this.VALUE = value;
    }

    public CompareLongEnvironment(AbstractConfigField field, String line) {
        if (line.isEmpty()) {
            this.COMPARATOR = ComparisonOperator.LESS_THAN;
            this.VALUE = 0L;
            ConfigUtil.LOG.warn("Invalid entry for {} \"{}\"! Not defined. Defaulting to \"{}\". Invalid entry: {}", field.getClass(), (Object)field.getKey(), (Object)this.value(), (Object)line);
        } else {
            ComparisonOperator op = ComparisonOperator.parse(line);
            if (op == null) {
                this.COMPARATOR = ComparisonOperator.LESS_THAN;
                ConfigUtil.LOG.warn("Invalid entry for {} \"{}\"! Comparison not defined (must be in the set [ {} ]). Defaulting to \"{}\". Invalid entry: {}", field.getClass(), (Object)field.getKey(), (Object)TomlHelper.toLiteralList((Object[])ComparisonOperator.values()), (Object)this.COMPARATOR, (Object)line);
            } else {
                this.COMPARATOR = op;
            }
            this.VALUE = this.parseValue(field, line, line.substring(this.COMPARATOR.toString().length()).trim());
        }
    }

    private long parseValue(AbstractConfigField field, String line, String arg) {
        long value;
        try {
            value = Long.parseLong(arg);
        }
        catch (NumberFormatException ex) {
            ConfigUtil.LOG.warn("Invalid entry for {} \"{}\"! Value not defined (must be a long). Defaulting to '0'. Invalid entry: {}", field.getClass(), (Object)field.getKey(), (Object)line);
            value = 0L;
        }
        if (value < this.getMinValue()) {
            ConfigUtil.LOG.warn("Value for {} \"{}\" is below the minimum ({})! Clamping value. Invalid value: {}", field.getClass(), (Object)field.getKey(), (Object)this.getMinValue(), (Object)value);
            value = this.getMinValue();
        } else if (value > this.getMaxValue()) {
            ConfigUtil.LOG.warn("Value for {} \"{}\" is above the maximum ({})! Clamping value. Invalid value: {}", field.getClass(), (Object)field.getKey(), (Object)this.getMaxValue(), (Object)value);
            value = this.getMaxValue();
        }
        return value;
    }

    protected long getMinValue() {
        return Long.MIN_VALUE;
    }

    protected long getMaxValue() {
        return Long.MAX_VALUE;
    }

    @Override
    public String value() {
        return this.COMPARATOR + " " + this.VALUE;
    }

    @Override
    public boolean matches(Level level, @Nullable BlockPos pos) {
        Long actual = this.getActual(level, pos);
        return actual != null && this.COMPARATOR.apply(actual, this.VALUE);
    }

    @Nullable
    public abstract Long getActual(Level var1, @Nullable BlockPos var2);
}

