/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value.environment;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.value.environment.AbstractEnvironment;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public abstract class DynamicRegistryEnvironment<T>
extends AbstractEnvironment {
    private final ConfigManager MANAGER;
    private final AbstractConfigField FIELD;
    protected final boolean INVERT;
    private final ResourceLocation REGISTRY_KEY;
    private T registryEntry;
    private byte version = (byte)-1;

    public DynamicRegistryEnvironment(ConfigManager cfgManager, ResourceLocation regKey, boolean invert) {
        this.MANAGER = cfgManager;
        this.FIELD = null;
        this.INVERT = invert;
        this.REGISTRY_KEY = regKey;
    }

    public DynamicRegistryEnvironment(AbstractConfigField field, String line) {
        this.MANAGER = field.getSpec().MANAGER;
        this.FIELD = field;
        this.INVERT = line.startsWith("!");
        this.REGISTRY_KEY = new ResourceLocation(this.INVERT ? line.substring(1) : line);
    }

    @Override
    public final String value() {
        return (this.INVERT ? "!" : "") + this.REGISTRY_KEY.toString();
    }

    public abstract ResourceKey<Registry<T>> getRegistry();

    @Override
    public final boolean matches(Level level, @Nullable BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return this.matches(serverLevel, pos);
        }
        return this.INVERT;
    }

    public abstract boolean matches(ServerLevel var1, @Nullable BlockPos var2);

    @Nullable
    public final T getRegistryEntry(ServerLevel level) {
        if (this.version != this.MANAGER.getDynamicRegVersion()) {
            this.version = this.MANAGER.getDynamicRegVersion();
            Registry registry = level.m_7654_().m_206579_().m_175515_(this.getRegistry());
            this.registryEntry = registry.m_7745_(this.REGISTRY_KEY);
            if (this.registryEntry == null) {
                ConfigUtil.LOG.info("Missing entry for {} \"{}\"! Not present in registry \"{}\". Missing entry: {}", this.FIELD.getClass(), (Object)this.FIELD.getKey(), (Object)this.getRegistry().m_135782_(), (Object)this.REGISTRY_KEY);
            }
        }
        return this.registryEntry;
    }
}

