/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value.environment;

import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.value.environment.AbstractEnvironment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Registry;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;

public abstract class DynamicRegistryGroupEnvironment<T>
extends AbstractEnvironment {
    private final ConfigManager MANAGER;
    private final AbstractConfigField FIELD;
    protected final boolean INVERT;
    private final String NAMESPACE;
    private List<T> registryEntries;
    private byte version = (byte)-1;

    public DynamicRegistryGroupEnvironment(ConfigManager cfgManager, ResourceLocation regKey, boolean invert) {
        this.MANAGER = cfgManager;
        this.FIELD = null;
        this.INVERT = invert;
        this.NAMESPACE = regKey.toString();
    }

    public DynamicRegistryGroupEnvironment(AbstractConfigField field, String line) {
        this.MANAGER = field.getSpec().MANAGER;
        this.FIELD = field;
        this.INVERT = line.startsWith("!");
        this.NAMESPACE = line.substring(this.INVERT ? 1 : 0, line.length() - 1);
    }

    @Override
    public final String value() {
        return (this.INVERT ? "!" : "") + this.NAMESPACE + "*";
    }

    public abstract ResourceKey<Registry<T>> getRegistry();

    @Override
    public final boolean matches(Level level, @Nullable BlockPos pos) {
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            return this.matches(serverLevel, pos);
        }
        return this.INVERT;
    }

    public abstract boolean matches(ServerLevel var1, @Nullable BlockPos var2);

    protected final List<T> getRegistryEntries(ServerLevel level) {
        if (this.version != this.MANAGER.getDynamicRegVersion()) {
            this.version = this.MANAGER.getDynamicRegVersion();
            this.registryEntries = new ArrayList<T>();
            Registry registry = level.m_7654_().m_206579_().m_175515_(this.getRegistry());
            for (ResourceLocation regKey : registry.m_6566_()) {
                Object entry;
                if (!regKey.toString().startsWith(this.NAMESPACE) || (entry = registry.m_7745_(regKey)) == null) continue;
                this.registryEntries.add(entry);
            }
            if (this.registryEntries.isEmpty()) {
                ConfigUtil.LOG.info("Namespace entry for {} \"{}\" did not match anything in registry \"{}\"! Questionable entry: {}", this.FIELD == null ? "DEFAULT" : this.FIELD.getClass(), (Object)(this.FIELD == null ? "DEFAULT" : this.FIELD.getKey()), (Object)this.getRegistry().m_135782_(), (Object)this.NAMESPACE);
            }
            this.registryEntries = Collections.unmodifiableList(this.registryEntries);
        }
        return this.registryEntries;
    }
}

