/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value.environment;

import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.environment.AbstractEnvironment;
import java.util.Locale;

public abstract class EnumEnvironment<T extends Enum<T>>
extends AbstractEnvironment {
    protected final boolean INVERT;
    protected final T VALUE;

    public EnumEnvironment(T value, boolean invert) {
        this.INVERT = invert;
        this.VALUE = value;
    }

    public EnumEnvironment(AbstractConfigField field, String line, T[] validValues) {
        this.INVERT = line.startsWith("!");
        this.VALUE = this.parseValue(field, line, (Enum[])validValues, this.INVERT ? line.substring(1) : line);
    }

    private T parseValue(AbstractConfigField field, String line, T[] validValues, String name) {
        for (T value : validValues) {
            if (!((Enum)value).name().equalsIgnoreCase(name)) continue;
            return value;
        }
        ConfigUtil.LOG.warn("Invalid entry for {} \"{}\"! Value not defined (must be in the set [ {} ]). Defaulting to {}. Invalid entry: {}", field.getClass(), (Object)field.getKey(), (Object)TomlHelper.toLiteralList(validValues), (Object)TomlHelper.toLiteral(validValues[0]), (Object)line);
        return validValues[0];
    }

    @Override
    public final String value() {
        return (this.INVERT ? "!" : "") + ((Enum)this.VALUE).name().toLowerCase(Locale.ROOT);
    }
}

