/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.config.common.value.environment.position;

import fathertoast.crust.api.config.common.field.AbstractConfigField;
import fathertoast.crust.api.config.common.value.environment.EnumEnvironment;
import java.util.function.BiFunction;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.level.Level;

public class PositionEnvironment
extends EnumEnvironment<Value> {
    public PositionEnvironment(Value value, boolean invert) {
        super(value, invert);
    }

    public PositionEnvironment(AbstractConfigField field, String line) {
        super(field, line, (Enum[])Value.values());
    }

    @Override
    public boolean matches(Level level, @Nullable BlockPos pos) {
        return ((Value)this.VALUE).of(level, pos) != this.INVERT;
    }

    public static enum Value {
        CAN_SEE_SKY((level, pos) -> pos != null && level.m_45527_(pos)),
        IS_IN_VILLAGE((level, pos) -> pos != null && level instanceof ServerLevel && ((ServerLevel)level).m_8802_(pos)),
        IS_NEAR_VILLAGE((level, pos) -> pos != null && level instanceof ServerLevel && ((ServerLevel)level).m_8736_(pos, 3)),
        IS_NEAR_RAID((level, pos) -> pos != null && level instanceof ServerLevel && ((ServerLevel)level).m_8843_(pos)),
        IS_IN_WATER((level, pos) -> pos != null && level.m_6425_(pos).m_205070_(FluidTags.f_13131_)),
        IS_IN_LAVA((level, pos) -> pos != null && level.m_6425_(pos).m_205070_(FluidTags.f_13132_)),
        IS_IN_FLUID((level, pos) -> pos != null && !level.m_6425_(pos).m_76178_()),
        HAS_REDSTONE_POWER((level, pos) -> pos != null && level.m_277173_(pos) > 0);

        private final BiFunction<Level, BlockPos, Boolean> SUPPLIER;

        private Value(BiFunction<Level, BlockPos, Boolean> supplier) {
            this.SUPPLIER = supplier;
        }

        public boolean of(Level world, @Nullable BlockPos pos) {
            return this.SUPPLIER.apply(world, pos);
        }
    }
}

