/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.lib;

import net.minecraft.util.Mth;

public final class CrustMath {
    public static int toRGB(float r, float g, float b) {
        return CrustMath.bitsToRGB(Mth.m_14167_((float)(r * 255.0f)), Mth.m_14167_((float)(g * 255.0f)), Mth.m_14167_((float)(b * 255.0f)));
    }

    public static int toARGB(float a, float r, float g, float b) {
        return CrustMath.bitsToARGB(Mth.m_14167_((float)(a * 255.0f)), Mth.m_14167_((float)(r * 255.0f)), Mth.m_14167_((float)(g * 255.0f)), Mth.m_14167_((float)(b * 255.0f)));
    }

    public static int bitsToRGB(int r, int g, int b) {
        return (r & 0xFF) << 16 | (g & 0xFF) << 8 | b & 0xFF;
    }

    public static int bitsToARGB(int a, int r, int g, int b) {
        return (a & 0xFF) << 24 | CrustMath.toRGB(r, g, b);
    }

    public static int getRedBits(int color) {
        return color >> 16 & 0xFF;
    }

    public static int getGreenBits(int color) {
        return color >> 8 & 0xFF;
    }

    public static int getBlueBits(int color) {
        return color & 0xFF;
    }

    public static int getAlphaBits(int color) {
        return color >> 24 & 0xFF;
    }

    public static float getRed(int color) {
        return (float)CrustMath.getRedBits(color) / 255.0f;
    }

    public static float getGreen(int color) {
        return (float)CrustMath.getGreenBits(color) / 255.0f;
    }

    public static float getBlue(int color) {
        return (float)CrustMath.getBlueBits(color) / 255.0f;
    }

    public static float getAlpha(int color) {
        return (float)CrustMath.getAlphaBits(color) / 255.0f;
    }
}

