/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.api.lib;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="crust")
public final class DeferredAction {
    private static final List<Supplier<Boolean>> TICK_END_ACTIONS = new ArrayList<Supplier<Boolean>>();

    public static void queue(Supplier<Boolean> action) {
        TICK_END_ACTIONS.add(action);
    }

    public static void queue(int delay, Supplier<Boolean> action) {
        TICK_END_ACTIONS.add(new DelayedAction(delay, action));
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && !TICK_END_ACTIONS.isEmpty()) {
            TICK_END_ACTIONS.removeIf(Supplier::get);
        }
    }

    private static class DelayedAction
    implements Supplier<Boolean> {
        int delayRemaining;
        final Supplier<Boolean> underlyingAction;

        DelayedAction(int delay, Supplier<Boolean> action) {
            this.delayRemaining = delay;
            this.underlyingAction = action;
        }

        @Override
        public Boolean get() {
            if (this.delayRemaining <= 0) {
                return this.underlyingAction.get();
            }
            --this.delayRemaining;
            return false;
        }
    }
}

