/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.client;

import com.mojang.blaze3d.platform.InputConstants;
import fathertoast.crust.api.config.client.gui.screen.CrustConfigSelectScreen;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.client.ClientRegister;
import fathertoast.crust.client.SortedKeyBinding;
import fathertoast.crust.client.button.ButtonInfo;
import fathertoast.crust.client.config.ExtraInvButtonsCrustConfigFile;
import java.util.List;
import java.util.Locale;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.InputEvent;
import net.minecraftforge.client.event.RegisterKeyMappingsEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(value={Dist.CLIENT}, modid="crust")
public class KeyBindingEvents {
    private static final String KEY_CAT = "key.categories.crust";
    private static final String KEY_CAT_BUTTONS = "key.categories.crust.buttons";
    private static final String KEY = "key.crust.";
    private static final KeyMapping CONFIG_EDITOR = new SortedKeyBinding(0, "key.crust.configs", "key.categories.crust");
    private static KeyMapping[] BUTTONS;

    static void register(RegisterKeyMappingsEvent event) {
        ClientRegister.EXTRA_INV_BUTTONS = new ExtraInvButtonsCrustConfigFile(ConfigManager.getRequired("crust"), "client_extra_inv_buttons");
        KeyBindingEvents.init();
        event.register(CONFIG_EDITOR);
        for (KeyMapping binding : BUTTONS) {
            event.register(binding);
        }
    }

    @SubscribeEvent
    static void onKeyInput(InputEvent.Key event) {
        Minecraft minecraft = Minecraft.m_91087_();
        Screen screen = minecraft.f_91080_;
        if (event.getKey() == InputConstants.f_84822_.m_84873_() || screen != null && screen.m_7043_()) {
            return;
        }
        if (event.getAction() == 1) {
            if (event.getKey() == CONFIG_EDITOR.getKey().m_84873_() && CONFIG_EDITOR.isConflictContextAndModifierActive()) {
                minecraft.m_91152_((Screen)new CrustConfigSelectScreen(screen));
            } else {
                for (int i = 0; i < BUTTONS.length; ++i) {
                    KeyMapping binding = BUTTONS[i];
                    if (event.getKey() != binding.getKey().m_84873_() || !binding.isConflictContextAndModifierActive()) continue;
                    KeyBindingEvents.pressButton((String)(i < ButtonInfo.builtInIds().size() ? ButtonInfo.builtInIds().get(i) : "custom" + (i + 1 - ButtonInfo.builtInIds().size())));
                    break;
                }
            }
        }
    }

    private static void pressButton(String id) {
        ButtonInfo button = ButtonInfo.get(id);
        if (button == null) {
            return;
        }
        button.ON_PRESS.m_93750_(null);
    }

    protected static void init() {
        int index;
        String key = "key.crust.buttons.";
        List<String> builtInButtons = ButtonInfo.builtInIds();
        BUTTONS = new KeyMapping[builtInButtons.size() + ClientRegister.EXTRA_INV_BUTTONS.CUSTOM_BUTTONS.length];
        for (index = 0; index < builtInButtons.size(); ++index) {
            ButtonInfo button = ButtonInfo.get(builtInButtons.get(index));
            if (button == null) continue;
            KeyBindingEvents.BUTTONS[index] = new SortedKeyBinding(index, key + button.ID.toLowerCase(Locale.ROOT), KEY_CAT_BUTTONS);
        }
        for (int i = 0; i < ClientRegister.EXTRA_INV_BUTTONS.CUSTOM_BUTTONS.length; ++i) {
            KeyBindingEvents.BUTTONS[index + i] = new SortedKeyBinding(index + i, key + "custom" + (i + 1), KEY_CAT_BUTTONS);
        }
    }
}

