/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.client.config;

import fathertoast.crust.api.config.common.AbstractConfigCategory;
import fathertoast.crust.api.config.common.AbstractConfigFile;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.ConfigUtil;
import fathertoast.crust.api.config.common.field.BooleanField;
import fathertoast.crust.api.config.common.field.ColorIntField;
import fathertoast.crust.api.config.common.field.DoubleField;
import fathertoast.crust.api.config.common.field.EnumField;
import fathertoast.crust.api.config.common.field.IntField;
import fathertoast.crust.api.config.common.field.StringField;
import fathertoast.crust.api.config.common.field.StringListField;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.api.config.common.value.CrustAnchor;
import fathertoast.crust.client.button.ButtonInfo;
import java.awt.Color;
import java.util.Arrays;
import java.util.List;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.level.biome.Biomes;
import net.minecraft.world.level.storage.loot.BuiltInLootTables;
import net.minecraftforge.registries.ForgeRegistries;

public class ExtraInvButtonsCrustConfigFile
extends AbstractConfigFile {
    public final General GENERAL;
    public final BuiltInButtons BUILT_IN_BUTTONS;
    public final CustomButton[] CUSTOM_BUTTONS = new CustomButton[16];

    public ExtraInvButtonsCrustConfigFile(ConfigManager cfgManager, String cfgName) {
        super(cfgManager, cfgName, "Options to modify the extra inventory buttons displayed. Extra inventory buttons are essentially macros that send commands for you. You still need adequate permission to run the commands.", "In general, you must close and reopen your inventory to see changes made to this config.");
        this.GENERAL = new General(this);
        this.BUILT_IN_BUTTONS = new BuiltInButtons(this);
        for (int i = 0; i < this.CUSTOM_BUTTONS.length; ++i) {
            this.CUSTOM_BUTTONS[i] = new CustomButton(this, i);
        }
    }

    public static class CustomButton
    extends AbstractConfigCategory<ExtraInvButtonsCrustConfigFile> {
        public final StringField tooltip;
        public final StringField icon;
        public final ColorIntField iconColor;
        public final StringListField commands;

        CustomButton(ExtraInvButtonsCrustConfigFile parent, int index) {
            super(parent, ButtonInfo.customId(index), "Options defining the look and function of custom button #" + (index + 1) + ".");
            String[] defaults = CustomButton.getDefaults(index);
            List<String> defaultList = Arrays.asList(defaults);
            this.tooltip = this.SPEC.define(new StringField("tooltip", defaults[0], new String[]{"A short description of the custom button's function."}));
            this.icon = this.SPEC.define(new StringField("icon", defaults[1], new String[]{"The button icon. This is a relative path from \"crust:textures/icon/\". If this does not end in \".png\", this string will be rendered instead of a texture."}));
            this.iconColor = this.SPEC.define(new ColorIntField("icon_color", Color.WHITE, false, "The button icon (or text) color. Pure white (the default) is effectively no tint."));
            this.commands = this.SPEC.define(new StringListField("commands", "Command", defaultList.subList(2, defaultList.size()), "A list of commands to execute when the custom button is pressed. These are sent to the server in the order listed, as if you typed them into chat."));
            String id = ButtonInfo.customId(index);
            this.SPEC.callback(() -> ButtonInfo.loadCustomButton(id, this));
        }

        public static String[] getDefaults(int index) {
            int i = -1;
            if (++i == index) {
                return new String[]{"+5 levels", "xp_plus.png", "experience add @s 5 levels"};
            }
            if (++i == index) {
                return new String[]{"-5 levels", "xp_minus.png", "experience add @s -5 levels"};
            }
            if (++i == index) {
                return new String[]{"Locate woodland mansion", "map_mansion.png", "locate mansion"};
            }
            if (++i == index) {
                return new String[]{"Locate ocean monument", "map_monument.png", "locate monument"};
            }
            if (++i == index) {
                return new String[]{"Locate stronghold", "ender_eye.png", "locate stronghold"};
            }
            if (++i == index) {
                return new String[]{"Locate jungle biome", "world.png", "locatebiome " + ConfigUtil.toString(Biomes.f_48222_)};
            }
            if (++i == index) {
                return new String[]{"Reload data packs", "crafting_table_side.png", "reload"};
            }
            if (++i == index) {
                return new String[]{"Grant all advancements", "cake.png", "advancement grant @s everything"};
            }
            if (++i == index) {
                return new String[]{"Revoke all advancements", "cake_is_a_lie.png", "advancement revoke @s everything"};
            }
            if (++i == index) {
                return new String[]{"Set spawn point", "compass.png", "spawnpoint"};
            }
            if (++i == index) {
                return new String[]{"\"Respawn\"", "soul.png", "kill"};
            }
            if (++i == index) {
                return new String[]{"Clear inventory", "fire.png", "clear"};
            }
            if (++i == index) {
                return new String[]{"Simulate chest loot", "chest_open.png", "clear", "loot give @s loot " + ConfigUtil.toString(BuiltInLootTables.f_78742_)};
            }
            if (++i == index) {
                return new String[]{"Simulate loot of nearest mob", "kill.png", "loot give @s kill @e[limit=1,sort=nearest,type=!player]"};
            }
            if (++i == index) {
                String pattern = "attribute @e[limit=1,sort=nearest,type=!player] %s get";
                return new String[]{"Check attributes of nearest mob", "magnifying_glass.png", String.format(pattern, ConfigUtil.toString(ForgeRegistries.ATTRIBUTES.getKey((Object)Attributes.f_22276_))), String.format(pattern, ConfigUtil.toString(ForgeRegistries.ATTRIBUTES.getKey((Object)Attributes.f_22284_))), String.format(pattern, ConfigUtil.toString(ForgeRegistries.ATTRIBUTES.getKey((Object)Attributes.f_22285_))), String.format(pattern, ConfigUtil.toString(ForgeRegistries.ATTRIBUTES.getKey((Object)Attributes.f_22277_))), String.format(pattern, ConfigUtil.toString(ForgeRegistries.ATTRIBUTES.getKey((Object)Attributes.f_22279_))), String.format(pattern, ConfigUtil.toString(ForgeRegistries.ATTRIBUTES.getKey((Object)Attributes.f_22281_)))};
            }
            return new String[]{ButtonInfo.customId(index), "" + (index + 1), "kill"};
        }
    }

    public static class General
    extends AbstractConfigCategory<ExtraInvButtonsCrustConfigFile> {
        public final BooleanField enabled;
        public final BooleanField disableInvalid;
        public final BooleanField hideUnusable;
        public final BooleanField hideForRecipeBook;
        public final IntField buttonsPerRow;
        public final StringListField buttons;
        public final EnumField<CrustAnchor> anchorY;
        public final EnumField<CrustAnchor> anchorX;
        public final IntField offsetY;
        public final IntField offsetX;

        General(ExtraInvButtonsCrustConfigFile parent) {
            super(parent, "general", "Options to modify the extra inventory buttons displayed. Extra inventory buttons are essentially macros that send commands for you.", "You still need permission to run the commands.");
            this.enabled = this.SPEC.define(new BooleanField("enabled", false, "Whether extra inventory buttons are enabled. Each may still be hidden/disabled individually.", "Does not affect hotkeys (key bindings) assigned to buttons."));
            this.SPEC.newLine();
            this.disableInvalid = this.SPEC.define(new BooleanField("disable_invalid", true, "If true, built-in buttons that are invalid due to temporary conditions will be grayed-out."));
            this.hideUnusable = this.SPEC.define(new BooleanField("hide_unusable", true, "If true, buttons that are unusable due to permissions will not be displayed."));
            this.hideForRecipeBook = this.SPEC.define(new BooleanField("hide_for_recipe_book", true, "If true, extra inventory buttons will be hidden while the recipe book is open."));
            this.SPEC.newLine();
            this.buttonsPerRow = this.SPEC.define(new IntField("buttons_per_row", 4, IntField.Range.NON_NEGATIVE, "The number of buttons that can be displayed per row. The number of rows is automatically calculated."));
            this.buttons = this.SPEC.define(new StringListField("displayed_buttons", "Button", Arrays.asList(ButtonInfo.MAGNET_MODE.ID, ButtonInfo.DESTROY_POINTER_ITEM.ID, ButtonInfo.TOGGLE_RAIN.ID, ButtonInfo.WEATHER_STORM.ID, ButtonInfo.SUPER_VISION_MODE.ID, ButtonInfo.SUPER_SPEED_MODE.ID, ButtonInfo.DAY.ID, ButtonInfo.NIGHT.ID, ButtonInfo.NO_PICKUP_MODE.ID, ButtonInfo.GOD_MODE.ID, ButtonInfo.GAME_MODE.ID, ButtonInfo.KILL_ALL.ID, ButtonInfo.NETHER_PORTAL.ID, ButtonInfo.END_PORTAL.ID, ButtonInfo.CLEAR_EFFECTS.ID, ButtonInfo.FULL_HEAL.ID), "The buttons displayed in the inventory, in the order you want them displayed. These are ordered left-to-right, then wrapped into rows. See below for all valid button names.", "You may assign a hotkey to any button in your options, whether or not you choose to display it."));
            this.SPEC.titledComment("Built-in buttons", TomlHelper.literalList(ButtonInfo.builtInIds()));
            this.SPEC.titledComment("Custom buttons", "\"" + ButtonInfo.customId(0) + "\", \"" + ButtonInfo.customId(1) + "\", ..., \"" + ButtonInfo.customId(parent.CUSTOM_BUTTONS.length - 1) + "\".  (same as the category name).");
            this.SPEC.newLine();
            this.anchorY = this.SPEC.define(new EnumField("anchor.vertical", (Enum)CrustAnchor.SCREEN_TOP, (Enum[])CrustAnchor.VERTICAL_GUI, new String[]{"The anchor position for the extra inventory buttons. That is, where they should be positioned relative to the screen or inventory GUI."}));
            this.anchorX = this.SPEC.define(new EnumField("anchor.horizontal", (Enum)CrustAnchor.SCREEN_LEFT, (Enum[])CrustAnchor.HORIZONTAL_GUI, (String[])null));
            this.SPEC.newLine();
            this.offsetY = this.SPEC.define(new IntField("offset.vertical", 16, IntField.Range.ANY, "The position offset for the extra inventory buttons from the anchor position, in GUI pixels. Negative values move the buttons toward the top/left, positive move them toward the bottom/right."));
            this.offsetX = this.SPEC.define(new IntField("offset.horizontal", 16, IntField.Range.ANY, (String[])null));
        }
    }

    public static class BuiltInButtons
    extends AbstractConfigCategory<ExtraInvButtonsCrustConfigFile> {
        public final IntField weatherDuration;
        public final DoubleField magnetMaxRange;
        public final BooleanField godModeUndying;
        public final BooleanField godModeUnbreaking;
        public final IntField godModeUneating;
        public final DoubleField superSpeedMulti;

        BuiltInButtons(ExtraInvButtonsCrustConfigFile parent) {
            super(parent, "built_in_buttons", "Options for built-in buttons.");
            this.weatherDuration = this.SPEC.define(new IntField("weather.duration", 6000, 0, 1000000, "The duration (seconds) to set the weather for when using the various built-in weather buttons. If 0, the duration is decided 'naturally' by the world."));
            this.SPEC.newLine();
            this.magnetMaxRange = this.SPEC.define(new DoubleField("magnet_mode.max_range", 3.4E38, DoubleField.Range.NON_NEGATIVE, "The max range (blocks) to request for magnet mode when using the \"" + ButtonInfo.MAGNET_MODE.ID + "\" button. Leaving this at a very high value effectively just sets your range to the max allowed by the server."));
            this.SPEC.newLine();
            this.godModeUndying = this.SPEC.define(new BooleanField("god_mode.undying", true, "Whether undying mode (prevents death) should be toggled when using the \"" + ButtonInfo.GOD_MODE.ID + "\" button."));
            this.godModeUnbreaking = this.SPEC.define(new BooleanField("god_mode.unbreaking", true, "Whether unbreaking mode (prevents item break) should be toggled when using the \"" + ButtonInfo.GOD_MODE.ID + "\" button."));
            this.godModeUneating = this.SPEC.define(new IntField("god_mode.uneating", 7, 0, 20, "The level for uneating mode (minimum food level in half-drumsticks) to request when using the \"" + ButtonInfo.GOD_MODE.ID + "\" button. Set this to 0 if you don't want to toggle uneating mode."));
            this.SPEC.callback(() -> ButtonInfo.updateGodModePerms(this));
            this.SPEC.newLine();
            this.superSpeedMulti = this.SPEC.define(new DoubleField("super_speed.multiplier", 8.0, 1.0, Double.POSITIVE_INFINITY, "The speed multiplier to request for super-speed mode when using the \"" + ButtonInfo.SUPER_SPEED_MODE.ID + "\" button. Setting this at a very high value effectively just sets your speed to the max allowed by the server.", "Warning: Very large speed multipliers may break the game's physics."));
        }
    }
}

