/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.common.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fathertoast.crust.api.config.common.file.TomlHelper;
import fathertoast.crust.common.command.CommandUtil;
import fathertoast.crust.common.mode.CrustModes;
import fathertoast.crust.common.mode.CrustModesData;
import fathertoast.crust.common.mode.type.CrustMode;
import java.util.Collection;
import javax.annotation.Nullable;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;

public class CrustModeCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder argBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)CommandUtil.literal("crustmode").executes(context -> CrustModeCommand.runQuery((CommandSourceStack)context.getSource(), CommandUtil.player((CommandContext<CommandSourceStack>)context)))).then(CommandUtil.argumentPlayer("player").executes(context -> CrustModeCommand.runQuery((CommandSourceStack)context.getSource(), CommandUtil.player((CommandContext<CommandSourceStack>)context, "player"))));
        for (CrustMode<?> mode : CrustModes.registry().values()) {
            argBuilder.then(((LiteralArgumentBuilder)((LiteralArgumentBuilder)CommandUtil.literal(mode.ID).requires(source -> source.m_6761_(mode.OP_LEVEL.get().intValue()))).then(((LiteralArgumentBuilder)CommandUtil.literal("disable").executes(context -> CrustModeCommand.runSet((CommandContext<CommandSourceStack>)context, mode, null, CommandUtil.players((CommandContext<CommandSourceStack>)context)))).then(CommandUtil.argumentPlayers("players").executes(context -> CrustModeCommand.runSet((CommandContext<CommandSourceStack>)context, mode, null, CommandUtil.players((CommandContext<CommandSourceStack>)context, "players")))))).then(((RequiredArgumentBuilder)mode.commandArgument("value").executes(context -> CrustModeCommand.runSet((CommandContext<CommandSourceStack>)context, mode, "value", CommandUtil.players((CommandContext<CommandSourceStack>)context)))).then(CommandUtil.argumentPlayers("players").executes(context -> CrustModeCommand.runSet((CommandContext<CommandSourceStack>)context, mode, "value", CommandUtil.players((CommandContext<CommandSourceStack>)context, "players"))))));
        }
        dispatcher.register(argBuilder);
    }

    private static int runQuery(CommandSourceStack source, ServerPlayer player) {
        CrustModesData playerModes = CrustModesData.of((Player)player);
        StringBuilder output = new StringBuilder("[ ");
        int modes = 0;
        for (CrustMode<?> mode : CrustModes.registry().values()) {
            if (!playerModes.enabled(mode)) continue;
            if (++modes > 1) {
                output.append(", ");
            }
            output.append(mode.ID).append('=').append(TomlHelper.toLiteral(playerModes.get(mode)));
        }
        output.append(" ]");
        CommandUtil.sendSuccess(source, "mode.query", player.m_5446_(), output.toString());
        return modes;
    }

    private static int runSet(CommandContext<CommandSourceStack> context, CrustMode<?> mode, @Nullable String valueArg, Collection<ServerPlayer> players) {
        for (ServerPlayer player : players) {
            mode.onCommand(context, valueArg, player);
        }
        String event = "mode." + (valueArg == null ? "disable" : "enable");
        if (players.size() == 1) {
            CommandUtil.sendSuccess((CommandSourceStack)context.getSource(), event + ".single", mode.ID, players.iterator().next().m_5446_());
        } else {
            CommandUtil.sendSuccess((CommandSourceStack)context.getSource(), event + ".multiple", mode.ID, players.size());
        }
        return players.size();
    }
}

