/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.common.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fathertoast.crust.api.portal.PortalBuilder;
import fathertoast.crust.common.command.CommandUtil;
import fathertoast.crust.common.command.impl.PortalTypeArgument;
import fathertoast.crust.common.portal.CrustPortals;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.Commands;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;

public class CrustPortalCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)CommandUtil.literal("crustportal").requires(CommandUtil::canCheat)).then(Commands.m_82129_((String)"portalType", (ArgumentType)PortalTypeArgument.portalType()).executes(context -> CrustPortalCommand.run((CommandSourceStack)context.getSource(), PortalTypeArgument.getPortalType((CommandContext<CommandSourceStack>)context, "portalType"), (Entity)((CommandSourceStack)context.getSource()).m_81375_()))));
    }

    private static int run(CommandSourceStack source, PortalBuilder portalBuilder, Entity target) {
        if (!portalBuilder.isValidDimension(target.m_9236_())) {
            CommandUtil.sendFailure(source, "portal.dimension", new Object[0]);
            return -1;
        }
        boolean failed = false;
        Direction forward = target.m_6350_();
        BlockPos.MutableBlockPos currentPos = target.m_20183_().m_122032_().m_122175_(forward, 3);
        if (currentPos.m_123342_() <= 0 || currentPos.m_123342_() >= target.m_9236_().m_151558_() - 5) {
            failed = true;
        } else if (CrustPortalCommand.isOpenSpace(target.m_9236_(), (BlockPos)currentPos)) {
            CrustPortalCommand.findGroundBelow(target.m_9236_(), currentPos);
        } else if (CrustPortalCommand.findGroundAbove(target.m_9236_(), currentPos)) {
            failed = true;
        }
        BlockPos pos = currentPos.m_7949_();
        if (failed) {
            CommandUtil.sendFailure(source, "portal", new Object[0]);
            return 0;
        }
        portalBuilder.generate(target.m_9236_(), currentPos, forward);
        CommandUtil.sendSuccess(source, "portal", CrustPortals.PORTAL_REGISTRY.get().getKey((Object)portalBuilder), pos.m_123341_(), pos.m_123342_(), pos.m_123343_());
        return 1;
    }

    private static void findGroundBelow(Level level, BlockPos.MutableBlockPos currentPos) {
        int yI = currentPos.m_123342_();
        int minY = Math.max(yI - 8, 0);
        while (currentPos.m_123342_() > minY) {
            currentPos.m_122184_(0, -1, 0);
            if (CrustPortalCommand.isOpenSpace(level, (BlockPos)currentPos)) continue;
            currentPos.m_122184_(0, 1, 0);
            return;
        }
        currentPos.m_142448_(yI);
    }

    private static boolean findGroundAbove(Level level, BlockPos.MutableBlockPos currentPos) {
        int yI = currentPos.m_123342_();
        int maxY = Math.min(yI + 8, level.m_151558_() - 5);
        while (currentPos.m_123342_() < maxY) {
            currentPos.m_122184_(0, 1, 0);
            if (!CrustPortalCommand.isOpenSpace(level, (BlockPos)currentPos)) continue;
            return false;
        }
        return true;
    }

    private static boolean isOpenSpace(Level level, BlockPos pos) {
        BlockState stateAtPos = level.m_8055_(pos);
        return (stateAtPos.m_247087_() || stateAtPos.m_204336_(BlockTags.f_13035_)) && !stateAtPos.m_60819_().m_205070_(FluidTags.f_13131_);
    }
}

