/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.common.command.impl;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import fathertoast.crust.common.command.CommandUtil;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectCategory;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;

public class CrustRecoverCommand {
    public static void register(CommandDispatcher<CommandSourceStack> dispatcher) {
        LiteralArgumentBuilder argBuilder = (LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)CommandUtil.literal("crustrecover").requires(CommandUtil::canCheat)).executes(context -> CrustRecoverCommand.run((CommandSourceStack)context.getSource(), Mode.ALL, CommandUtil.targets((CommandContext<CommandSourceStack>)context)))).then(CommandUtil.argumentTargets("targets").executes(context -> CrustRecoverCommand.run((CommandSourceStack)context.getSource(), Mode.ALL, CommandUtil.targets((CommandContext<CommandSourceStack>)context, "targets"))));
        for (Mode mode : Mode.values()) {
            argBuilder.then(((LiteralArgumentBuilder)CommandUtil.literal(mode).executes(context -> CrustRecoverCommand.run((CommandSourceStack)context.getSource(), mode, CommandUtil.targets((CommandContext<CommandSourceStack>)context)))).then(CommandUtil.argumentTargets("targets").executes(context -> CrustRecoverCommand.run((CommandSourceStack)context.getSource(), mode, CommandUtil.targets((CommandContext<CommandSourceStack>)context, "targets")))));
        }
        dispatcher.register(argBuilder);
    }

    private static int run(CommandSourceStack source, Mode mode, Collection<? extends Entity> targets) {
        for (Entity entity : targets) {
            if (!(entity instanceof LivingEntity)) continue;
            CrustRecoverCommand.recover((LivingEntity)entity, mode);
        }
        if (targets.size() == 1) {
            CommandUtil.sendSuccess(source, "recover.single." + CommandUtil.toString(mode), targets.iterator().next().m_5446_());
        } else {
            CommandUtil.sendSuccess(source, "recover.multiple." + CommandUtil.toString(mode), targets.size());
        }
        return targets.size();
    }

    private static void recover(LivingEntity target, Mode mode) {
        switch (mode) {
            case ALL: 
            case HEALTH: {
                target.m_5634_(target.m_21233_());
                if (mode != Mode.ALL) break;
            }
            case HUNGER: {
                if (target instanceof Player) {
                    Player player = (Player)target;
                    CrustRecoverCommand.recoverHunger(player);
                }
                if (mode != Mode.ALL) break;
            }
            case EFFECTS: {
                CrustRecoverCommand.clearNegativeEffects(target);
                if (mode == Mode.ALL) break;
            }
        }
    }

    private static void recoverHunger(Player player) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("foodLevel", 20);
        tag.m_128350_("foodSaturationLevel", 20.0f);
        player.m_36324_().m_38715_(tag);
    }

    private static void clearNegativeEffects(LivingEntity target) {
        ArrayList<MobEffect> negativeEffects = new ArrayList<MobEffect>();
        for (MobEffectInstance mobEffectInstance : target.m_21220_()) {
            if (mobEffectInstance.m_19544_().m_19483_() != MobEffectCategory.HARMFUL) continue;
            negativeEffects.add(mobEffectInstance.m_19544_());
        }
        for (MobEffect mobEffect : negativeEffects) {
            target.m_21195_(mobEffect);
        }
        target.m_20301_(target.m_6062_());
        target.m_20095_();
    }

    public static enum Mode {
        ALL,
        HEALTH,
        HUNGER,
        EFFECTS;

    }
}

