/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.common.core;

import fathertoast.crust.api.CrustPlugin;
import fathertoast.crust.api.ICrustPlugin;
import fathertoast.crust.api.config.common.ConfigManager;
import fathertoast.crust.api.config.common.value.environment.compat.ApocalypseDifficultyEnvironment;
import fathertoast.crust.common.api.impl.CrustApi;
import fathertoast.crust.common.command.impl.CrustArgumentTypes;
import fathertoast.crust.common.config.CrustConfig;
import fathertoast.crust.common.network.CrustPacketHandler;
import fathertoast.crust.common.portal.CrustPortals;
import fathertoast.crust.common.potion.CrustEffects;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="crust")
public class Crust {
    public static final Logger LOG = LogManager.getLogger((String)"crust");
    public static Crust INSTANCE;
    public final CrustApi apiInstance;
    public static final DeferredRegister<Block> BLOCK_REGISTRY;
    public static final DeferredRegister<Item> ITEM_REGISTRY;
    public static final DeferredRegister<BlockEntityType<?>> BE_REGISTRY;

    public Crust() {
        INSTANCE = this;
        this.apiInstance = new CrustApi();
        ApocalypseDifficultyEnvironment.register(this.apiInstance);
        CrustPacketHandler.registerMessages();
        ConfigManager.create("Crust", "crust");
        IEventBus modBus = FMLJavaModLoadingContext.get().getModEventBus();
        modBus.addListener(CrustPortals::onRegistryCreate);
        CrustEffects.register(modBus);
        CrustPortals.register(modBus);
        CrustArgumentTypes.register(modBus);
        BE_REGISTRY.register(modBus);
        BLOCK_REGISTRY.register(modBus);
        ITEM_REGISTRY.register(modBus);
        modBus.addListener(this::onCommonSetup);
    }

    private void onCommonSetup(FMLCommonSetupEvent event) {
        event.enqueueWork(() -> {
            CrustConfig.initialize();
            this.processPlugins();
        });
    }

    private void processPlugins() {
        ModList.get().getAllScanData().forEach(scanData -> scanData.getAnnotations().forEach(annotationData -> {
            if (annotationData.annotationType().getClassName().equals(CrustPlugin.class.getName())) {
                try {
                    Class<?> pluginClass = Class.forName(annotationData.memberName());
                    if (ICrustPlugin.class.isAssignableFrom(pluginClass)) {
                        ICrustPlugin plugin = (ICrustPlugin)pluginClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
                        plugin.onLoad(this.apiInstance);
                        LOG.info("Found Crust plugin at {} with plugin ID: {}", (Object)annotationData.memberName(), (Object)plugin.getId());
                    }
                }
                catch (Exception ex) {
                    LOG.error("Failed to load a Crust plugin! Plugin class: {}", (Object)annotationData.memberName());
                    ex.printStackTrace();
                }
            }
        }));
    }

    public static ResourceLocation resLoc(String path) {
        return new ResourceLocation("crust", path);
    }

    static {
        BLOCK_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"crust");
        ITEM_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"crust");
        BE_REGISTRY = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITY_TYPES, (String)"crust");
    }
}

