/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.common.core;

import fathertoast.crust.api.lib.CrustObjects;
import fathertoast.crust.common.network.CrustPacketHandler;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.EntityJoinLevelEvent;
import net.minecraftforge.event.entity.living.LivingFallEvent;
import net.minecraftforge.event.entity.living.LivingHurtEvent;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="crust")
public class CrustForgeEvents {
    private static final Set<ServerPlayer> NEED_CRUST_MODE_UPDATE = new HashSet<ServerPlayer>();
    private static int updateCounter;

    public static void markModesDirty(Player player) {
        NEED_CRUST_MODE_UPDATE.add((ServerPlayer)player);
    }

    @SubscribeEvent
    static void onEntityJoinWorld(EntityJoinLevelEvent event) {
        Entity entity;
        if (!event.getLevel().m_5776_() && (entity = event.getEntity()) instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)entity;
            CrustForgeEvents.markModesDirty((Player)serverPlayer);
        }
    }

    @SubscribeEvent
    static void onServerTick(TickEvent.ServerTickEvent event) {
        if (event.phase == TickEvent.Phase.END && ++updateCounter >= 3) {
            updateCounter = 0;
            if (!NEED_CRUST_MODE_UPDATE.isEmpty()) {
                for (ServerPlayer player : NEED_CRUST_MODE_UPDATE) {
                    CrustPacketHandler.sendCrustModesUpdate(player);
                }
                NEED_CRUST_MODE_UPDATE.clear();
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    static void onLivingHurt(LivingHurtEvent event) {
        Level level = event.getEntity().m_9236_();
        if (event.getEntity() != null && event.getSource().m_269415_() != level.m_269111_().m_269341_().m_269415_() && !event.getSource().m_269533_(DamageTypeTags.f_268413_) && event.getEntity().m_21023_(CrustObjects.vulnerability())) {
            MobEffectInstance vulnerability = event.getEntity().m_21124_(CrustObjects.vulnerability());
            if (vulnerability == null) {
                return;
            }
            event.setAmount(Math.max(event.getAmount() * (1.0f + 0.25f * (float)(vulnerability.m_19564_() + 1)), 0.0f));
        }
    }

    @SubscribeEvent(priority=EventPriority.NORMAL)
    static void onLivingFall(LivingFallEvent event) {
        if (event.getEntity() != null && event.getEntity().m_21023_(CrustObjects.weight())) {
            MobEffectInstance weight = event.getEntity().m_21124_(CrustObjects.weight());
            if (weight == null) {
                return;
            }
            event.setDamageMultiplier(event.getDamageMultiplier() * (1.0f + 0.3334f * (float)(weight.m_19564_() + 1)));
        }
    }
}

