/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.common.mode;

import fathertoast.crust.common.config.CrustConfig;
import fathertoast.crust.common.mode.CrustModes;
import fathertoast.crust.common.mode.CrustModesData;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.server.MinecraftServer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attribute;
import net.minecraft.world.entity.ai.attributes.AttributeInstance;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodData;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.ForgeMod;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.player.EntityItemPickupEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.server.ServerLifecycleHooks;

@Mod.EventBusSubscriber(modid="crust")
public class CrustModeEvents {
    public static final UUID SUPER_SPEED_UUID = UUID.fromString("B9766B69-9569-4202-BC1F-2EE2A276D836");
    private static final Map<ItemEntity, Double> MAGNET_PULL_MAP = new HashMap<ItemEntity, Double>();

    @SubscribeEvent
    static void onLivingDeath(LivingDeathEvent event) {
        Player player;
        LivingEntity livingEntity = event.getEntity();
        if (livingEntity instanceof Player && CrustModes.UNDYING.enabled(player = (Player)livingEntity)) {
            player.m_21153_(player.m_21233_());
            player.m_20301_(Math.max(player.m_20146_(), player.m_6062_()));
            FoodData playerFood = player.m_36324_();
            playerFood.m_38705_(Math.max(playerFood.m_38702_(), 6));
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    static void onItemPickup(EntityItemPickupEvent event) {
        Player player = event.getEntity();
        if (CrustModes.DESTROY_ON_PICKUP.enabled(player)) {
            event.getItem().m_32060_();
            event.getItem().m_146870_();
            player.m_9236_().m_6263_(null, player.m_20185_(), player.m_20186_(), player.m_20189_(), SoundEvents.f_12019_, SoundSource.PLAYERS, 0.2f, (player.m_217043_().m_188501_() - player.m_217043_().m_188501_()) * 1.4f + 2.0f);
            event.setResult(Event.Result.DENY);
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    static void onServerTick(TickEvent.ServerTickEvent event) {
        MinecraftServer server;
        if (event.phase == TickEvent.Phase.START && (server = ServerLifecycleHooks.getCurrentServer()) != null) {
            for (Level level : server.m_129785_()) {
                CrustModeEvents.onWorldTickStart(level);
            }
        }
    }

    @SubscribeEvent
    static void onPlayerTick(TickEvent.PlayerTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.side.isClient()) {
            return;
        }
        Player player = event.player;
        CrustModesData playerModes = CrustModesData.of(player);
        int clock32 = player.f_19797_ & 0x1F;
        int clock16 = clock32 & 0xF;
        int clock4 = clock32 & 3;
        if (clock4 == 3) {
            AttributeInstance moveSpeed = player.m_21051_(Attributes.f_22279_);
            AttributeInstance swimSpeed = player.m_21051_((Attribute)ForgeMod.SWIM_SPEED.get());
            if (moveSpeed != null) {
                moveSpeed.m_22120_(SUPER_SPEED_UUID);
                if (swimSpeed != null) {
                    swimSpeed.m_22120_(SUPER_SPEED_UUID);
                }
                if (player.m_20142_() && playerModes.enabled(CrustModes.SUPER_SPEED)) {
                    moveSpeed.m_22118_(new AttributeModifier(SUPER_SPEED_UUID, "Super speed mode", (double)(playerModes.get(CrustModes.SUPER_SPEED).floatValue() - 1.0f), AttributeModifier.Operation.MULTIPLY_TOTAL));
                    if (swimSpeed != null) {
                        swimSpeed.m_22118_(new AttributeModifier(SUPER_SPEED_UUID, "Super speed mode", (double)(playerModes.get(CrustModes.SUPER_SPEED).floatValue() - 1.0f), AttributeModifier.Operation.MULTIPLY_TOTAL));
                    }
                }
            }
        }
        if (clock16 == 5 && playerModes.enabled(CrustModes.UNEATING)) {
            byte minimum = playerModes.get(CrustModes.UNEATING);
            FoodData foodData = player.m_36324_();
            if (foodData.m_38702_() < minimum) {
                foodData.m_38707_(20, 0.125f);
            }
        } else if (clock16 == 13 && playerModes.enabled(CrustModes.SUPER_VISION)) {
            if (!player.m_21023_(MobEffects.f_19611_)) {
                player.m_7292_(new MobEffectInstance(MobEffects.f_19611_, -1, 0, true, false, false));
            }
            if (player.m_21023_(MobEffects.f_19610_)) {
                player.m_21195_(MobEffects.f_19610_);
            }
        }
        if (clock32 == 7 && playerModes.enabled(CrustModes.UNBREAKING)) {
            for (int s = 0; s < player.m_150109_().m_6643_(); ++s) {
                ItemStack item = player.m_150109_().m_8020_(s);
                if (item.m_41619_() || !item.m_41768_()) continue;
                item.m_41721_(0);
            }
        }
    }

    public static void onWorldTickStart(Level level) {
        if ((level.m_46467_() & 1L) == 0L) {
            return;
        }
        for (Player player : level.m_6907_()) {
            CrustModesData playerModes = CrustModesData.of(player);
            if (!playerModes.enabled(CrustModes.MAGNET)) continue;
            CrustModeEvents.onMagnetTick(player, playerModes.get(CrustModes.MAGNET).floatValue());
        }
        MAGNET_PULL_MAP.clear();
    }

    private static void onMagnetTick(Player player, float maxRange) {
        float rangeSqr = maxRange * maxRange;
        for (ItemEntity item : player.m_9236_().m_45976_(ItemEntity.class, player.m_20191_().m_82400_((double)maxRange))) {
            double distSq;
            if (!item.m_6084_() || item.m_32055_().m_41619_() || item.f_19797_ <= CrustConfig.MODES.MAGNET.delay.get() || !((distSq = player.m_20280_((Entity)item)) < (double)rangeSqr) || !CrustModeEvents.hasSpaceFor(player, item.m_32055_())) continue;
            CrustModeEvents.magnetPullItem(player, item, distSq, ((double)rangeSqr - distSq) / (double)rangeSqr);
        }
    }

    private static boolean hasSpaceFor(Player player, ItemStack item) {
        return player.m_150109_().m_36062_() >= 0 || player.m_150109_().m_36050_(item) >= 0;
    }

    private static void magnetPullItem(Player player, ItemEntity item, double distSq, double power) {
        Double closestDistSq = MAGNET_PULL_MAP.get(item);
        if (closestDistSq != null && closestDistSq < distSq) {
            return;
        }
        MAGNET_PULL_MAP.put(item, distSq);
        item.m_20256_(player.m_20299_(1.0f).m_82546_(item.m_20182_()).m_82541_().m_82490_(power * CrustConfig.MODES.MAGNET.maxSpeed.get()).m_82520_(0.0, 0.04, 0.0));
    }
}

