/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.common.mode;

import fathertoast.crust.common.config.CrustConfig;
import fathertoast.crust.common.mode.type.CrustByteMode;
import fathertoast.crust.common.mode.type.CrustFloatMode;
import fathertoast.crust.common.mode.type.CrustMode;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.world.effect.MobEffects;

public final class CrustModes {
    private static final Map<String, CrustMode<?>> MODE_REGISTRY = new HashMap();
    public static final CrustMode<Float> MAGNET = new CrustFloatMode("magnet", CrustConfig.MODES.GENERAL.magnetOpLevel::get, (player, value) -> value == null || value.floatValue() <= 0.0f ? null : Float.valueOf(Math.min(value.floatValue(), CrustConfig.MODES.MAGNET.maxRangeLimit.getFloat())));
    public static final CrustMode<Byte> UNDYING = new CrustByteMode("undying", CrustConfig.MODES.GENERAL.undyingOpLevel::get);
    public static final CrustMode<Byte> UNBREAKING = new CrustByteMode("unbreaking", CrustConfig.MODES.GENERAL.unbreakingOpLevel::get);
    public static final CrustMode<Byte> UNEATING = new CrustByteMode("uneating", CrustConfig.MODES.GENERAL.uneatingOpLevel::get, (player, value) -> value == null || value <= 0 ? null : Byte.valueOf((byte)Math.min(value.byteValue(), 20)));
    public static final CrustMode<Byte> SUPER_VISION = new CrustByteMode("vision", CrustConfig.MODES.GENERAL.visionOpLevel::get, (player, value) -> {
        if (value == null) {
            player.m_21195_(MobEffects.f_19611_);
        }
        return value;
    });
    public static final CrustMode<Float> SUPER_SPEED = new CrustFloatMode("speed", CrustConfig.MODES.GENERAL.speedOpLevel::get, (player, value) -> value == null || value.floatValue() <= 1.0f ? null : Float.valueOf(Math.min(value.floatValue(), CrustConfig.MODES.SPEED.speedLimit.getFloat())));
    public static final CrustMode<Byte> DESTROY_ON_PICKUP = new CrustByteMode("noPickup", CrustConfig.MODES.GENERAL.noPickupOpLevel::get);

    public static void register(CrustMode<?> mode) {
        if (MODE_REGISTRY.containsKey(mode.ID)) {
            throw new IllegalArgumentException("Cannot register duplicate mode id \"" + mode.ID + "\"!");
        }
        MODE_REGISTRY.put(mode.ID, mode);
    }

    @Nullable
    public static CrustMode<?> getMode(String id) {
        return MODE_REGISTRY.get(id);
    }

    public static Map<String, CrustMode<?>> registry() {
        return Collections.unmodifiableMap(MODE_REGISTRY);
    }
}

