/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.common.network;

import fathertoast.crust.common.mode.CrustModesData;
import fathertoast.crust.common.network.message.S2CDestroyItemOnPointer;
import fathertoast.crust.common.network.message.S2CUpdateCrustModes;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.network.NetworkDirection;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.NetworkRegistry;
import net.minecraftforge.network.simple.SimpleChannel;

public class CrustPacketHandler {
    private static final String PROTOCOL_VERSION = "0";
    public static final SimpleChannel CHANNEL = CrustPacketHandler.createChannel();
    private static int messageIndex;

    public static void sendDestroyItemOnPointerUpdate(ServerPlayer player) {
        CrustPacketHandler.sendToClient(player, new S2CDestroyItemOnPointer());
    }

    public static void sendCrustModesUpdate(ServerPlayer player) {
        CrustPacketHandler.sendToClient(player, new S2CUpdateCrustModes(CrustModesData.of((Player)player).getSaveTag()));
    }

    private static <MSG> void sendToClient(ServerPlayer player, MSG message) {
        CHANNEL.sendTo(message, player.f_8906_.f_9742_, NetworkDirection.PLAY_TO_CLIENT);
    }

    public static void registerMessages() {
        CrustPacketHandler.registerMessage(S2CUpdateCrustModes.class, S2CUpdateCrustModes::encode, S2CUpdateCrustModes::decode, S2CUpdateCrustModes::handle);
        CrustPacketHandler.registerMessage(S2CDestroyItemOnPointer.class, S2CDestroyItemOnPointer::encode, S2CDestroyItemOnPointer::decode, S2CDestroyItemOnPointer::handle);
    }

    private static <MSG> void registerMessage(Class<MSG> messageType, BiConsumer<MSG, FriendlyByteBuf> encoder, Function<FriendlyByteBuf, MSG> decoder, BiConsumer<MSG, Supplier<NetworkEvent.Context>> handler) {
        CHANNEL.registerMessage(messageIndex++, messageType, encoder, decoder, handler, Optional.empty());
    }

    private static SimpleChannel createChannel() {
        return NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("crust", "channel")).serverAcceptedVersions(PROTOCOL_VERSION::equals).clientAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    }
}

