/*
 * Decompiled with CFR 0.152.
 */
package fathertoast.crust.common.portal;

import com.google.common.collect.ImmutableSet;
import fathertoast.crust.api.portal.PortalBuilder;
import java.util.Set;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;

public class EndPortalBuilder
extends PortalBuilder {
    private static final Set<ResourceLocation> VALID_DIMENSIONS = ImmutableSet.of((Object)Level.f_46428_.m_135782_(), (Object)Level.f_46430_.m_135782_());

    @Override
    public boolean isValidDimension(ResourceLocation dimension) {
        return VALID_DIMENSIONS.contains(dimension);
    }

    @Override
    public void generate(Level level, BlockPos.MutableBlockPos currentPos, Direction forward) {
        Direction transverse = forward.m_122427_();
        currentPos.m_122175_(Direction.UP, -1);
        currentPos.m_122175_(transverse, -1);
        BlockPos portalCorner = currentPos.m_7949_();
        currentPos.m_122175_(transverse, -1);
        currentPos.m_122175_(forward, -1);
        BlockPos frameCorner = currentPos.m_7949_();
        for (int tv = 0; tv < 5; ++tv) {
            for (int fw = 0; fw < 5; ++fw) {
                if (!((tv == 0 || tv == 4) ^ (fw == 0 || fw == 4))) continue;
                currentPos.m_122190_((Vec3i)frameCorner).m_122175_(transverse, tv).m_122175_(forward, fw);
                BlockState frameBlock = (BlockState)((BlockState)Blocks.f_50258_.m_49966_().m_61124_((Property)BlockStateProperties.f_61433_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)EndPortalBuilder.endFrameFacing(forward, tv, fw));
                level.m_7731_((BlockPos)currentPos, frameBlock, 3);
            }
        }
        BlockState portalBlock = Blocks.f_50257_.m_49966_();
        for (int tv = 0; tv < 3; ++tv) {
            for (int fw = 0; fw < 3; ++fw) {
                currentPos.m_122190_((Vec3i)portalCorner).m_122175_(transverse, tv).m_122175_(forward, fw);
                level.m_7731_((BlockPos)currentPos, portalBlock, 3);
            }
        }
    }

    private static Direction endFrameFacing(Direction forward, int tv, int fw) {
        if (tv == 0) {
            return forward.m_122428_();
        }
        if (tv == 4) {
            return forward.m_122427_();
        }
        if (fw == 0) {
            return forward.m_122424_();
        }
        return forward;
    }
}

