/*
 * Decompiled with CFR 0.152.
 */
package insane96mcp.insanelib.base;

import insane96mcp.insanelib.base.Feature;
import insane96mcp.insanelib.base.LoadFeature;
import insane96mcp.insanelib.util.LogHelper;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.forgespi.language.ModFileScanData;
import org.objectweb.asm.Type;

public class Module {
    static final HashMap<ResourceLocation, Module> modules = new HashMap();
    private ForgeConfigSpec.ConfigValue<Boolean> enabledConfig;
    ForgeConfigSpec.Builder configBuilder;
    private boolean enabled;
    private boolean canBeDisabled;
    private final ResourceLocation id;
    private final String name;
    private String description = "";
    private final String modId;
    private final ModConfig.Type modConfigType;
    private static final Map<Class<? extends Feature>, Feature> loadedFeatures = new HashMap<Class<? extends Feature>, Feature>();
    private final Map<Class<? extends Feature>, Feature> features = new HashMap<Class<? extends Feature>, Feature>();
    static final Object _lock = new Object();
    private static final Type LOAD_FEATURE_TYPE = Type.getType(LoadFeature.class);

    Module(String modId, String moduleId, String name, ModConfig.Type modConfigType, ForgeConfigSpec.Builder configBuilder) {
        this.id = ResourceLocation.fromNamespaceAndPath((String)modId, (String)moduleId);
        this.name = name;
        this.enabled = true;
        this.canBeDisabled = true;
        this.modId = modId;
        this.modConfigType = modConfigType;
        this.configBuilder = configBuilder;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::readConfig);
    }

    public void setConfigBuilder(ForgeConfigSpec.Builder builder) {
        if (this.configBuilder == null) {
            this.configBuilder = builder;
        }
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public ResourceLocation getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public Map<Class<? extends Feature>, Feature> getFeatures() {
        return this.features;
    }

    public void loadConfig() {
        this.enabledConfig = this.canBeDisabled ? (!this.description.equals("") ? this.configBuilder.comment(this.description).define("Enable %s".formatted(this.name), this.enabled) : this.configBuilder.define("Enable %s".formatted(this.name), this.enabled)) : null;
    }

    public void readConfig(ModConfigEvent event) {
        if (event.getConfig().getType() != this.modConfigType || !event.getConfig().getModId().equals(this.modId)) {
            return;
        }
        this.enabled = this.canBeDisabled ? (Boolean)this.enabledConfig.get() : true;
        this.features.forEach((clazz, feature) -> feature.readConfig(event));
        this.features.forEach((clazz, feature) -> feature.postReadConfig(event));
    }

    public void pushConfig() {
        if (this.canBeDisabled) {
            if (this.description.isEmpty()) {
                this.configBuilder.push(this.getName());
            } else {
                this.configBuilder.comment(this.description).push(this.getName());
            }
        }
    }

    public void popConfig() {
        if (this.canBeDisabled) {
            this.configBuilder.pop();
        }
    }

    public static void loadFeatures(ModConfig.Type modConfigType, String modId, ClassLoader classLoader) {
        ArrayList<Module> moduleToLoad = new ArrayList<Module>();
        ModFileScanData modFileScanData = ModList.get().getModFileById(modId).getFile().getScanResult();
        modFileScanData.getAnnotations().stream().filter(annotationData -> LOAD_FEATURE_TYPE.equals((Object)annotationData.annotationType())).sorted(Comparator.comparing(d -> d.getClass().getName())).forEach(annotationData -> {
            try {
                Class<?> clazz;
                Map annotationDataMap = annotationData.annotationData();
                String moduleString = (String)annotationDataMap.get("module");
                ResourceLocation moduleId = ResourceLocation.parse((String)moduleString);
                Module module = modules.get(moduleId);
                if (module != null && module.modConfigType != modConfigType) {
                    return;
                }
                if (!modules.containsKey(moduleId)) {
                    LogHelper.warn("No module found with ID %s".formatted(moduleId), new Object[0]);
                    return;
                }
                Type type = annotationData.clazz();
                Class<?> featureClazz = clazz = Class.forName(type.getClassName(), false, classLoader);
                LogHelper.info("Found (%s) InsaneLib Feature class %s".formatted(modConfigType, type.getClassName()), new Object[0]);
                if (annotationDataMap.containsKey("requiresMods")) {
                    ArrayList requiresMods = (ArrayList)annotationDataMap.get("requiresMods");
                    for (String requiredModId : requiresMods) {
                        if (ModList.get().isLoaded(requiredModId)) continue;
                        LogHelper.info("Feature %s not loaded because %s is not present".formatted(type.getClassName(), requiredModId), new Object[0]);
                        return;
                    }
                }
                boolean enabledByDefault = true;
                if (annotationDataMap.containsKey("enabledByDefault")) {
                    enabledByDefault = (Boolean)annotationDataMap.get("enabledByDefault");
                }
                boolean canBeDisabled = true;
                if (annotationDataMap.containsKey("canBeDisabled")) {
                    canBeDisabled = (Boolean)annotationDataMap.get("canBeDisabled");
                }
                Feature feature = (Feature)clazz.getDeclaredConstructor(Module.class, Boolean.TYPE, Boolean.TYPE).newInstance(module, enabledByDefault, canBeDisabled);
                module.features.put(featureClazz, feature);
                loadedFeatures.put(featureClazz, feature);
                if (!moduleToLoad.contains(module)) {
                    moduleToLoad.add(module);
                }
            }
            catch (Exception e) {
                throw new RuntimeException("Failed to load Module %s".formatted(annotationData), e);
            }
        });
        moduleToLoad.forEach(m -> {
            m.pushConfig();
            m.getFeatures().forEach((clazz, feature) -> feature.loadConfig());
            m.popConfig();
        });
    }

    public static Map<Class<? extends Feature>, Feature> getAllLoadedFeatures() {
        return loadedFeatures;
    }

    public static Feature getFeature(Class<? extends Feature> featureClazz) {
        return loadedFeatures.get(featureClazz);
    }

    public static class Builder {
        private final Module module;

        private Builder(String modId, String id, String name, ModConfig.Type modConfigType, ForgeConfigSpec.Builder configBuilder) {
            this.module = new Module(modId, id, name, modConfigType, configBuilder);
        }

        public static Builder create(String modId, String id, String name, ModConfig.Type modConfigType, ForgeConfigSpec.Builder configBuilder) {
            return new Builder(modId, id, name, modConfigType, configBuilder);
        }

        public static Builder create(String id, String name, ModConfig.Type modConfigType, ForgeConfigSpec.Builder configBuilder) {
            String[] split = id.split(":");
            if (split.length != 2) {
                throw new IllegalArgumentException("id seems to not be a valid Resource Location. Must be modid:module_id");
            }
            return new Builder(split[0], split[1], name, modConfigType, configBuilder);
        }

        public Builder setDescription(String description) {
            this.module.description = description;
            return this;
        }

        public Builder canBeDisabled(boolean canBeDisabled) {
            this.module.canBeDisabled = canBeDisabled;
            return this;
        }

        public Builder enabledByDefault(boolean enabledByDefault) {
            this.module.enabled = enabledByDefault;
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Module build() {
            this.module.loadConfig();
            Object object = _lock;
            synchronized (object) {
                modules.putIfAbsent(this.module.id, this.module);
            }
            return this.module;
        }
    }
}

