/*
 * Decompiled with CFR 0.152.
 */
package com.stereowalker.unionlib;

import com.google.common.collect.Lists;
import com.mojang.blaze3d.platform.InputConstants;
import com.stereowalker.unionlib.UnionLibClientSegment;
import com.stereowalker.unionlib.api.collectors.ConfigCollector;
import com.stereowalker.unionlib.api.collectors.DefaultAttributeModifier;
import com.stereowalker.unionlib.api.collectors.PacketCollector;
import com.stereowalker.unionlib.api.creativetabs.CreativeTabPopulator;
import com.stereowalker.unionlib.api.keymaps.KeyMappingCollector;
import com.stereowalker.unionlib.api.registries.RegistryCollector;
import com.stereowalker.unionlib.client.gui.screens.config.ConfigScreen;
import com.stereowalker.unionlib.client.gui.screens.config.MinecraftModConfigsScreen;
import com.stereowalker.unionlib.client.gui.screens.inventory.UScreens;
import com.stereowalker.unionlib.config.Config;
import com.stereowalker.unionlib.config.ServerConfig;
import com.stereowalker.unionlib.config.tests.TestBindClass1Config;
import com.stereowalker.unionlib.config.tests.TestBindClass2Config;
import com.stereowalker.unionlib.config.tests.TestClassConfig;
import com.stereowalker.unionlib.config.tests.TestObjectConfig;
import com.stereowalker.unionlib.forge.PlatformHelper;
import com.stereowalker.unionlib.mod.ClientSegment;
import com.stereowalker.unionlib.mod.MinecraftMod;
import com.stereowalker.unionlib.mod.ModHandler;
import com.stereowalker.unionlib.mod.PacketHolder;
import com.stereowalker.unionlib.mod.ServerSegment;
import com.stereowalker.unionlib.network.protocol.game.ServerboundUnionInventoryPacket;
import com.stereowalker.unionlib.supporter.Supporters;
import com.stereowalker.unionlib.world.entity.ai.UAttributes;
import com.stereowalker.unionlib.world.inventory.UMenuType;
import com.stereowalker.unionlib.world.item.UItems;
import com.stereowalker.unionlib.world.item.crafting.URecipeSerializer;
import java.io.File;
import net.minecraft.client.KeyMapping;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Tuple;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.item.Item;
import net.minecraftforge.client.settings.IKeyConflictContext;
import net.minecraftforge.client.settings.KeyConflictContext;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.Mod;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

@Mod(value="unionlib")
public class UnionLib
extends MinecraftMod
implements PacketHolder {
    public static UnionLib instance;
    public static TestObjectConfig test_config;
    public static final Config CONFIG;
    public static final ServerConfig SERVER_CONFIG;
    public static final String MOD_ID = "unionlib";
    public static final Logger LOGGER;
    public static final String INVENTORY_KEY = "UnionInventory";

    public static void debug(Object message, boolean ignoreConfig) {
        if (UnionLib.CONFIG.debug || ignoreConfig) {
            LOGGER.info(message);
        }
    }

    public static void debug(Object message) {
        UnionLib.debug(message, false);
    }

    public static void warn(String message) {
        if (UnionLib.CONFIG.debug) {
            LOGGER.warn(message);
        }
    }

    public static boolean disableConfig() {
        return false;
    }

    public UnionLib() {
        super(MOD_ID, () -> new UnionLibClientSegment(), () -> new ServerSegment());
        instance = this;
    }

    @Override
    public void onModConstruct() {
        new MinecraftMod("concept_class", () -> new ClientSegment(){

            @Override
            public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
                return new ConfigScreen(previousScreen, TestClassConfig.class, (Component)Component.m_237115_((String)"Test Config 1"));
            }

            @Override
            public ResourceLocation getModIcon() {
                return UnionLib.this.location("textures/gui/test_1.png");
            }
        }, null, PlatformHelper.isDevEnvironment()){

            @Override
            public void setupConfigs(ConfigCollector collector) {
                collector.registerConfig(TestClassConfig.class);
            }
        };
        new MinecraftMod("concept_object", () -> new ClientSegment(){

            @Override
            public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
                return new ConfigScreen(previousScreen, test_config, (Component)Component.m_237115_((String)"Test Config 2"));
            }

            @Override
            public ResourceLocation getModIcon() {
                return UnionLib.this.location("textures/gui/test_2.png");
            }
        }, null, PlatformHelper.isDevEnvironment()){

            @Override
            public void setupConfigs(ConfigCollector collector) {
                collector.registerConfig(test_config);
            }
        };
        new MinecraftMod("concept_combined_config", () -> new ClientSegment(){

            @Override
            public Screen getConfigScreen(Minecraft mc, Screen previousScreen) {
                return new MinecraftModConfigsScreen(previousScreen, (Component)Component.m_237115_((String)"Test Config 3"), TestBindClass1Config.class, TestBindClass2Config.class);
            }

            @Override
            public ResourceLocation getModIcon() {
                return UnionLib.this.location("textures/gui/test_3.png");
            }
        }, null, PlatformHelper.isDevEnvironment()){

            @Override
            public void setupConfigs(ConfigCollector collector) {
                collector.registerConfig(TestBindClass1Config.class);
                collector.registerConfig(TestBindClass2Config.class);
            }
        };
        new MinecraftMod("concept_keys", () -> new ClientSegment(){

            @Override
            public void setupKeymappings(KeyMappingCollector collector) {
                collector.addKeyMapping(new KeyMapping("key.unionlib.test_bind", (IKeyConflictContext)KeyConflictContext.IN_GAME, InputConstants.Type.KEYSYM, 86, "DAD"));
            }

            @Override
            public ResourceLocation getModIcon() {
                return UnionLib.this.location("textures/gui/test_4.png");
            }
        }, null, PlatformHelper.isDevEnvironment());
    }

    @Override
    public void onModStartup() {
        MinecraftForge.EVENT_BUS.register((Object)this);
        PlatformHelper.handleEvents();
    }

    @Override
    public void onModStartupInClient() {
        PlatformHelper.handleClientEvents();
        Supporters.populateSupporters(new File(Minecraft.m_91087_().f_91069_, "supportercache.json"), true);
        if (!ModHandler.getLoadState().runsOnlyOnClient()) {
            UScreens.registerScreens();
        }
    }

    @Override
    public void setupConfigs(ConfigCollector collector) {
        collector.registerConfig(CONFIG);
        collector.registerConfig(SERVER_CONFIG);
    }

    @Override
    public void registerPackets(PacketCollector collector) {
        collector.registerServerboundPacket(ServerboundUnionInventoryPacket.id, ServerboundUnionInventoryPacket.class, packetBuffer -> new ServerboundUnionInventoryPacket((FriendlyByteBuf)packetBuffer));
    }

    @Override
    public void populateCreativeTabs(CreativeTabPopulator builder) {
        if (builder.isToolTab()) {
            builder.addItems(Lists.newArrayList((Object[])new Item[]{UItems.GOLDEN_RING, UItems.IRON_EMERALD_NECKALCE}));
        }
    }

    @Override
    public void setupRegistries(RegistryCollector collector) {
        collector.addRegistryHolder(UAttributes.class);
        collector.addRegistryHolder(UItems.class);
        collector.addRegistryHolder(UMenuType.class);
        collector.addRegistryHolder(URecipeSerializer.class);
    }

    @Override
    public void modifyDefaultEntityAttributes(DefaultAttributeModifier modifier) {
        modifier.addToEntity((EntityType<? extends LivingEntity>)EntityType.f_20532_, UAttributes.CRITICAL_DAMAGE, UAttributes.CRITICAL_RATE, UAttributes.DIG_SPEED, UAttributes.ACCURACY, UAttributes.ARROW_VELOCITY, UAttributes.ARROW_DAMAGE);
        double draw = Modulo.Default_Bow_Draw_Speed.isActive() ? 4.0 : 1.0;
        modifier.addToEntityWithValues((EntityType<? extends LivingEntity>)EntityType.f_20524_, UAttributes.DRAW_SPEED, draw);
        modifier.addToEntityWithValues((EntityType<? extends LivingEntity>)EntityType.f_20532_, UAttributes.DRAW_SPEED, draw);
        modifier.addToEntityWithValues((EntityType<? extends LivingEntity>)EntityType.f_20481_, Lists.newArrayList((Object[])new Tuple[]{new Tuple((Object)UAttributes.DRAW_SPEED, (Object)draw)}));
    }

    static {
        test_config = new TestObjectConfig();
        CONFIG = new Config();
        SERVER_CONFIG = new ServerConfig();
        LOGGER = LogManager.getLogger((String)MOD_ID);
    }

    public static enum Modulo {
        Accessory_Inventory,
        Default_Bow_Draw_Speed;

        private boolean isEnabled = false;

        public void enable() {
            this.isEnabled = true;
        }

        public void disable() {
            this.isEnabled = false;
        }

        public boolean isActive() {
            return this.isEnabled;
        }
    }

    public static class Locations {
        public static final ResourceLocation UNION_BUTTON_IMAGE = new ResourceLocation("unionlib", "textures/gui/union_button.png");
        public static final ResourceLocation OVERLAY_BUTTON_IMAGE_BACKGROUND = new ResourceLocation("unionlib", "textures/gui/button_background.png");
        public static final ResourceLocation EMPTY_ACCESSORY_SLOT_NECKLACE = new ResourceLocation("unionlib", "item/empty_accessory_slot_necklace");
        public static final ResourceLocation EMPTY_ACCESSORY_SLOT_BACK = new ResourceLocation("unionlib", "item/empty_accessory_slot_back");
        public static final ResourceLocation EMPTY_ACCESSORY_SLOT_RING = new ResourceLocation("unionlib", "item/empty_accessory_slot_ring");
        public static final ResourceLocation UNION_INVENTORY_BACKGROUND = new ResourceLocation("unionlib", "textures/gui/container/union_inventory.png");
    }

    @Deprecated
    public static class Modules {
        public static boolean isAccessoryInventoryEnabled() {
            return Modulo.Accessory_Inventory.isActive();
        }

        public static void enableAccessoryInventory() {
            Modulo.Accessory_Inventory.enable();
        }

        public static void disableAccessoryInventory() {
            Modulo.Accessory_Inventory.disable();
        }

        public static boolean isDefaultDrawSpeedAppliedToBows() {
            return Modulo.Default_Bow_Draw_Speed.isActive();
        }

        public static void applyDefaultDrawSpeedToBows() {
            Modulo.Default_Bow_Draw_Speed.enable();
        }

        public static void removeDefaultDrawSpeedToBows() {
            Modulo.Default_Bow_Draw_Speed.disable();
        }
    }
}

